/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.service;

import br.com.maximasolutions.administrativo.service.SincronizacaoErpService;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.form.VendaPdvForm;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.repository.VendaProdutoFaturamentoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.financeiro.dto.MovimentoCaixaDto;
import br.com.maximasolutions.financeiro.form.MovimentoCaixaForm;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentacaoEntradaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.sat.repository.SatCFeItemRepository;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class SincronizacaoErpServiceImpl
implements SincronizacaoErpService {
    private final String URL = "http://" + MaximaConfig.getInstance().getProperty("servidor_ip", "localhost") + ":8082/";
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private VendaProdutoItemRepository vendaProdutoItemRepository;
    @Autowired
    private VendaProdutoFaturamentoRepository vendaProdutoFaturamentoRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;
    @Autowired
    private MovimentacaoEntradaRepository movimentacaoEntradaRepository;
    @Autowired
    private SatCFeItemRepository cupomItemRepository;

    public void sincronizaErp(VendaProduto venda) throws MaximaValidacaoException {
        MovimentoCaixa movimentoCaixa = (venda = (VendaProduto)this.vendaProdutoRepository.findById((Object)venda.getId()).get()).getMovimentoCaixa();
        if (movimentoCaixa.getUuid() == null) {
            movimentoCaixa.setUuid(UUID.randomUUID().toString());
            movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)movimentoCaixa);
            venda.setMovimentoCaixa(movimentoCaixa);
        }
        VendaPdvForm vendaPdvForm = new VendaPdvForm();
        vendaPdvForm.setVendaProduto(venda);
        vendaPdvForm.setItens(this.vendaProdutoItemRepository.listaPorVenda(venda.getId().longValue()));
        vendaPdvForm.setFaturamentos(this.vendaProdutoFaturamentoRepository.lista(venda.getId()));
        vendaPdvForm.setContaReceber(venda.getContaReceber());
        List parcelas = this.contaReceberParcelaRepository.listPorContaReceber(venda.getContaReceber().getId().longValue());
        for (ContaReceberParcela parc : parcelas) {
            List recebimentos = this.movimentacaoEntradaRepository.listByContaReceberParcela(parc.getId().longValue());
            parc.setRecebimentos(recebimentos);
        }
        vendaPdvForm.setParcelas(parcelas);
        if (venda.getSatCFe() != null) {
            vendaPdvForm.setCupom(venda.getSatCFe());
            vendaPdvForm.setCupomItens(this.cupomItemRepository.listaPorCupom(venda.getSatCFe().getId()));
        }
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity responseEntityStr = restTemplate.postForEntity(this.URL + "vendas", (Object)vendaPdvForm, Object.class, new Object[0]);
            if (responseEntityStr.getStatusCode().is2xxSuccessful()) {
                venda.setSincronizadoErp(Boolean.TRUE);
                venda = (VendaProduto)this.vendaProdutoRepository.save((Object)venda);
                System.out.println("--- venda id: " + venda.getId());
            }
        }
        catch (RestClientException restClientException) {
            Logger.getLogger(SincronizacaoErpServiceImpl.class.getSimpleName()).log(Level.SEVERE, null, restClientException);
            throw new MaximaValidacaoException("Falha na sicroniza\u00e7\u00e3o da venda.\n" + restClientException.getLocalizedMessage());
        }
        catch (Exception restClientException) {
            Logger.getLogger(SincronizacaoErpServiceImpl.class.getSimpleName()).log(Level.SEVERE, null, restClientException);
            throw new MaximaValidacaoException("Falha na sicroniza\u00e7\u00e3o da venda.\n" + restClientException.getLocalizedMessage());
        }
    }

    private void sincronizaMovimentoCaixa() {
        List movimentoCaixas = this.movimentoCaixaRepository.listaSincronizarErp();
        if (movimentoCaixas == null || movimentoCaixas.isEmpty()) {
            return;
        }
        movimentoCaixas.forEach(movimentoCaixa -> {
            try {
                movimentoCaixa.setPdvId(movimentoCaixa.getId());
                RestTemplate restTemplate = new RestTemplate();
                URI uri = new URI(this.URL + "movimentoCaixa");
                ResponseEntity result = restTemplate.postForEntity(uri, (Object)new MovimentoCaixaForm(movimentoCaixa), MovimentoCaixaDto.class);
                if (result.getStatusCodeValue() == 200) {
                    MovimentoCaixaDto movimentoCaixaDto = (MovimentoCaixaDto)result.getBody();
                    if (movimentoCaixaDto != null) {
                        movimentoCaixa.setErpId(movimentoCaixaDto.getId());
                    }
                    movimentoCaixa.setSincronizadoErp(Boolean.TRUE);
                    this.movimentoCaixaRepository.save(movimentoCaixa);
                }
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(SincronizacaoErpServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }
}

