/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.EmpresaService;
import br.com.maximasolutions.administrativo.service.SincronizacaoPdvService;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.financeiro.modelo.Caixa;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Empresa;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.geral.service.EstadoService;
import br.com.maximasolutions.geral.service.MunicipioService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
@Transactional
public class SincronizacaoPdvServiceImpl
implements SincronizacaoPdvService {
    @Autowired
    private EstadoService estadoService;
    @Autowired
    private MunicipioService municipioService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private CentroCustoService centroCustoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private UnidadeService unidadeService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private EmpresaService empresaService;
    @Autowired
    private CaixaService caixaService;
    @Autowired
    private CondicaoRecebimentoService condicaoRecebimentoService;
    private final String URL = "http://" + MaximaConfig.getInstance().getProperty("servidor_ip", "localhost") + ":8082/";

    public Boolean sincronizaPDV() {
        Boolean sucesso = true;
        System.out.println("========== 1");
        sucesso = this.sincronizaEstados();
        if (!sucesso.booleanValue()) {
            return false;
        }
        System.out.println("========== 21");
        this.sincronizaMunicipios();
        System.out.println("========== 3");
        this.sincronizaEmpresas();
        System.out.println("========== 4");
        this.sincronizaCaixas();
        System.out.println("========== 5");
        System.out.println("========== 6");
        this.sincronizaCentroCustos();
        System.out.println("========== 7");
        this.sincronizaCondicaoRecebimentos();
        System.out.println("========== 8");
        this.sincronizaUnidades();
        System.out.println("========== 9");
        this.sincronizaCategoriaProduto();
        System.out.println("========== 01");
        this.sincronizaProdutos();
        System.out.println("======= finalizou -------");
        return sucesso;
    }

    private Boolean sincronizaProdutos() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "produtos", Produto[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (Produto produto : (Produto[])response.getBody()) {
            System.out.println("== produto: " + produto.getNome());
            try {
                this.produtoService.save(produto);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private Boolean sincronizaCategoriaProduto() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "categoriaProdutos", CategoriaProduto[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (CategoriaProduto categoriaProduto : (CategoriaProduto[])response.getBody()) {
            try {
                this.categoriaProdutoService.save(categoriaProduto);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private Boolean sincronizaConfiguracao() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "/configuracao", Configuracao.class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        Configuracao configuracao = (Configuracao)response.getBody();
        if (configuracao != null) {
            try {
                this.configuracaoService.save(configuracao);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private Boolean sincronizaUnidades() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "unidades", Unidade[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (Unidade unidade : (Unidade[])response.getBody()) {
            try {
                this.unidadeService.save(unidade);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private Boolean sincronizaCentroCustos() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "centroCustos", CentroCusto[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (CentroCusto centroCusto : (CentroCusto[])response.getBody()) {
            try {
                this.centroCustoService.save(centroCusto);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private Boolean sincronizaClientes() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "clientes", Cliente[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (Cliente cliente : (Cliente[])response.getBody()) {
            try {
                this.clienteService.save(cliente);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }

    private Boolean sincronizaMunicipios() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "municipios", Municipio[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (Municipio municipio : (Municipio[])response.getBody()) {
            try {
                this.municipioService.save(municipio);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private Boolean sincronizaEstados() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "estados", Estado[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (Estado estado : (Estado[])response.getBody()) {
            try {
                this.estadoService.save(estado);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private Boolean sincronizaEmpresas() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "empresas", Empresa[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (Empresa empresa : (Empresa[])response.getBody()) {
            try {
                this.empresaService.save(empresa);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private Boolean sincronizaCondicaoRecebimentos() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "condicaoRecebimentos", CondicaoRecebimento[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (CondicaoRecebimento condicaoRecebimento : (CondicaoRecebimento[])response.getBody()) {
            try {
                this.condicaoRecebimentoService.save(condicaoRecebimento);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    private Boolean sincronizaCaixas() {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = null;
        try {
            response = restTemplate.getForEntity(this.URL + "caixas", Caixa[].class, new Object[0]);
        }
        catch (RestClientException restClientException) {
            return false;
        }
        if (response == null || response.getBody() == null) {
            return false;
        }
        for (Caixa caixa : (Caixa[])response.getBody()) {
            try {
                this.caixaService.save(caixa);
            }
            catch (MaximaException ex) {
                Logger.getLogger(SincronizacaoPdvServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }
}

