/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.service;

import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfil;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfilItem;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfilItemAcao;
import br.com.maximasolutions.administrativo.repository.UsuarioPerfilItemAcaoRepository;
import br.com.maximasolutions.administrativo.repository.UsuarioPerfilItemRepository;
import br.com.maximasolutions.administrativo.repository.UsuarioPerfilRepository;
import br.com.maximasolutions.administrativo.service.UsuarioPerfilService;
import br.com.maximasolutions.core.MaximaException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class UsuarioPerfilServiceImpl
implements UsuarioPerfilService {
    @Autowired
    private UsuarioPerfilRepository usuarioPerfilRepository;
    @Autowired
    private UsuarioPerfilItemRepository perfilItemRepository;
    @Autowired
    private UsuarioPerfilItemAcaoRepository perfilItemAcaoRepository;

    @Transactional(readOnly=true)
    public List<UsuarioPerfil> list() {
        return this.usuarioPerfilRepository.lista();
    }

    @Transactional(readOnly=true)
    public UsuarioPerfil load(long id) {
        return (UsuarioPerfil)this.usuarioPerfilRepository.getOne((Object)id);
    }

    public UsuarioPerfil save(UsuarioPerfil perfil, List<UsuarioPerfilItem> controles) throws MaximaException {
        perfil = (UsuarioPerfil)this.usuarioPerfilRepository.save((Object)perfil);
        for (UsuarioPerfilItem item : controles) {
            UsuarioPerfilItem itemAdd;
            if (item.getId() == null) {
                if (item.getExcluida().booleanValue()) continue;
                item.setPerfil(perfil);
                itemAdd = (UsuarioPerfilItem)this.perfilItemRepository.save((Object)item);
            } else {
                UsuarioPerfilItem itemBD = (UsuarioPerfilItem)this.perfilItemRepository.getOne((Object)item.getId());
                this.perfilItemAcaoRepository.delete(item.getId());
                if (item.getExcluida().booleanValue()) {
                    this.perfilItemRepository.delete((Object)item);
                    continue;
                }
                itemBD.setControle(item.getControle());
                itemAdd = (UsuarioPerfilItem)this.perfilItemRepository.save((Object)itemBD);
            }
            String descricao = "";
            if (item.getAcoes() != null) {
                for (PermissaoControleAcao acao : item.getAcoes()) {
                    UsuarioPerfilItemAcao perfilItemAcao = new UsuarioPerfilItemAcao();
                    perfilItemAcao.setPerfilItem(itemAdd);
                    perfilItemAcao.setAcao(acao);
                    perfilItemAcao = (UsuarioPerfilItemAcao)this.perfilItemAcaoRepository.save((Object)perfilItemAcao);
                    if (!descricao.isEmpty()) {
                        descricao = descricao + " | ";
                    }
                    descricao = descricao + perfilItemAcao.getAcao();
                }
            }
            item.setDescricao(descricao);
            this.perfilItemRepository.save((Object)item);
        }
        return perfil;
    }

    public void deleteById(Long id) {
        this.usuarioPerfilRepository.deleteById((Object)id);
    }

    public List<UsuarioPerfilItem> lista(UsuarioPerfil perfil) {
        return this.perfilItemRepository.lista(perfil.getId());
    }

    public List<PermissaoControleAcao> permissaoControleAcaos(UsuarioPerfilItem perfilItem) {
        List acoes = this.perfilItemAcaoRepository.lista(perfilItem.getId());
        ArrayList<PermissaoControleAcao> retorno = new ArrayList<PermissaoControleAcao>();
        acoes.forEach(a -> retorno.add(a.getAcao()));
        return retorno;
    }
}

