/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.service;

import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.Usuario;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfil;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfilItem;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfilItemAcao;
import br.com.maximasolutions.administrativo.repository.UsuarioPerfilItemAcaoRepository;
import br.com.maximasolutions.administrativo.repository.UsuarioPerfilItemRepository;
import br.com.maximasolutions.administrativo.repository.UsuarioRepository;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.core.MaximaException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class UsuarioServiceImpl
implements UsuarioService {
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private UsuarioPerfilItemRepository perfilItemRepository;
    @Autowired
    private UsuarioPerfilItemAcaoRepository perfilItemAcaoRepository;

    public Usuario authenticate(String login, String password) {
        Usuario user = this.findByLogin(login);
        if (user == null) {
            return null;
        }
        if (password.equalsIgnoreCase(user.getSenha())) {
            return user;
        }
        return null;
    }

    public Usuario findByLogin(String login) {
        return this.usuarioRepository.findByLogin(login);
    }

    @Transactional(readOnly=true)
    public List<Usuario> list() {
        return this.usuarioRepository.list();
    }

    @Transactional(readOnly=true)
    public Usuario load(long id) {
        return (Usuario)this.usuarioRepository.getOne((Object)id);
    }

    public Usuario save(Usuario usuario) throws MaximaException {
        Usuario existe = this.usuarioRepository.findByLogin(usuario.getLogin());
        if (usuario.getId() == null && existe != null) {
            throw new MaximaException("Login j\u00e1 cadastrado no sistema.");
        }
        if (existe != null && !usuario.getId().equals(existe.getId())) {
            throw new MaximaException("Login j\u00e1 cadastrado no sistema.");
        }
        return (Usuario)this.usuarioRepository.save((Object)usuario);
    }

    public void deleteById(Long id) {
        this.usuarioRepository.deleteById((Object)id);
    }

    public List<Usuario> pesquisa(String valor) {
        return this.usuarioRepository.pesquisa("%" + valor + "%");
    }

    public List<UsuarioPerfilItem> permissoes(Usuario usuario) {
        ArrayList<UsuarioPerfilItem> retorno = new ArrayList<UsuarioPerfilItem>();
        if (usuario == null || usuario.getPerfil() == null) {
            return retorno;
        }
        return this.perfilItemRepository.lista(usuario.getPerfil().getId());
    }

    public List<UsuarioPerfilItemAcao> acoes(Usuario usuario, PermissaoControle controle) {
        if (usuario.getPerfil() == null) {
            return new ArrayList<UsuarioPerfilItemAcao>();
        }
        UsuarioPerfilItem perfilItem = this.getPerfilControle(usuario.getPerfil(), controle);
        if (perfilItem == null) {
            return new ArrayList<UsuarioPerfilItemAcao>();
        }
        ArrayList acoes = this.perfilItemAcaoRepository.lista(perfilItem.getId());
        if (acoes == null) {
            acoes = new ArrayList();
        }
        return acoes;
    }

    public UsuarioPerfilItem getPerfilControle(UsuarioPerfil perfil, PermissaoControle controle) {
        return this.perfilItemRepository.get(perfil.getId(), controle);
    }
}

