/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.administrativo.service;

import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.api.bean.ClienteStatusJson;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.serializer.LocalDateDeserializer;
import br.com.maximasolutions.serializer.LocalDateTimeDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaValidacaoException.class})
public class ValidacaoServiceImpl
implements ValidacaoService {
    public ClienteStatusJson valida(String chave) throws MaximaValidacaoException {
        String path = MaximaConfig.getInstance().getProperty("servidor_url", "http://www.maximasis.com.br/admin/");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        Request request = new Request.Builder().url(path + "api/cliente/status?chave=" + chave).get().build();
        OkHttpClient client = new OkHttpClient();
        String jsonString = null;
        try {
            Response response = client.newCall(request).execute();
            if (response.code() != 200) {
                if (this.validaMensalidadeEmDia()) {
                    ClienteStatusJson retorno = new ClienteStatusJson();
                    retorno.setCliente("");
                    retorno.setCnpj("");
                    retorno.setMotivo("FALHA COMUNICA\u00c7\u00c3O COM O SERVIDOR");
                    retorno.setStatus("500");
                    return retorno;
                }
                throw new MaximaValidacaoException("AVISO: Entre em contato com o suporte.");
            }
            if (response.body() != null) {
                jsonString = response.body().string();
            }
        }
        catch (IOException ex) {
            if (this.validaMensalidadeEmDia()) {
                ClienteStatusJson retorno = new ClienteStatusJson();
                retorno.setCliente("");
                retorno.setCnpj("");
                retorno.setMotivo("FALHA COMUNICA\u00c7\u00c3O COM O SERVIDOR");
                retorno.setStatus("500");
                return retorno;
            }
            throw new MaximaValidacaoException("AVISO: Entre em contato com o suporte.");
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer());
        gsonBuilder.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeDeserializer());
        Gson gson = gsonBuilder.setPrettyPrinting().create();
        return (ClienteStatusJson)gson.fromJson(jsonString, ClienteStatusJson.class);
    }

    private boolean validaMensalidadeEmDia() throws MaximaValidacaoException {
        boolean mensalidadeEmDia = true;
        if (mensalidadeEmDia) {
            return true;
        }
        throw new MaximaValidacaoException("AVISO: Falha na comunica\u00e7\u00e3o com o servidor.");
    }
}

