/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.config;

import br.com.maximasolutions.config.SpringFXMLLoader;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.AES;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.logging.ExceptionWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ResourceBundle;
import javafx.stage.Stage;
import javax.sql.DataSource;
import javax.validation.Validator;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyJpaImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
public class AppJavaConfig {
    @Autowired
    SpringFXMLLoader springFXMLLoader;

    @Bean
    @Scope(value="prototype")
    public ExceptionWriter exceptionWriter() {
        return new ExceptionWriter((Writer)new StringWriter());
    }

    @Bean
    public ResourceBundle resourceBundle() {
        return ResourceBundle.getBundle("Bundle");
    }

    @Bean
    @Lazy(value=true)
    public StageManager stageManager(Stage stage) throws IOException {
        return new StageManager(this.springFXMLLoader, stage);
    }

    @Bean
    public Validator validatorFactory() {
        return new LocalValidatorFactoryBean();
    }

    @Bean
    public DataSource getDataSource() {
        String senha;
        String user;
        DataSourceBuilder dataSourceBuilder = DataSourceBuilder.create();
        String url = MaximaConfig.getInstance().getProperty("banco_url");
        if (url == null || url.isEmpty()) {
            MaximaAlert.alerta((String)"Sistema n\u00e3o pode ser inicializado.\nPropriedade 'banco_url' n\u00e3o configurada.");
            System.exit(0);
        }
        if ((user = MaximaConfig.getInstance().getProperty("banco_usuario")) == null || user.isEmpty()) {
            MaximaAlert.alerta((String)"Sistema n\u00e3o pode ser inicializado.\nPropriedade 'banco_usuario' n\u00e3o configurada.");
            System.exit(0);
        }
        if ((senha = MaximaConfig.getInstance().getProperty("banco_senha")) == null || senha.isEmpty()) {
            MaximaAlert.alerta((String)"Sistema n\u00e3o pode ser inicializado.\nPropriedade 'banco_senha' n\u00e3o configurada.");
            System.exit(0);
        }
        dataSourceBuilder.url(url);
        dataSourceBuilder.driverClassName("com.mysql.jdbc.Driver");
        dataSourceBuilder.username(user);
        String senhaValida = AES.decrypt((String)senha, (String)"maxima6459");
        dataSourceBuilder.password(senhaValida);
        return dataSourceBuilder.build();
    }

    @Bean
    public PhysicalNamingStrategy physical() {
        String tipoBanco = MaximaConfig.getInstance().getProperty("banco_tipo", "");
        if (tipoBanco.equalsIgnoreCase("underline")) {
            return null;
        }
        return new PhysicalNamingStrategyStandardImpl();
    }

    @Bean
    public ImplicitNamingStrategy implicit() {
        String tipoBanco = MaximaConfig.getInstance().getProperty("banco_tipo", "");
        if (tipoBanco.equalsIgnoreCase("underline")) {
            return null;
        }
        return new ImplicitNamingStrategyLegacyJpaImpl();
    }
}

