/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.config;

import br.com.maximasolutions.administrativo.modelo.Usuario;
import br.com.maximasolutions.config.SpringFXMLLoader;
import br.com.maximasolutions.view.FxmlView;
import java.io.IOException;
import java.util.Objects;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageManager {
    private static final Logger LOG = LoggerFactory.getLogger(StageManager.class);
    private final Stage primaryStage;
    private final SpringFXMLLoader springFXMLLoader;
    private Usuario usuario;
    private HostServices hostServices;

    public void setGetHostController(HostServices hostServices) {
        this.hostServices = hostServices;
    }

    public HostServices getHostServices() {
        return this.hostServices;
    }

    public StageManager(SpringFXMLLoader springFXMLLoader, Stage stage) {
        this.springFXMLLoader = springFXMLLoader;
        this.primaryStage = stage;
    }

    public void switchScene(FxmlView view) {
        Parent viewRootNodeHierarchy = this.loadViewNodeHierarchy(view.getFxmlFile());
        this.show(viewRootNodeHierarchy, view.getTitle());
    }

    private void show(Parent rootnode, String title) {
        Scene scene = this.prepareScene(rootnode);
        this.primaryStage.setTitle(title);
        this.primaryStage.setScene(scene);
        this.primaryStage.sizeToScene();
        this.primaryStage.centerOnScreen();
        try {
            this.primaryStage.show();
        }
        catch (Exception exception) {
            this.logAndExit("Unable to show scene for title" + title, exception);
        }
    }

    private Scene prepareScene(Parent rootnode) {
        Scene scene = this.primaryStage.getScene();
        if (scene == null) {
            scene = new Scene(rootnode);
        }
        scene.setRoot(rootnode);
        return scene;
    }

    public Parent loadViewNodeHierarchy(String fxmlFilePath) {
        Parent rootNode = null;
        try {
            rootNode = this.springFXMLLoader.load(fxmlFilePath);
            Objects.requireNonNull(rootNode, "A Root FXML node must not be null");
        }
        catch (IOException exception) {
            this.logAndExit("Unable to load FXML view" + fxmlFilePath, (Exception)exception);
        }
        return rootNode;
    }

    public FXMLLoader loader(String fxmlFilePath) {
        FXMLLoader loader = null;
        try {
            loader = this.springFXMLLoader.loader(fxmlFilePath);
        }
        catch (IOException exception) {
            this.logAndExit("Unable to load FXML view" + fxmlFilePath, (Exception)exception);
        }
        return loader;
    }

    private void logAndExit(String errorMsg, Exception exception) {
        LOG.error(errorMsg, (Object)exception, (Object)exception.getCause());
        Platform.exit();
    }

    public SpringFXMLLoader getSpringFXMLLoader() {
        return this.springFXMLLoader;
    }

    public Stage getStage() {
        return this.primaryStage;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }
}

