/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class GetCodigoController
extends MaximaController
implements Initializable {
    @FXML
    private Label label;
    @FXML
    private TextField tfCodigo;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnFechar;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private String codigo;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.codigo = null;
        this.tfCodigo.setText("");
        this.tfCodigo.requestFocus();
    }

    public void setLabel(String descricao) {
        this.label.setText(descricao);
    }

    public void setValor(String valor) {
        this.tfCodigo.setText(valor);
    }

    public String getCodigo() {
        return this.codigo;
    }

    private void confirma() {
        this.codigo = MaximaUtils.getText((String)this.tfCodigo.getText());
        this.fechar();
    }

    private void fechar() {
        Stage form = (Stage)this.btnSalva.getScene().getWindow();
        form.close();
    }

    private boolean validaForm(String codigoVenda) {
        boolean valido = true;
        if (codigoVenda == null || codigoVenda.isEmpty()) {
            this.tfCodigo.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCodigo.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnFechar.setGraphic((Node)new MaximaIcone().cancel_24());
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> {
            this.codigo = null;
            this.fechar();
        });
        this.btnSalva.setOnAction(event -> this.confirma());
        this.btnSalva.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
        this.tfCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
    }
}

