/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class GetNumeroFormController
extends MaximaController
implements Initializable {
    @FXML
    private Label label;
    @FXML
    private TextField tfCodigoVenda;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnFechar;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private Long numero;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.numero = null;
        this.tfCodigoVenda.setText("");
        this.tfCodigoVenda.requestFocus();
    }

    public void setLabel(String descricao) {
        this.label.setText(descricao);
    }

    public void setValor(String valor) {
        this.tfCodigoVenda.setText(valor);
    }

    public Long getNumero() {
        return this.numero;
    }

    private void confirma() {
        String codigoVenda = MaximaUtils.getText((String)this.tfCodigoVenda.getText());
        if (!this.validaForm(codigoVenda)) {
            return;
        }
        try {
            this.numero = Long.parseLong(codigoVenda);
        }
        catch (NumberFormatException numberFormatException) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00famero informado inv\u00e1ildo.");
            return;
        }
        this.fechar();
    }

    private void fechar() {
        Stage form = (Stage)this.btnSalva.getScene().getWindow();
        form.close();
    }

    private boolean validaForm(String codigoVenda) {
        boolean valido = true;
        if (codigoVenda == null || codigoVenda.isEmpty()) {
            this.tfCodigoVenda.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCodigoVenda.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnFechar.setGraphic((Node)new MaximaIcone().cancel_24());
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> {
            this.numero = null;
            this.fechar();
        });
        this.btnSalva.setOnAction(event -> this.confirma());
        this.btnSalva.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
        this.tfCodigoVenda.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
    }
}

