/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class GetValorFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfValor;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private BigDecimal valor;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaMascaras();
    }

    public void inicializa() {
        this.valor = null;
        this.tfValor.setText("");
        this.tfValor.requestFocus();
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    private void confirma() {
        String codigoVenda = MaximaUtils.getText((String)this.tfValor.getText());
        if (!this.validaForm(codigoVenda)) {
            return;
        }
        this.valor = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText());
        if (this.valor == null || this.valor.compareTo(BigDecimal.ZERO) <= 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Informe um valor v\u00e1lido.");
            return;
        }
        Stage form = (Stage)this.tfValor.getScene().getWindow();
        form.close();
    }

    private boolean validaForm(String codigoVenda) {
        boolean valido = true;
        if (codigoVenda == null || codigoVenda.isEmpty()) {
            this.tfValor.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfValor.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValor);
    }

    private void carregaIcones() {
    }

    private void registraAcoes() {
        this.tfValor.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
    }
}

