/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.controller;

import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.Unidade;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;

public class ImportacaoProdutoDto {
    private Long id;
    private String nome;
    private BigDecimal ultimoCusto;
    private BigDecimal precoVenda;
    private String codigo;
    private Long unidadeId;
    private String cfop;
    private String cstEntrada;
    private String cstSaida;
    private String ncm;
    private Boolean balanca;
    private String referencia;
    private Long categoriaId;
    private BigDecimal estoqueAtual;
    private LocalDate dataCadastro;

    public Produto converter(CategoriaProduto categoriaProduto, Unidade unidade) {
        Produto produto = new Produto();
        produto.setId(null);
        produto.setAgrupar(Boolean.valueOf(true));
        produto.setAtivo(Boolean.valueOf(true));
        produto.setBalanca(Boolean.valueOf(false));
        produto.setCategoria(categoriaProduto.getNome());
        produto.setCategoriaProduto(categoriaProduto);
        produto.setCodigo(this.codigo.trim());
        produto.setReferencia("");
        produto.setCofins(NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_ISENTA_CONTRIBUICAO);
        produto.setComissao(BigDecimal.ZERO);
        produto.setDescontoPermitido(BigDecimal.ZERO);
        produto.setEstoqueAtual(this.estoqueAtual);
        produto.setEstoqueInicial(BigDecimal.ZERO);
        produto.setEstoqueMinimo(BigDecimal.ZERO);
        produto.setEstoqueNegativo(Boolean.valueOf(true));
        produto.setUltimaAlteracao(LocalDateTime.now());
        produto.setNcm(this.ncm.trim());
        produto.setNome(this.nome.trim());
        produto.setOrigem(NFOrigem.NACIONAL);
        produto.setPis(NFNotaInfoSituacaoTributariaPIS.OPERACAO_ISENTA_CONTRIBUICAO);
        produto.setPrecoVenda(this.precoVenda);
        produto.setQuantidadeMinimaVenda(BigDecimal.ZERO);
        produto.setServico(Boolean.valueOf(false));
        produto.setUltimoCusto(this.ultimoCusto);
        produto.setUnidade(unidade);
        produto.setUuid(UUID.randomUUID().toString());
        produto.setCfop("5405");
        produto.setCfopInterEstad("6403");
        produto.setIcmsSN(NFNotaSituacaoOperacionalSimplesNacional.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA_SUBSIDIO_OU_POR_ANTECIPACAO);
        return produto;
    }

    public Long getId() {
        return this.id;
    }

    public String getNome() {
        return this.nome;
    }

    public BigDecimal getUltimoCusto() {
        return this.ultimoCusto;
    }

    public BigDecimal getPrecoVenda() {
        return this.precoVenda;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public Long getUnidadeId() {
        return this.unidadeId;
    }

    public String getCfop() {
        return this.cfop;
    }

    public String getCstEntrada() {
        return this.cstEntrada;
    }

    public String getCstSaida() {
        return this.cstSaida;
    }

    public String getNcm() {
        return this.ncm;
    }

    public Boolean getBalanca() {
        return this.balanca;
    }

    public String getReferencia() {
        return this.referencia;
    }

    public Long getCategoriaId() {
        return this.categoriaId;
    }

    public BigDecimal getEstoqueAtual() {
        return this.estoqueAtual;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setUltimoCusto(BigDecimal ultimoCusto) {
        this.ultimoCusto = ultimoCusto;
    }

    public void setPrecoVenda(BigDecimal precoVenda) {
        this.precoVenda = precoVenda;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setUnidadeId(Long unidadeId) {
        this.unidadeId = unidadeId;
    }

    public void setCfop(String cfop) {
        this.cfop = cfop;
    }

    public void setCstEntrada(String cstEntrada) {
        this.cstEntrada = cstEntrada;
    }

    public void setCstSaida(String cstSaida) {
        this.cstSaida = cstSaida;
    }

    public void setNcm(String ncm) {
        this.ncm = ncm;
    }

    public void setBalanca(Boolean balanca) {
        this.balanca = balanca;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    public void setCategoriaId(Long categoriaId) {
        this.categoriaId = categoriaId;
    }

    public void setEstoqueAtual(BigDecimal estoqueAtual) {
        this.estoqueAtual = estoqueAtual;
    }

    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }
}

