/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.controller;

import br.com.maximasolutions.Projeto;
import br.com.maximasolutions.administrativo.controller.LoginController;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.estoque.controller.PedidoVendaFormController;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ModuloController
implements Initializable {
    @FXML
    private Button btnRetaguarda;
    @FXML
    private Button btnVenda;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ValidacaoService validacaoService;

    public void initialize(URL location, ResourceBundle resources) {
        this.registraAcoes();
    }

    private void registraAcoes() {
        this.btnRetaguarda.setOnAction(evt -> this.retaguardaForm());
        this.btnVenda.setOnAction(evt -> {});
    }

    private void retaguardaForm() {
        try {
            Stage stage = new MaximaDialogFX().createFrame(this.stageManager, "/fxml/Login.fxml", "M\u00e1xima ERP - Acesso Restrito");
            LoginController controller = (LoginController)stage.getUserData();
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de retaguarda");
        }
    }

    private void pedidoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowVBox(this.stageManager, "/fxml/estoque/vendaProduto/PedidoVendaForm.fxml", "PEDIDO - M\u00c1XIMA ERP");
            PedidoVendaFormController controller = (PedidoVendaFormController)stage.getUserData();
            controller.inicializaPedido();
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(Projeto.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de pedidos");
        }
    }
}

