/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.UsuarioPerfilItem;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.ManutencaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.ClienteImportaDto;
import br.com.maximasolutions.controller.ImportacaoProdutoDto;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.service.BoletoTecnospeedService;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import br.com.maximasolutions.fiscal.modelo.NFeDestinatario;
import br.com.maximasolutions.fiscal.modelo.NFeEmitente;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.geral.service.FornecedorService;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.nfe.service.NotaFiscalService;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.sat.xml.modelo.CFeImpressao;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFProtocolo;
import com.fincatto.documentofiscal.nfe400.classes.NFProtocoloInfo;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoEmitente;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaProcessada;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Controller
public class PrincipalController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ManutencaoService manutencaoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private BoletoTecnospeedService tecnospeedService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private MunicipioService municipioService;
    @Autowired
    private NotaFiscalService notaFiscalService;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private SatCFeService satCFeService;
    private Configuracao conf;
    @FXML
    private TabPane tabPane;
    @FXML
    private VBox vBox;
    @FXML
    private MenuBar menuBar;
    @FXML
    private Menu menuVendasExternas;
    @FXML
    private Menu menuAdministrativo;
    @FXML
    private Menu menuGeral;
    @FXML
    private Menu menuEstoque;
    @FXML
    private Menu menuFinanceiro;
    @FXML
    private Menu menuFiscal;
    @FXML
    private Menu mnGeralParam;
    @FXML
    private Menu mnEstoqueParam;
    @FXML
    private Menu mnFinanceiroParam;
    @FXML
    private Menu mnFiscalParam;
    @FXML
    private Menu mnRelVendasExternas;
    @FXML
    private Menu mnRelGeral;
    @FXML
    private Menu mnRelEstoque;
    @FXML
    private Menu mnRelCompras;
    @FXML
    private Menu mnRelVendas;
    @FXML
    private Menu mnRelFinanceiro;
    @FXML
    private Menu menuFood;
    @FXML
    private MenuItem mnUsuario;
    @FXML
    private MenuItem mnConfiguracao;
    @FXML
    private MenuItem mnEmpresa;
    @FXML
    private MenuItem mnUsuarioPerfil;
    @FXML
    private MenuItem mnMunicipio;
    @FXML
    private MenuItem mnEstado;
    @FXML
    private MenuItem mnCategoriaCliente;
    @FXML
    private MenuItem mnCliente;
    @FXML
    private MenuItem mnFornecedor;
    @FXML
    private MenuItem mnVendedor;
    @FXML
    private MenuItem mnTransportadora;
    @FXML
    private MenuItem mnVeiculo;
    @FXML
    private MenuItem mnUnidade;
    @FXML
    private MenuItem mnBaixaProdutoMotivo;
    @FXML
    private MenuItem mnMateriaPrima;
    @FXML
    private MenuItem mnEntradaMateriaPrima;
    @FXML
    private MenuItem mnCategoriaProduto;
    @FXML
    private MenuItem mnProduto;
    @FXML
    private MenuItem mnVendaProduto;
    @FXML
    private MenuItem mnOrcamento;
    @FXML
    private MenuItem mnDevolucao;
    @FXML
    private MenuItem mnBaixaProduto;
    @FXML
    private MenuItem mnProdutoComplemento;
    @FXML
    private MenuItem mnProdutoObservacao;
    @FXML
    private MenuItem mnEntradaProduto;
    @FXML
    private MenuItem mnEstoqueBalanco;
    @FXML
    private MenuItem mnSincronizaFood;
    @FXML
    private MenuItem mnComandas;
    @FXML
    private MenuItem mnCadastroDepartamentoImpressora;
    @FXML
    private MenuItem mnBancoBoleto;
    @FXML
    private MenuItem mnCondicaoRecebimento;
    @FXML
    private MenuItem mnCentroCusto;
    @FXML
    private MenuItem mnMensalidade;
    @FXML
    private MenuItem mnMovimentoCaixa;
    @FXML
    private MenuItem mnContaReceber;
    @FXML
    private MenuItem mnRecebimentos;
    @FXML
    private MenuItem mnBoletoEmitido;
    @FXML
    private MenuItem mnBoletoBaixa;
    @FXML
    private MenuItem mnExtratoCliente;
    @FXML
    private MenuItem mnContaPagar;
    @FXML
    private MenuItem mnPagamentos;
    @FXML
    private MenuItem mnConfiguracaoFiscalEntradaSaida;
    @FXML
    private MenuItem mnContador;
    @FXML
    private MenuItem mnFiscalProduto;
    @FXML
    private MenuItem mnCertificadoDigital;
    @FXML
    private MenuItem mnNcm;
    @FXML
    private MenuItem mnNotaFiscal;
    @FXML
    private MenuItem mnNFCe;
    @FXML
    private MenuItem mnSatCFe;
    @FXML
    private MenuItem mnArquivoFiscal;
    @FXML
    private MenuItem mnXmlContabilidade;
    @FXML
    private MenuItem mnVendedorProdutoLancamento;
    @FXML
    private MenuItem mnVendedorProduto;
    @FXML
    private MenuItem mnPedidoVendaExterna;
    @FXML
    private MenuItem mnRelatorioInventario;
    @FXML
    private MenuItem mnRelatorioProdutos;
    @FXML
    private MenuItem mnRelatorioProdutosTabelaPreco;
    @FXML
    private MenuItem mnRelatorioProdutosEstoqueBaixo;
    @FXML
    private MenuItem mnRelatorioVenda;
    @FXML
    private MenuItem mnRelatorioVendaPorDia;
    @FXML
    private MenuItem mnRelatorioVendaProduto;
    @FXML
    private MenuItem mnRelatorioVendasCategorias;
    @FXML
    private MenuItem mnGraficoVenda;
    @FXML
    private MenuItem mnRelatorioAniversariantes;
    @FXML
    private MenuItem mnRelatorioCompra;
    @FXML
    private MenuItem mnRelatorioCompraProduto;
    @FXML
    private MenuItem mnRelatorioCompraMateriaPrimaProduto;
    @FXML
    private MenuItem mnRelatorioRecebimento;
    @FXML
    private MenuItem mnRelatorioPagamento;
    @FXML
    private MenuItem mnRelatorioContaReceber;
    @FXML
    private MenuItem mnRelatorioContaPagar;
    @FXML
    private MenuItem mnRelatorioSangria;
    @FXML
    private MenuItem mnRelatorioVendasExternas;
    @FXML
    private MenuItem mnRelatorioVendasExternasItens;
    @FXML
    private MenuItem mnRelatorioEstoqueVendedor;
    @FXML
    private MenuItem mnRelatorioCliente;
    @FXML
    private MenuItem mnRelatorioNotaFiscal;
    @FXML
    private MenuItem mnRelatorioNotaFiscalProdutos;
    @FXML
    private MenuItem mnRelatorioVendaProdutoCategoriaVendedor;
    @FXML
    private MenuItem mnRelatorioVendaProdutoCategoriaCliente;
    @FXML
    private MenuItem mnRelatorioSAT;
    @FXML
    private MenuItem mnEntregadores;
    @FXML
    private MenuItem mnGarcons;
    @FXML
    private MenuItem mnRelatorioFiscalProdutos;
    @FXML
    private MenuItem mnRelatorioComandaItemCancelado;
    @FXML
    private MenuItem mnRelatorioComandasCanceldas;
    @FXML
    private MenuItem mnRelatorioVendaProdutoCategoria;
    @FXML
    private Button btnClientes;
    @FXML
    private Button btnProdutos;
    @FXML
    private Button btnVendas;
    @FXML
    private Button btnRecebimentos;
    @FXML
    private Button btnNotaFiscal;

    public void initialize(URL location, ResourceBundle resources) {
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
        this.vBox.setPrefWidth(screenBounds.getWidth());
        this.vBox.setPrefHeight(screenBounds.getHeight() - 30.0);
        this.carregaIcones();
        this.registraAcoes();
    }

    public void inicializa() {
    }

    private void registraAcoes() {
        this.desabilitaTudo();
        this.carregaMenus();
        this.carregaBotoes();
        this.configuraMenu();
        this.carregaAtalhos();
    }

    private void desabilitaVendasExternas() {
        if (MaximaConfig.menuVendasExternas().booleanValue()) {
            this.menuVendasExternas.setVisible(true);
            this.mnRelVendasExternas.setVisible(true);
        } else {
            this.menuVendasExternas.setVisible(false);
            this.mnRelVendasExternas.setVisible(false);
        }
    }

    private void desabilitaFiscalRegimeNormal() {
    }

    private void desabilitaMensalidade() {
        if (MaximaConfig.menuMensalidade().booleanValue()) {
            this.mnMensalidade.setVisible(true);
        } else {
            this.mnMensalidade.setVisible(false);
        }
    }

    private void desabilitaMateriaPrima() {
        if (MaximaConfig.menuMateriaPrima().booleanValue()) {
            this.mnMateriaPrima.setVisible(true);
            this.mnEntradaMateriaPrima.setVisible(true);
        } else {
            this.mnMateriaPrima.setVisible(false);
            this.mnEntradaMateriaPrima.setVisible(false);
        }
    }

    private void desabilitaFood() {
        if (MaximaConfig.menuFood().booleanValue()) {
            this.menuFood.setVisible(true);
        } else {
            this.menuFood.setVisible(false);
        }
    }

    private void configuraMenu() {
        this.desabilitaVendasExternas();
        this.desabilitaMensalidade();
        this.desabilitaMateriaPrima();
        this.desabilitaFood();
        List permissoes = this.usuarioService.permissoes(this.stageManager.getUsuario());
        this.menuBar.getMenus().forEach(menu -> menu.getItems().forEach(item -> {
            if (item instanceof Menu) {
                Menu subMenu = (Menu)item;
                subMenu.getItems().forEach(si -> {
                    for (UsuarioPerfilItem i : permissoes) {
                        if (!i.getControle().getMenu().equals(si.getId())) continue;
                        si.setDisable(false);
                    }
                });
            } else {
                for (UsuarioPerfilItem i : permissoes) {
                    if (!i.getControle().getMenu().equals(item.getId())) continue;
                    item.setDisable(false);
                }
            }
        }));
        for (UsuarioPerfilItem i : permissoes) {
            if (i.getControle().equals((Object)PermissaoControle.Cliente)) {
                this.btnClientes.setDisable(false);
            }
            if (i.getControle().equals((Object)PermissaoControle.Produto)) {
                this.btnProdutos.setDisable(false);
            }
            if (i.getControle().equals((Object)PermissaoControle.VendaProduto)) {
                this.btnVendas.setDisable(false);
            }
            if (i.getControle().equals((Object)PermissaoControle.Recebimento)) {
                this.btnRecebimentos.setDisable(false);
            }
            if (!i.getControle().equals((Object)PermissaoControle.NotaFiscal)) continue;
            this.btnNotaFiscal.setDisable(false);
        }
        this.desabilitaFiscalRegimeNormal();
    }

    private void carregaAtalhos() {
        this.vBox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F9) {
                if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja gerar o arquivo remessa?")) {
                    return;
                }
                try {
                    this.tecnospeedService.geraRemessa();
                    MaximaAlert.informe((StageManager)this.stageManager, (String)"Remessa gerada com sucesso.");
                }
                catch (MaximaValidacaoException ex) {
                    Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                }
            }
            if (event.getCode() == KeyCode.F11) {
                this.produtoService.atualizaFornecedor();
            }
            if (event.getCode() == KeyCode.F12) {
                File file = new File("C:/Maxima/lider/sat");
                for (File arq : file.listFiles()) {
                    try {
                        String xmlTxt = this.readFile(arq.getAbsolutePath(), StandardCharsets.UTF_8);
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        dbf.setNamespaceAware(true);
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        ByteArrayInputStream is = new ByteArrayInputStream(xmlTxt.getBytes());
                        Document doc = db.parse(is);
                        NodeList raizes = doc.getChildNodes();
                        org.w3c.dom.Node raiz = raizes.item(0);
                        CFeImpressao impressao = new CFeImpressao(raiz);
                        this.satCFeService.importa(impressao, xmlTxt);
                    }
                    catch (IOException ex) {
                        System.out.println("--- erro ao ler o arquivo --");
                    }
                    catch (ParserConfigurationException ex) {
                        Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                        System.out.println("--- erro ao ler o arquivo --");
                    }
                    catch (SAXException ex) {
                        Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                        System.out.println("--- erro ao ler o arquivo --");
                    }
                }
            }
        });
    }

    String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return encoding.decode(ByteBuffer.wrap(encoded)).toString();
    }

    private void carregaBotoes() {
        this.btnClientes.setOnAction(t -> this.abreAba("tabCliente", "/fxml/geral/cliente/Clientes.fxml", "Lista de Clientes"));
        this.btnProdutos.setOnAction(t -> this.abreAba("tabProduto", "/fxml/estoque/produto/Produto.fxml", "Lista de Produtos"));
        this.btnVendas.setOnAction(t -> this.abreAba("tabVendaProduto", "/fxml/estoque/vendaProduto/VendaProduto.fxml", "Lista de Vendas"));
        this.btnRecebimentos.setOnAction(t -> this.abreAba("tabRecebimentos", "/fxml/financeiro/movimentacaoEntrada/MovimentacaoEntrada.fxml", "Recebimentos"));
        this.btnNotaFiscal.setOnAction(t -> this.abreAba("tabNotaFiscal", "/fxml/fiscal/nfe/NotaFiscal.fxml", "Nota Fiscal NF-e"));
    }

    private void carregaMenus() {
        this.mnUsuario.setOnAction(event -> this.abreAba("tabUsuario", "/fxml/administrativo/usuario/Usuarios.fxml", "Usu\u00e1rios"));
        this.mnUsuarioPerfil.setOnAction(event -> this.abreAba("tabUsuarioPerfil", "/fxml/administrativo/usuarioPerfil/UsuarioPerfil.fxml", "Perfil de Usu\u00e1rio"));
        this.mnEmpresa.setOnAction(event -> this.abreAba("tabEmpresa", "/fxml/administrativo/empresa/EmpresaForm.fxml", "Cadastro da Empresa"));
        this.mnConfiguracao.setOnAction(event -> this.abreAba("tabConfiguracao", "/fxml/administrativo/configuracao/ConfiguracaoForm.fxml", "Configura\u00e7\u00f5es Gerais"));
        this.mnEstado.setOnAction(event -> this.abreAba("tabEstado", "/fxml/geral/estado/Estados.fxml", "Estados (UF)"));
        this.mnMunicipio.setOnAction(event -> this.abreAba("tabMunicipio", "/fxml/geral/municipio/Municipios.fxml", "Munic\u00edpios"));
        this.mnCliente.setOnAction(event -> this.abreAba("tabCliente", "/fxml/geral/cliente/Clientes.fxml", "Clientes"));
        this.mnFornecedor.setOnAction(event -> this.abreAba("tabFornecedor", "/fxml/geral/fornecedor/Fornecedores.fxml", "Fornecedores"));
        this.mnVendedor.setOnAction(event -> this.abreAba("tabVendedor", "/fxml/geral/vendedor/Vendedores.fxml", "Vendedores"));
        this.mnTransportadora.setOnAction(event -> this.abreAba("tabTransportadora", "/fxml/geral/transportadora/Transportadora.fxml", "Transportadoras"));
        this.mnVeiculo.setOnAction(event -> this.abreAba("tabVeiculo", "/fxml/geral/veiculo/Veiculo.fxml", "Ve\u00edculos"));
        this.mnUnidade.setOnAction(event -> this.abreAba("tabUnidade", "/fxml/estoque/unidade/Unidades.fxml", "Tipos de Unidade"));
        this.mnBaixaProdutoMotivo.setOnAction(event -> this.abreAba("tabBaixaProdutoMotivo", "/fxml/estoque/baixaProdutoMotivo/BaixaProdutoMotivo.fxml", "Motivos Baixa de Estoque"));
        this.mnMateriaPrima.setOnAction(event -> this.abreAba("tabMateriaPrima", "/fxml/estoque/materiaPrima/MateriaPrima.fxml", "Lista de Mat\u00e9ria Prima"));
        this.mnEntradaMateriaPrima.setOnAction(event -> this.abreAba("tabEntradaMateriaPrima", "/fxml/estoque/entradaMateriaPrima/EntradaMateriaPrima.fxml", "Compras Mat\u00e9ria Prima"));
        this.mnCategoriaProduto.setOnAction(event -> this.abreAba("tabCategoriaProduto", "/fxml/estoque/categoriaProduto/CategoriaProduto.fxml", "Categorias de Produto"));
        this.mnProduto.setOnAction(event -> this.abreAba("tabProduto", "/fxml/estoque/produto/Produto.fxml", "Lista de Produtos"));
        this.mnProdutoComplemento.setOnAction(event -> this.abreAba("tabProdutoComplemento", "/fxml/estoque/produtoComplemento/ProdutoComplemento.fxml", "Lista de Complementos"));
        this.mnProdutoObservacao.setOnAction(event -> this.abreAba("tabProdutoObservacao", "/fxml/estoque/produtoObservacao/ProdutoObservacao.fxml", "Lista de Observa\u00e7\u00f5es"));
        this.mnEntradaProduto.setOnAction(event -> this.abreAba("tabEntradaProduto", "/fxml/estoque/entradaProduto/EntradaProduto.fxml", "Compras Produto"));
        this.mnVendaProduto.setOnAction(event -> this.abreAba("tabVendaProduto", "/fxml/estoque/vendaProduto/VendaProduto.fxml", "Vendas"));
        this.mnOrcamento.setOnAction(event -> this.abreAba("tabOrcamentos", "/fxml/estoque/orcamento/Orcamentos.fxml", "Or\u00e7amentos"));
        this.mnBaixaProduto.setOnAction(event -> this.abreAba("tabBaixaProduto", "/fxml/estoque/baixaProduto/BaixaProduto.fxml", "Lista de Baixas de Estoque"));
        this.mnEstoqueBalanco.setOnAction(event -> this.abreAba("tabEstoqueBalanco", "/fxml/estoque/estoqueBalanco/EstoqueBalanco.fxml", "Balan\u00e7os Estoque"));
        this.mnSincronizaFood.setOnAction(event -> this.abreAba("tabSincronizaCardapioDelivery", "/fxml/food/SincronizaFood.fxml", "Sincronizar Card\u00e1pios"));
        this.mnComandas.setOnAction(event -> this.abreAba("tabCadastroMesas", "/fxml/food/mesa/Comandas.fxml", "Lista de Comandas"));
        this.mnCadastroDepartamentoImpressora.setOnAction(event -> this.abreAba("tabCadastroDepartamentoImpressora", "/fxml/food/departamentoImpressora/DepartamentoImpressora.fxml", "Lista de Departamentos/Impressoras"));
        this.mnBancoBoleto.setOnAction(event -> this.abreAba("tabBancoBoleto", "/fxml/financeiro/bancoBoleto/BancoBoleto.fxml", "Bancos Boleto"));
        this.mnCondicaoRecebimento.setOnAction(event -> this.abreAba("tabCondicaoRecebimentoo", "/fxml/financeiro/condicaoRecebimento/CondicaoRecebimento.fxml", "Condi\u00e7\u00f5es de Recebimentos"));
        this.mnCentroCusto.setOnAction(event -> this.abreAba("tabCentroCusto", "/fxml/financeiro/centroCusto/CentroCusto.fxml", "Centros de Custos"));
        this.mnMensalidade.setOnAction(event -> this.abreAba("tabMensalidade", "/fxml/financeiro/mensalidade/Mensalidade.fxml", "Mensalidades"));
        this.mnMovimentoCaixa.setOnAction(event -> this.abreAba("tabMovimentoCaixa", "/fxml/financeiro/movimentoCaixa/MovimentoCaixa.fxml", "Movimentos de Caixa"));
        this.mnContaReceber.setOnAction(event -> this.abreAba("tabContaReceber", "/fxml/financeiro/contaReceber/ContaReceber.fxml", "Contas a Receber"));
        this.mnRecebimentos.setOnAction(event -> this.abreAba("tabRecebimentos", "/fxml/financeiro/movimentacaoEntrada/MovimentacaoEntrada.fxml", "Recebimentos"));
        this.mnExtratoCliente.setOnAction(event -> this.abreAba("tabExtratoCliente", "/fxml/financeiro/extratoCliente/ExtratoCliente.fxml", "Extrato Cliente"));
        this.mnBoletoEmitido.setOnAction(event -> this.abreAba("tabBoletoEmitido", "/fxml/financeiro/boletoEmitido/BoletoEmitido.fxml", "Boletos Emitidos"));
        this.mnBoletoBaixa.setOnAction(event -> this.abreAba("tabBoletoBaixa", "/fxml/financeiro/contaReceber/BoletoBaixaForm.fxml", "Baixa de Boletos"));
        this.mnContaPagar.setOnAction(event -> this.abreAba("tabContaPagar", "/fxml/financeiro/contaPagar/ContaPagar.fxml", "Contas a Pagar"));
        this.mnPagamentos.setOnAction(event -> this.abreAba("tabPagamentos", "/fxml/financeiro/movimentacaoSaida/MovimentacaoSaida.fxml", "Pagamentos"));
        this.mnNcm.setOnAction(event -> this.abreAba("tabNcm", "/fxml/fiscal/ncm/Ncm.fxml", "Lista de NCMs"));
        this.mnConfiguracaoFiscalEntradaSaida.setOnAction(event -> this.abreAba("tabConfiguracaoFiscalEntradaSaida", "/fxml/fiscal/configuracaoFiscalEntradaSaida/ConfiguracaoFiscalEntradaSaida.fxml", "Configura\u00e7\u00e3o Fiscal Entrada - Sa\u00edda"));
        this.mnCertificadoDigital.setOnAction(event -> this.abreAba("tabCertificadoDigital", "/fxml/fiscal/certificado/CertificadoForm.fxml", "Certificado Digital"));
        this.mnContador.setOnAction(event -> this.abreAba("tabContador", "/fxml/fiscal/contador/Contadores.fxml", "Contadores"));
        this.mnFiscalProduto.setOnAction(event -> this.abreAba("tabProdutoFiscal", "/fxml/fiscal/produtoFiscal/ProdutoFiscal.fxml", "Padr\u00e3o Fiscal"));
        this.mnSatCFe.setOnAction(event -> this.abreAba("tabSatCFe", "/fxml/fiscal/satcfe/SatCFe.fxml", "Cupom Fiscal SAT"));
        this.mnNFCe.setOnAction(event -> this.abreAba("tabNFCe", "/fxml/fiscal/nfce/NFCe.fxml", "Nota Consumidor Fiscal (NFCe)"));
        this.mnNotaFiscal.setOnAction(event -> this.abreAba("tabNotaFiscal", "/fxml/fiscal/nfe/NotaFiscal.fxml", "Nota Fiscal NF-e"));
        this.mnArquivoFiscal.setOnAction(event -> this.abreAba("tabArquivoFiscal", "/fxml/fiscal/arquivoFiscal/ArquivoFiscal.fxml", "Arquivo Fiscal - XML"));
        this.mnXmlContabilidade.setOnAction(event -> {
            try {
                Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/fiscal/EnviaXmlContabilidade.fxml", "Enviar XML Contabilidade");
                form.showAndWait();
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo para enviar xml para contabilidade.");
            }
        });
        this.mnVendedorProdutoLancamento.setOnAction(event -> this.abreAba("tabVendedorProdutoLancamento", "/fxml/vendasExternas/vendedorProduto/VendedorProdutoLancamentos.fxml", "Lista de Lan\u00e7amentos de Produtos por Vendedor"));
        this.mnVendedorProduto.setOnAction(event -> this.abreAba("tabVendedorProduto", "/fxml/vendasExternas/vendedorProduto/VendedorProdutos.fxml", "Vendedor - Estoque de Produtos"));
        this.mnPedidoVendaExterna.setOnAction(event -> this.abreAba("tabPedidoVendaExterna", "/fxml/vendasExternas/pedido/PedidoVendaExterna.fxml", "Pedidos de Vendas Externas"));
        this.mnRelatorioCliente.setOnAction(event -> this.abreAba("tabRelatorioCliente", "/fxml/geral/cliente/relatorio/RelatorioCliente.fxml", "Relat\u00f3rio de Clientes"));
        this.mnRelatorioAniversariantes.setOnAction(event -> this.abreAba("tabRelatorioCliente", "/fxml/geral/cliente/relatorio/RelatorioAniversariante.fxml", "Relat\u00f3rio de Aniversariantes"));
        this.mnRelatorioInventario.setOnAction(event -> this.abreAba("tabRelatorioInventario", "/fxml/estoque/produto/relatorio/RelatorioInventario.fxml", "Relat\u00f3rio Invent\u00e1rio"));
        this.mnRelatorioProdutos.setOnAction(event -> this.abreAba("tabRelatorioProdutos", "/fxml/estoque/produto/relatorio/RelatorioProdutos.fxml", "Relat\u00f3rio Produtos"));
        this.mnRelatorioProdutosTabelaPreco.setOnAction(event -> this.abreAba("tabRelatorioProdutosTabelaPreco", "/fxml/estoque/produto/relatorio/RelatorioProdutosTabelaPreco.fxml", "Relat\u00f3rio Tabela de Pre\u00e7o"));
        this.mnRelatorioProdutosEstoqueBaixo.setOnAction(event -> this.abreAba("tabRelatorioProdutosEstoqueBaixo", "/fxml/estoque/produto/relatorio/RelatorioProdutosEstoqueBaixo.fxml", "Relat\u00f3rio Produtos Estoque Baixo"));
        this.mnRelatorioVenda.setOnAction(event -> this.abreAba("tabRelatorioVenda", "/fxml/estoque/vendaProduto/relatorio/RelatorioVenda.fxml", "Relat\u00f3rio Vendas"));
        this.mnRelatorioVendaPorDia.setOnAction(event -> this.abreAba("tabRelatorioVendaPorDia", "/fxml/estoque/vendaProduto/relatorio/RelatorioVendaPorDia.fxml", "Relat\u00f3rio Vendas Por Dia"));
        this.mnRelatorioCompra.setOnAction(event -> this.abreAba("tabRelatorioCompra", "/fxml/estoque/entradaProduto/relatorio/RelatorioCompra.fxml", "Relat\u00f3rio Compras"));
        this.mnRelatorioCompraProduto.setOnAction(event -> this.abreAba("tabRelatorioCompraProduto", "/fxml/estoque/entradaProduto/relatorio/RelatorioCompraProduto.fxml", "Relat\u00f3rio Entrada Produtos"));
        this.mnRelatorioCompraMateriaPrimaProduto.setOnAction(event -> this.abreAba("tabRelatorioCompraMateriaPrimaProduto", "/fxml/estoque/entradaMateriaPrima/relatorio/RelatorioCompraMateriaPrimaProduto.fxml", "Relat\u00f3rio Entrada Mat\u00e9ria Prima"));
        this.mnRelatorioVendaProduto.setOnAction(event -> this.abreAba("tabRelatorioVendaProduto", "/fxml/estoque/vendaProduto/relatorio/RelatorioVendaProduto.fxml", "Relat\u00f3rio Produtos Vendidos"));
        this.mnRelatorioVendaProdutoCategoria.setOnAction(event -> this.abreAba("tabRelatorioVendaProdutoCategoria", "/fxml/estoque/vendaProduto/relatorio/RelatorioVendaProdutoCategoria.fxml", "Relat\u00f3rio Produtos Vendidos Agrupados por Categoria"));
        this.mnRelatorioVendaProdutoCategoriaVendedor.setOnAction(event -> this.abreAba("tabRelatorioVendaProdutoCategoriaVendedor", "/fxml/estoque/vendaProduto/relatorio/RelatorioVendaProdutoCategoriaVendedor.fxml", "Relat\u00f3rio Produtos Vendidos por Vendedor"));
        this.mnRelatorioVendaProdutoCategoriaCliente.setOnAction(event -> this.abreAba("tabRelatorioVendaProdutoCategoriaCliente", "/fxml/estoque/vendaProduto/relatorio/RelatorioVendaProdutoCategoriaCliente.fxml", "Relat\u00f3rio Produtos Vendidos por Cliente"));
        this.mnRelatorioVendasCategorias.setOnAction(event -> this.abreAba("tabRelatorioVendasCategorias", "/fxml/estoque/vendaProduto/relatorio/RelatorioVendasCategorias.fxml", "Relat\u00f3rio Vendas Categorias"));
        this.mnGraficoVenda.setOnAction(event -> this.abreAba("tabGraficoVenda", "/fxml/estoque/vendaProduto/relatorio/GraficoVenda.fxml", "Gr\u00e1fico Vendas"));
        this.mnRelatorioContaReceber.setOnAction(event -> this.abreAba("tabRelatorioContaReceber", "/fxml/financeiro/contaReceber/relatorio/RelatorioContaReceber.fxml", "Relat\u00f3rio Conta Receber"));
        this.mnRelatorioRecebimento.setOnAction(event -> this.abreAba("tabRelatorioRecebimento", "/fxml/financeiro/movimentacaoEntrada/relatorio/RelatorioRecebimento.fxml", "Relat\u00f3rio Recebimentos"));
        this.mnRelatorioContaPagar.setOnAction(event -> this.abreAba("tabRelatorioContaPagar", "/fxml/financeiro/contaPagar/relatorio/RelatorioContaPagar.fxml", "Relat\u00f3rio Conta Pagar"));
        this.mnRelatorioPagamento.setOnAction(event -> this.abreAba("tabRelatorioPagamento", "/fxml/financeiro/movimentacaoSaida/relatorio/RelatorioPagamento.fxml", "Relat\u00f3rio Pagamentos"));
        this.mnRelatorioSangria.setOnAction(event -> this.abreAba("tabRelatorioSangria", "/fxml/financeiro/movimentoCaixa/relatorio/RelatorioSangria.fxml", "Relat\u00f3rio Sangria"));
        this.mnRelatorioEstoqueVendedor.setOnAction(event -> this.abreAba("tabRelatorioEstoqueVendedor", "/fxml/vendasExternas/relatorios/RelatorioEstoqueVendedor.fxml", "Relat\u00f3rio - Estoque Vendedor"));
        this.mnRelatorioVendasExternas.setOnAction(event -> this.abreAba("tabRelatorioVendasExternas", "/fxml/vendasExternas/relatorios/RelatorioVendasExternas.fxml", "Relat\u00f3rio de Vendas Externas"));
        this.mnRelatorioVendasExternasItens.setOnAction(event -> this.abreAba("tabRelatorioVendasExternasItens", "/fxml/vendasExternas/relatorios/RelatorioVendasExternasItens.fxml", "Relat\u00f3rio de Vendas Externas Produtos"));
        this.mnRelatorioNotaFiscal.setOnAction(event -> this.abreAba("tabRelatorioNotaFiscal", "/fxml/fiscal/relatorios/RelatorioNotaFiscal.fxml", "Relat\u00f3rio de Nota Fiscal (NFe)"));
        this.mnRelatorioNotaFiscalProdutos.setOnAction(event -> this.abreAba("tabRelatorioNotaFiscalProdutos", "/fxml/fiscal/relatorios/RelatorioNotaFiscalProdutos.fxml", "Relat\u00f3rio de Nota Fiscal - Produtos"));
        this.mnRelatorioSAT.setOnAction(event -> this.abreAba("tabRelatorioSAT", "/fxml/fiscal/relatorios/RelatorioSAT.fxml", "Relat\u00f3rio de Cupom SAT"));
        this.mnRelatorioFiscalProdutos.setOnAction(event -> this.abreAba("tabRelatorioFiscalProdutos", "/fxml/fiscal/relatorios/RelatorioFiscalProdutos.fxml", "Relat\u00f3rio Fiscal de Produtos"));
        this.mnRelatorioComandasCanceldas.setOnAction(event -> this.abreAba("tabRelatorioComandasCanceladas", "/fxml/food/relatorios/RelatorioComandasCanceladas.fxml", "Relat\u00f3rio Comandas Canceladas"));
        this.mnGarcons.setOnAction(event -> this.abreAba("tabGarcom", "/fxml/food/garcom/Garcom.fxml", "Lista de Gar\u00e7ons"));
        this.mnEntregadores.setOnAction(event -> this.abreAba("tabEntregadores", "/fxml/food/entregador/Entregadores.fxml", "Lista de Entregadores"));
    }

    private void abreAba(String tabId, String arquivoFxml, String titulo) {
        if (!this.existeTab(tabId)) {
            AnchorPane content;
            FXMLLoader loader = this.stageManager.loader(arquivoFxml);
            try {
                content = (AnchorPane)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foiposs\u00edvel abrir: " + titulo));
                return;
            }
            MaximaController controller = (MaximaController)loader.getController();
            controller.inicializa();
            Tab tab = new Tab(titulo);
            tab.setId(tabId);
            tab.setContent((Node)content);
            tab.setOnClosed(evt -> this.carregaPaginaInicial());
            this.tabPane.getTabs().add((Object)tab);
        }
        this.carregaPaginaInicial();
        this.setFocusTab(tabId);
    }

    private void setFocusTab(String tabId) {
        for (Tab tab : this.tabPane.getTabs()) {
            if (!tab.getId().equals(tabId)) continue;
            SingleSelectionModel selectionModel = this.tabPane.getSelectionModel();
            selectionModel.select((Object)tab);
            break;
        }
    }

    public void fechaTab(String tabId) {
        Tab tab;
        int index = 0;
        Iterator iterator = this.tabPane.getTabs().iterator();
        while (iterator.hasNext() && !(tab = (Tab)iterator.next()).getId().equalsIgnoreCase(tabId)) {
            ++index;
        }
        if (index >= 0) {
            this.tabPane.getTabs().remove(index);
        }
    }

    private boolean existeTab(String tabId) {
        boolean existe = false;
        for (Tab tab : this.tabPane.getTabs()) {
            if (!tab.getId().equals(tabId)) continue;
            existe = true;
            break;
        }
        return existe;
    }

    private void carregaIcones() {
        Image imageClientes = new Image(this.getClass().getResourceAsStream("/icones/cliente.png"));
        Image imageProdutos = new Image(this.getClass().getResourceAsStream("/icones/produtos.png"));
        Image imageVendas = new Image(this.getClass().getResourceAsStream("/icones/vendas.png"));
        Image imageContaReceber = new Image(this.getClass().getResourceAsStream("/icones/recebimentos.png"));
        Image imageNfe = new Image(this.getClass().getResourceAsStream("/icones/icone_nfe.png"));
        this.btnClientes.setGraphic((Node)new ImageView(imageClientes));
        this.btnClientes.setTooltip(new Tooltip("Clientes"));
        this.btnProdutos.setGraphic((Node)new ImageView(imageProdutos));
        this.btnProdutos.setTooltip(new Tooltip("Produtos"));
        this.btnVendas.setGraphic((Node)new ImageView(imageVendas));
        this.btnVendas.setTooltip(new Tooltip("Vendas"));
        this.btnRecebimentos.setGraphic((Node)new ImageView(imageContaReceber));
        this.btnRecebimentos.setTooltip(new Tooltip("Contas a Receber"));
        this.btnNotaFiscal.setGraphic((Node)new ImageView(imageNfe));
        this.btnNotaFiscal.setTooltip(new Tooltip("Nota Fiscal Eletr\u00f4nica"));
        Image logo = new Image(this.getClass().getResourceAsStream("/img/maxima_sistemas.png"));
        this.vBox.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(logo, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, BackgroundSize.DEFAULT)}));
        this.carregaPaginaInicial();
    }

    private void carregaPaginaInicial() {
        if (this.tabPane.getTabs().isEmpty()) {
            System.out.println("=== tab vazia");
            this.tabPane.setVisible(false);
            this.tabPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        } else {
            this.tabPane.setVisible(true);
            this.tabPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        }
    }

    private void desabilitaTudo() {
        this.btnClientes.setDisable(true);
        this.btnProdutos.setDisable(true);
        this.btnVendas.setDisable(true);
        this.btnRecebimentos.setDisable(true);
        this.btnNotaFiscal.setDisable(true);
        this.mnUsuario.setDisable(true);
        this.mnUsuarioPerfil.setDisable(true);
        this.mnEmpresa.setDisable(true);
        this.mnConfiguracao.setDisable(true);
        this.mnEstado.setDisable(true);
        this.mnMunicipio.setDisable(true);
        this.mnCategoriaCliente.setDisable(true);
        this.mnCliente.setDisable(true);
        this.mnFornecedor.setDisable(true);
        this.mnVendedor.setDisable(true);
        this.mnTransportadora.setDisable(true);
        this.mnVeiculo.setDisable(true);
        this.mnUnidade.setDisable(true);
        this.mnBaixaProdutoMotivo.setDisable(true);
        this.mnMateriaPrima.setDisable(true);
        this.mnEntradaMateriaPrima.setDisable(true);
        this.mnCategoriaProduto.setDisable(true);
        this.mnProduto.setDisable(true);
        this.mnEntradaProduto.setDisable(true);
        this.mnVendaProduto.setDisable(true);
        this.mnEstoqueBalanco.setDisable(true);
        this.mnOrcamento.setDisable(true);
        this.mnDevolucao.setDisable(true);
        this.mnBaixaProduto.setDisable(true);
        this.mnBancoBoleto.setDisable(true);
        this.mnCondicaoRecebimento.setDisable(true);
        this.mnCentroCusto.setDisable(true);
        this.mnMensalidade.setDisable(true);
        this.mnMovimentoCaixa.setDisable(true);
        this.mnContaReceber.setDisable(true);
        this.mnRecebimentos.setDisable(true);
        this.mnBoletoEmitido.setDisable(true);
        this.mnBoletoBaixa.setDisable(true);
        this.mnExtratoCliente.setDisable(true);
        this.mnContaPagar.setDisable(true);
        this.mnPagamentos.setDisable(true);
        this.mnConfiguracaoFiscalEntradaSaida.setDisable(true);
        this.mnContador.setDisable(true);
        this.mnCertificadoDigital.setDisable(true);
        this.mnSatCFe.setDisable(true);
        this.mnNotaFiscal.setDisable(true);
        this.mnVendedorProduto.setDisable(true);
        this.mnVendedorProdutoLancamento.setDisable(true);
        this.mnPedidoVendaExterna.setDisable(true);
        this.mnRelatorioCliente.setDisable(true);
        this.mnRelatorioInventario.setDisable(true);
        this.mnRelatorioProdutos.setDisable(true);
        this.mnRelatorioProdutosTabelaPreco.setDisable(true);
        this.mnRelatorioCompra.setDisable(true);
        this.mnRelatorioCompraProduto.setDisable(true);
        this.mnRelatorioVenda.setDisable(true);
        this.mnRelatorioVendasCategorias.setDisable(true);
        this.mnRelatorioVendaProduto.setDisable(true);
        this.mnRelatorioContaReceber.setDisable(true);
        this.mnRelatorioRecebimento.setDisable(true);
        this.mnRelatorioContaPagar.setDisable(true);
        this.mnRelatorioPagamento.setDisable(true);
        this.mnRelatorioVendasExternas.setDisable(true);
        this.mnRelatorioVendasExternasItens.setDisable(true);
        this.mnRelatorioEstoqueVendedor.setDisable(true);
        this.mnRelatorioNotaFiscal.setDisable(true);
        this.mnRelatorioNotaFiscalProdutos.setDisable(true);
        this.mnRelatorioFiscalProdutos.setDisable(false);
    }

    public void importaClientes() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("C:/Maxima/lider/clientes.txt"), "UTF-8"));
            String linha = "";
            int erros = 0;
            int count = 0;
            while ((linha = br.readLine()) != null) {
                ClienteImportaDto dto = this.getObjetoCliente(linha);
                if (dto == null || dto.getCodigoIbge() == null || dto.getCodigoIbge().isEmpty()) continue;
                System.out.println(count + "  " + this.clienteService.importa(dto));
                ++count;
            }
            System.out.println("== Erros: " + erros);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private ClienteImportaDto getObjetoCliente(String linha) {
        String cpf;
        String telefone;
        String cep;
        String bairro;
        String complemento;
        String numero;
        String endereco;
        String[] registro = linha.split(";");
        String nome = registro[1].replace("\"", "");
        if (nome == null || nome.isEmpty()) {
            nome = "NAO INFORMADO";
        }
        if ((endereco = registro[2].replace("\"", "")) == null) {
            endereco = "";
        }
        if ((numero = registro[3].replace("\"", "")) == null) {
            numero = "";
        }
        if ((complemento = registro[4].replace("\"", "")) == null) {
            complemento = "";
        }
        if ((bairro = registro[5].replace("\"", "")) == null) {
            bairro = "";
        }
        if ((cep = registro[6].replace("\"", "")) == null) {
            cep = "";
        }
        if ((telefone = registro[8].replace("\"", "")) == null || telefone.isEmpty()) {
            telefone = "00000000";
        } else if ((telefone = MaximaUtils.removeCaracteres((String)telefone)).isEmpty()) {
            telefone = "00000000";
        }
        String rg = "";
        if (registro.length >= 10 && (rg = registro[10].replace("\"", "")) == null) {
            rg = "";
        }
        if ((cpf = registro[9].replace("\"", "")) == null || cpf.isEmpty()) {
            cpf = "";
        }
        String observacao = "";
        String email = "";
        String cidade = registro[3].replace("\"", "");
        String uf = registro[4].replace("\"", "");
        ClienteImportaDto clienteDto = new ClienteImportaDto();
        clienteDto.setNome(MaximaUtils.getText((String)nome));
        clienteDto.setFantasia(MaximaUtils.getText((String)""));
        clienteDto.setEndereco(MaximaUtils.getText((String)endereco));
        clienteDto.setNumero(MaximaUtils.getText((String)numero));
        clienteDto.setComplemento(MaximaUtils.getText((String)complemento));
        clienteDto.setBairro(MaximaUtils.getText((String)bairro));
        clienteDto.setCep(MaximaUtils.removeCaracteres((String)cep));
        clienteDto.setTelefone(telefone);
        clienteDto.setCelular("");
        clienteDto.setDataNascimento(null);
        clienteDto.setRg(MaximaUtils.removeCaracteres((String)rg));
        clienteDto.setCpf(MaximaUtils.removeCaracteres((String)cpf));
        clienteDto.setObs(observacao);
        clienteDto.setEmail(email);
        clienteDto.setMunicipio(cidade);
        clienteDto.setCodigoIbge(registro[7]);
        clienteDto.setUf(uf);
        return clienteDto;
    }

    private NFeCabecalho getNFe(NFNota nota, String protocolo) {
        try {
            NFeCabecalho nfe = new NFeCabecalho();
            nfe.setImportada(Boolean.valueOf(true));
            nfe.setNumero(nota.getInfo().getIdentificacao().getNumeroNota());
            String chaveAcesso = nota.getInfo().getChaveAcesso();
            nfe.setChaveAcesso(chaveAcesso.substring(0, 43));
            nfe.setDigitoChaveAcesso(chaveAcesso.substring(43, 44));
            nfe.setDataEmissao(nota.getInfo().getIdentificacao().getDataHoraEmissao().toLocalDate());
            nfe.setValorTotal(new BigDecimal(nota.getInfo().getTotal().getIcmsTotal().getValorTotalNFe()));
            nfe.setXmlFile("C:/Maxima/Nota Fiscal/Importadas/" + chaveAcesso + "-NFe.xml");
            nfe.setStatusNota(NFeStatus.AUTORIZADA);
            nfe.setSerie(nota.getInfo().getIdentificacao().getSerie());
            NFTipo tipo = nota.getInfo().getIdentificacao().getTipo().equals((Object)NFTipo.ENTRADA) ? NFTipo.ENTRADA : NFTipo.SAIDA;
            nfe.setTipoOperacao(tipo);
            nfe.setTipoEmissao(NFTipoEmissao.EMISSAO_NORMAL);
            nfe.setFinalidadeEmissao(NFFinalidade.NORMAL);
            nfe.setNaturezaOperacao(nota.getInfo().getIdentificacao().getNaturezaOperacao().toUpperCase());
            NFNotaProcessada notaProcessada = new NFNotaProcessada();
            notaProcessada.setVersao(new BigDecimal(NFeConfigMaxima.VERSAO_NFE));
            NFProtocolo nFProtocolo = new NFProtocolo();
            NFProtocoloInfo protInfo = new NFProtocoloInfo();
            protInfo.setAmbiente(DFAmbiente.PRODUCAO);
            protInfo.setChave(nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso());
            protInfo.setVersaoAplicacao("PR-v3_8_5");
            protInfo.setDataRecebimento("2023-08-23T14:11:08-02:00");
            protInfo.setNumeroProtocolo(protocolo);
            protInfo.setStatus("103");
            nFProtocolo.setProtocoloInfo(protInfo);
            notaProcessada.setProtocolo(nFProtocolo);
            notaProcessada.setNota(nota);
            nfe.setXmlTxt(notaProcessada.toString());
            NFeDestinatario dest = new NFeDestinatario();
            String cpfCnpj = nota.getInfo().getDestinatario().getCnpj() != null && !nota.getInfo().getDestinatario().getCnpj().isEmpty() ? nota.getInfo().getDestinatario().getCnpj() : nota.getInfo().getDestinatario().getCpf();
            Cliente cliente = this.clienteService.getByCpf(cpfCnpj);
            NFNotaInfoDestinatario destinatario = nota.getInfo().getDestinatario();
            if (cliente == null) {
                cliente = new Cliente();
                cliente.setAtivo(Boolean.TRUE);
                cliente.setBairro(destinatario.getEndereco().getBairro());
                cliente.setCep(destinatario.getEndereco().getCep());
                cliente.setComplemento(destinatario.getEndereco().getComplemento());
                cliente.setCpf(cpfCnpj);
                cliente.setDataCadastro(LocalDate.now());
                cliente.setEndereco(destinatario.getEndereco().getLogradouro());
                cliente.setFantasia("");
                cliente.setLimite(BigDecimal.ZERO);
                cliente.setMunicipio(this.municipioService.getByIbge(destinatario.getEndereco().getCodigoMunicipio()));
                cliente.setNegativado(Boolean.FALSE);
                cliente.setNome(destinatario.getRazaoSocial().toUpperCase());
                cliente.setNumero(destinatario.getEndereco().getNumero());
                cliente.setRg(destinatario.getInscricaoEstadual());
                String telefone = destinatario.getEndereco().getTelefone();
                if (telefone == null || telefone.isEmpty()) {
                    telefone = "00000000";
                }
                cliente.setTelefone(telefone);
                try {
                    cliente = this.clienteService.save(cliente);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            nfe.setCliente(cliente);
            dest.setBairro(destinatario.getEndereco().getBairro());
            dest.setCep(destinatario.getEndereco().getCep());
            dest.setCodigoMunicipio(Integer.valueOf(Integer.parseInt(destinatario.getEndereco().getCodigoMunicipio())));
            dest.setCodigoPais(destinatario.getEndereco().getCodigoPais().getCodigo());
            dest.setComplemento(destinatario.getEndereco().getComplemento());
            dest.setCpfCnpj(cpfCnpj);
            dest.setIe(destinatario.getInscricaoEstadual());
            dest.setLogradouro(destinatario.getEndereco().getLogradouro());
            dest.setMunicipio(this.municipioService.getByIbge(destinatario.getEndereco().getCodigoMunicipio()));
            dest.setNfeCabecalho(nfe);
            dest.setNomeMunicipio("");
            dest.setNumero(destinatario.getEndereco().getNumero());
            dest.setRazaoSocial(destinatario.getRazaoSocial());
            Municipio municipio = this.municipioService.load(this.conf.getEmpresaNFe().getMunicipio().getId().longValue());
            nfe = this.notaFiscalService.salva(nfe, this.getEmitente(nota, municipio, nfe), dest, new ArrayList(), new ArrayList(), new ArrayList(), null, null);
            return nfe;
        }
        catch (Exception e) {
            Logger.getLogger(PrincipalController.class.getSimpleName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    private NFeEmitente getEmitente(NFNota nota, Municipio municipio, NFeCabecalho nfe) {
        NFNotaInfoEmitente emitente = nota.getInfo().getEmitente();
        NFeEmitente em = new NFeEmitente();
        em.setBairro(emitente.getEndereco().getBairro());
        em.setCep(emitente.getEndereco().getCep());
        em.setCodigoMunicipio(Integer.valueOf(Integer.parseInt(emitente.getEndereco().getCodigoMunicipio())));
        em.setCodigoPais(emitente.getEndereco().getCodigoPais().getCodigo());
        em.setComplemento(emitente.getEndereco().getComplemento());
        em.setCpfCnpj(emitente.getCnpj());
        em.setCrt(Integer.valueOf(Integer.parseInt(emitente.getRegimeTributario().getCodigo())));
        em.setFantasia(emitente.getNomeFantasia());
        em.setIe(emitente.getInscricaoEstadual());
        em.setLogradouro(emitente.getEndereco().getLogradouro());
        em.setMunicipio(municipio);
        em.setNfeCabecalho(nfe);
        em.setNomeMunicipio(municipio.getNome());
        em.setNomePais("BRASIL");
        em.setNumero(emitente.getEndereco().getNumero());
        em.setRazaoSocial(emitente.getRazaoSocial());
        em.setTelefone(emitente.getEndereco().getTelefone());
        em.setUf("SP");
        return em;
    }

    public void importaNFe() {
        File folder = new File("C:/Maxima/Json/xml/");
        boolean count = false;
        for (File file : folder.listFiles()) {
            JSONParser parser = new JSONParser();
            try {
                JSONObject jsonObject = (JSONObject)parser.parse((Reader)new FileReader(file));
                if (jsonObject.get((Object)"xml") == null) continue;
                String protocolo = (String)jsonObject.get((Object)"protocolo");
                String xml = (String)jsonObject.get((Object)"xml");
                xml = new String(xml.getBytes(), StandardCharsets.UTF_8);
                NFNota notaFiscal = (NFNota)new DFPersister().read(NFNota.class, xml);
                this.getNFe(notaFiscal, protocolo);
            }
            catch (FileNotFoundException protocolo) {
            }
            catch (IOException protocolo) {
            }
            catch (ParseException ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void importaProdutosBrutus() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("C:/Maxima/lider/produtos.txt"), "UTF-8"));
            String linha = "";
            int erros = 0;
            int count = 0;
            while ((linha = br.readLine()) != null) {
                ImportacaoProdutoDto dto = this.getObjetoProduto(linha);
                if (dto == null) continue;
                Produto produto = this.produtoService.importa(dto);
                System.out.println(count + " - " + produto.getNome());
                ++count;
            }
            System.out.println("== Erros: " + erros);
        }
        catch (MaximaException | FileNotFoundException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void importaProdutosJson() {
        try {
            BufferedReader br = new BufferedReader(new FileReader("C:/Maxima/produtos.txt"));
            String linha = "";
            int erros = 0;
            int count = 0;
            while ((linha = br.readLine()) != null) {
                ImportacaoProdutoDto dto = this.getObjetoProduto(linha);
                System.out.println(count + "  " + dto.getNome());
                try {
                    Produto produto = this.produtoService.importa(dto);
                    System.out.println(count + "  Produto: " + produto.getNome());
                    ++count;
                }
                catch (MaximaException maximaException) {}
            }
            System.out.println("== Erros: " + erros);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private ImportacaoProdutoDto getObjetoProduto(String linha) {
        String codigo;
        String[] registro = linha.split(";");
        String nome = registro[1].replace("\"", "");
        if (nome == null || nome.isEmpty()) {
            nome = "NAO INFORMADO";
        }
        if ((codigo = registro[0].trim().replace("\"", "")).isEmpty() || codigo.equals("00000")) {
            codigo = this.produtoService.geraCodigo();
        }
        BigDecimal estoqueAtual = new BigDecimal(registro[4]);
        BigDecimal ultimoCusto = new BigDecimal(registro[5]);
        BigDecimal precoVenda = new BigDecimal(registro[6]);
        String ncm = registro[2];
        String csosn = registro[3];
        ncm = ncm == null || ncm.isEmpty() || ncm.length() < 8 ? "00000000" : ncm.substring(0, 8);
        String cfop = "5102";
        if (csosn != null) {
            cfop = "500".equals(csosn) ? "5405" : "5102";
        }
        ImportacaoProdutoDto dto = new ImportacaoProdutoDto();
        dto.setCategoriaId(Long.valueOf(1L));
        dto.setNome(nome);
        dto.setEstoqueAtual(estoqueAtual);
        dto.setUltimoCusto(ultimoCusto);
        dto.setPrecoVenda(precoVenda);
        dto.setCodigo(codigo);
        dto.setUnidadeId(Long.valueOf(1L));
        dto.setCfop(cfop);
        dto.setCstEntrada("");
        dto.setNcm(ncm);
        return dto;
    }
}

