/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.api.bean.ClienteStatusJson;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.AES;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;

@Component
public class ValidacaoController {
    public void validaAtivacao(StageManager stageManager, ConfiguracaoService configuracaoService, ValidacaoService validacaoService) {
        Configuracao conf = configuracaoService.load();
        String chave = MaximaConfig.getInstance().getProperty("chave");
        if (chave == null || chave.isEmpty()) {
            MaximaAlert.alerta((String)"Erro: Propriente chave n\u00e3o informada no arquivo properties.");
            System.exit(0);
        }
        if (chave.equalsIgnoreCase("12165451220323")) {
            return;
        }
        try {
            ClienteStatusJson json = validacaoService.valida(chave);
            if (json == null) {
                MaximaAlert.aviso((StageManager)stageManager, (String)"AVISO: Falha na comunica\u00e7\u00e3o com o servidor.\nVerifique a conex\u00e3o com a internet.");
                System.exit(0);
            }
            System.out.println("============ JSON: " + json.getStatus());
            if (conf == null) {
                MaximaAlert.aviso((StageManager)stageManager, (String)"AVISO: Configura\u00e7\u00e3o do sistema n\u00e3o efetuada.");
                System.exit(0);
            }
            if (json.getStatus().equalsIgnoreCase("500")) {
                System.out.println("=== FALHA COMUNICA\u00c7\u00c3O COM O SERVIDOR ( FALHA NO SERVIDOR OU NA INTERNET ) ===");
                if (!this.validaArquivoEmdia()) {
                    MaximaAlert.aviso((StageManager)stageManager, (String)"Ops. Falha na valida\u00e7\u00e3o da licen\u00e7a do software.\nVerifique a conex\u00e3o com a internet.\nPossibilidade de mensalidade em atraso.");
                    System.exit(0);
                }
            } else {
                if (json.getCnpj() == null || json.getCnpj().isEmpty() || !MaximaUtils.removeCaracteres((String)json.getCnpj()).equals(MaximaUtils.removeCaracteres((String)conf.getEmpresaNFe().getCpf()))) {
                    MaximaAlert.aviso((StageManager)stageManager, (String)"AVISO: CNPJ n\u00e3o confere com a chave informada.");
                    System.exit(0);
                }
                if (json.getStatus().equalsIgnoreCase("100")) {
                    this.escreveArquivoEmdia();
                } else if (json.getStatus().equalsIgnoreCase("200")) {
                    this.escreveArquivoEmdia();
                    MaximaAlert.aviso((StageManager)stageManager, (String)json.getMotivo());
                } else if (json.getStatus().equalsIgnoreCase("400")) {
                    MaximaAlert.aviso((StageManager)stageManager, (String)json.getMotivo());
                    System.exit(0);
                } else if (json.getStatus().equalsIgnoreCase("999")) {
                    this.deleteArquivoEmDia();
                    MaximaAlert.aviso((StageManager)stageManager, (String)json.getMotivo());
                    System.exit(0);
                } else {
                    System.exit(0);
                }
            }
        }
        catch (MaximaValidacaoException ex) {
            MaximaAlert.aviso((StageManager)stageManager, (String)ex.getMessage());
            System.exit(0);
        }
    }

    private boolean validaArquivoEmdia() {
        File arquivo = new File("C:/Maxima/maxima.txt");
        if (!arquivo.exists()) {
            return false;
        }
        try {
            Scanner obj = new Scanner(arquivo);
            if (!obj.hasNext()) {
                return false;
            }
            String dataLimiteStr = obj.nextLine();
            LocalDate dataLImite = LocalDate.parse(AES.decrypt((String)dataLimiteStr, (String)"maxima6459"), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            if (dataLImite == null || LocalDate.now().isAfter(dataLImite)) {
                System.out.println("=== depois da data limite ===");
                return false;
            }
            obj.close();
        }
        catch (FileNotFoundException | DateTimeParseException ex) {
            Logger.getLogger(ValidacaoController.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    private void escreveArquivoEmdia() {
        File arquivo = new File("C:/Maxima/maxima.txt");
        try {
            arquivo.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileWriter fw = new FileWriter(arquivo.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            LocalDate dataLimite = LocalDate.now().plusDays(3L);
            bw.write(AES.encrypt((String)dataLimite.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), (String)"maxima6459"));
            bw.close();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ValidacaoController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void deleteArquivoEmDia() {
        File arquivo = new File("C:/Maxima/maxima.txt");
        if (arquivo.exists()) {
            arquivo.delete();
        }
    }
}

