/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compactador {
    public boolean zipar(String endEntrada, String endSaida) {
        String dirInterno = "";
        boolean retorno = true;
        try {
            File file = new File(endEntrada);
            ZipOutputStream zipDestino = new ZipOutputStream(new FileOutputStream(endSaida));
            if (file.isFile()) {
                this.ziparFile(file, dirInterno, zipDestino);
            } else {
                dirInterno = file.getName();
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.ziparFile(files[i], dirInterno, zipDestino);
                }
            }
            zipDestino.close();
        }
        catch (IOException ex) {
            retorno = false;
        }
        return retorno;
    }

    private void ziparFile(File file, String dirInterno, ZipOutputStream zipDestino) throws IOException {
        int count;
        byte[] data = new byte[4096];
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].getName().contains("ib_logfile")) continue;
                this.ziparFile(files[i], dirInterno + File.separator + file.getName(), zipDestino);
            }
            return;
        }
        FileInputStream fi = new FileInputStream(file.getAbsolutePath());
        ZipEntry entry = new ZipEntry(dirInterno + File.separator + file.getName());
        zipDestino.putNextEntry(entry);
        while ((count = fi.read(data)) > 0) {
            zipDestino.write(data, 0, count);
        }
        zipDestino.closeEntry();
        fi.close();
    }
}

