/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.core;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.serializer.LocalDateDeserializer;
import br.com.maximasolutions.serializer.LocalDateTimeDeserializer;
import br.com.maximasolutions.vendasexternas.service.SincronizacaoServiceImpl;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MaximaWebAPI {
    private final String BASE_URI;

    public MaximaWebAPI(String baseUri) {
        this.BASE_URI = baseUri;
    }

    public Object enviaSincronizacaoApi(Object objetoJson, String url, Class classeRetorno) throws MaximaException {
        String jsonRetorno;
        Response response;
        try {
            response = this.enviaSolicitacaoPost(objetoJson, url);
        }
        catch (IOException ex) {
            Logger.getLogger(SincronizacaoServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Falha na comunica\u00e7\u00e3o com o servidor do aplicativo.");
        }
        if (response.code() != 200 || !response.isSuccessful()) {
            throw new MaximaException("Falha na sincroniza\u00e7\u00e3o dos dados do estado com o servidor do aplicativo.");
        }
        try {
            jsonRetorno = response.body().string();
        }
        catch (IOException ex) {
            Logger.getLogger(SincronizacaoServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Falha ao ler dados de retorno.");
        }
        response.body().close();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer());
        gsonBuilder.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeDeserializer());
        Gson gson = gsonBuilder.setPrettyPrinting().create();
        try {
            return gson.fromJson(jsonRetorno, classeRetorno);
        }
        catch (Exception ex) {
            Logger.getLogger(SincronizacaoServiceImpl.class.getSimpleName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Falha ao ler dados de retorno.");
        }
    }

    private Response enviaSolicitacaoPost(Object objetoJson, String url) throws IOException {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new Gson().toJson(objetoJson));
        int maxConnections = 5;
        int keepAliveDuration = 5000;
        ConnectionPool cp = new ConnectionPool(maxConnections, (long)keepAliveDuration, TimeUnit.MILLISECONDS);
        Request request = new Request.Builder().url(this.BASE_URI + url).post(body).build();
        OkHttpClient client = new OkHttpClient.Builder().connectionPool(cp).build();
        Call call = client.newCall(request);
        Response response = call.execute();
        client.connectionPool().evictAll();
        return response;
    }

    public Response enviaSolicitacaoGet(String url) throws IOException {
        int maxConnections = 5;
        int keepAliveDuration = 5000;
        ConnectionPool cp = new ConnectionPool(maxConnections, (long)keepAliveDuration, TimeUnit.MILLISECONDS);
        Request request = new Request.Builder().url(this.BASE_URI + url).get().build();
        OkHttpClient client = new OkHttpClient.Builder().connectionPool(cp).build();
        Call call = client.newCall(request);
        Response response = call.execute();
        client.connectionPool().evictAll();
        return response;
    }
}

