/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.core.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ConfirmaSimNaoCancelaWindowController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Label lblPergunta;
    @FXML
    private Button btnSim;
    @FXML
    private Button btnNao;
    @FXML
    private Button btnCancela;
    @FXML
    private ImageView img;
    private Boolean confirma;
    private Boolean finalizado;

    public void initialize(URL location, ResourceBundle resources) {
        Image image = new Image(this.getClass().getResourceAsStream("/images/question_64.png"));
        this.img.setImage(image);
    }

    public void inicializa(String pergunta) {
        this.registraAcoes();
        this.carregaIcones();
        this.confirma = false;
        this.finalizado = false;
        this.lblPergunta.setText(pergunta);
        this.btnSim.requestFocus();
    }

    private void sim() {
        this.confirma = true;
        this.finalizado = true;
        this.close();
    }

    private void nao() {
        this.confirma = false;
        this.finalizado = true;
        this.close();
    }

    private void registraAcoes() {
        this.btnSim.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.sim();
            }
        });
        this.btnSim.setOnAction(event -> this.sim());
        this.btnNao.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.nao();
            }
        });
        this.btnNao.setOnAction(event -> this.nao());
        this.btnCancela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.close();
            }
        });
        this.btnCancela.setOnAction(event -> this.close());
        Stage form = (Stage)this.lblPergunta.getScene().getWindow();
        form.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (KeyCode.ESCAPE == event.getCode()) {
                this.close();
            }
        });
    }

    private void carregaIcones() {
        this.btnSim.setGraphic((Node)new MaximaIcone().ok_24());
        this.btnNao.setGraphic((Node)new MaximaIcone().not_ok_24());
        this.btnCancela.setGraphic((Node)new MaximaIcone().cancel_24());
    }

    private void close() {
        Stage form = (Stage)this.lblPergunta.getScene().getWindow();
        form.close();
    }

    public Boolean getFinalizado() {
        return this.finalizado;
    }

    public Boolean getConfirma() {
        return this.confirma;
    }
}

