/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.BaixaProduto;
import br.com.maximasolutions.estoque.modelo.BaixaProdutoItem;
import br.com.maximasolutions.estoque.modelo.BaixaProdutoMotivo;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.BaixaProdutoMotivoService;
import br.com.maximasolutions.estoque.service.BaixaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class BaixaProdutoFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private BaixaProdutoMotivoService baixaProdutoMotivoService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private BaixaProdutoService baixaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private Configuracao conf;
    private Produto produto;
    private ObservableList<BaixaProdutoItem> baixaProdutoItemList;
    private BaixaProduto baixaProduto;
    private List<BaixaProdutoItem> itens;
    @FXML
    private VBox vBox;
    @FXML
    private Pane painelTotal;
    @FXML
    private DatePicker tfDataEmissao;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoNome;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfPrecoCusto;
    @FXML
    private TextField tfTotalCusto;
    @FXML
    private TextField tfPrecoVenda;
    @FXML
    private TextField tfTotalVenda;
    @FXML
    private TextField tfBaixaTotalCusto;
    @FXML
    private TextField tfBaixaTotalVenda;
    @FXML
    private ComboBox<BaixaProdutoMotivo> cbbMotivo;
    @FXML
    private TableView<BaixaProdutoItem> tabela;
    @FXML
    private TableColumn<BaixaProdutoItem, String> colProduto;
    @FXML
    private TableColumn<BaixaProdutoItem, String> colCodigo;
    @FXML
    private TableColumn<BaixaProdutoItem, String> colItem;
    @FXML
    private TableColumn<BaixaProdutoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<BaixaProdutoItem, BigDecimal> colCusto;
    @FXML
    private TableColumn<BaixaProdutoItem, BigDecimal> colCustoTotal;
    @FXML
    private TableColumn<BaixaProdutoItem, BigDecimal> colVenda;
    @FXML
    private TableColumn<BaixaProdutoItem, BigDecimal> colVendaTotal;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private Button btnProdutoAdd;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnFinaliza;

    public void initialize(URL location, ResourceBundle resources) {
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
    }

    public void inicializa() {
        this.conf = this.configuracaoService.load();
    }

    public void inicializaBaixa(BaixaProduto baixaProduto1) {
        if (baixaProduto1 == null) {
            this.baixaProduto = null;
            this.itens = new ArrayList();
        } else {
            this.baixaProduto = baixaProduto1;
            this.itens = this.baixaProdutoService.listItens(this.baixaProduto);
            this.tfDataEmissao.setValue((Object)this.baixaProduto.getDataEmissao());
            this.tfObservacao.setText(this.baixaProduto.getObservacao());
        }
        this.inicializaItem();
        Stage stage = (Stage)this.vBox.getScene().getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        this.tfDataEmissao.requestFocus();
    }

    private void inicializaItem() {
        this.produto = null;
        this.loadDadosProduto();
        this.loadValoresTotais();
        this.loadItens();
    }

    private void loadItens() {
        this.baixaProdutoItemList = FXCollections.observableArrayList();
        this.baixaProdutoItemList.clear();
        BigDecimal totalCusto = BigDecimal.ZERO;
        BigDecimal totalVenda = BigDecimal.ZERO;
        for (BaixaProdutoItem item : this.itens) {
            if (item.getExcluido().booleanValue()) continue;
            totalCusto = totalCusto.add(item.getTotalCusto());
            totalVenda = totalVenda.add(item.getTotalVenda());
            this.baixaProdutoItemList.add((Object)item);
        }
        this.tabela.setItems(this.baixaProdutoItemList);
        this.tfBaixaTotalCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalCusto, (int)2));
        this.tfBaixaTotalVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalVenda, (int)2));
    }

    private void addItem() {
        if (!this.validaItemForm()) {
            return;
        }
        this.itens.add(this.createBaixaProdutoItem(this.produto, MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText())));
        this.inicializaItem();
    }

    private void editaItem() {
    }

    private void deleteItem() {
        BaixaProdutoItem item = (BaixaProdutoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum produto selecionado.");
            return;
        }
        int cont = 0;
        for (BaixaProdutoItem i : this.itens) {
            if (i.getNumItem().equals(item.getNumItem())) {
                i.setExcluido(Boolean.TRUE);
                break;
            }
            ++cont;
        }
        cont = 0;
        for (BaixaProdutoItem i : this.itens) {
            ++cont;
            if (i.getExcluido().booleanValue()) continue;
            i.setNumItem(Integer.valueOf(cont));
        }
        this.inicializaItem();
    }

    private void finalizaBaixa() {
        if (!this.validaPedidoForm()) {
            return;
        }
        try {
            this.baixaProdutoService.salva(this.createBaixaProduto(), this.itens);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Baixa de produto cadastrada com sucesso.");
            Stage form = (Stage)this.btnFinaliza.getScene().getWindow();
            form.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(BaixaProdutoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel salvar a baixa de produtos.\nCausa: " + ex.getMessage()));
        }
    }

    private void cancelaBaixa() {
        this.inicializaBaixa(null);
    }

    private void loadValoresTotais() {
        if (this.baixaProduto == null) {
            this.tfBaixaTotalCusto.setText("");
            this.tfBaixaTotalVenda.setText("");
        } else {
            this.tfBaixaTotalCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.baixaProduto.getTotalCusto(), (int)2));
            this.tfBaixaTotalVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.baixaProduto.getTotalVenda(), (int)2));
        }
    }

    private boolean validaItemForm() {
        boolean valido = true;
        if (this.produto == null) {
            this.tfProdutoPesquisa.getStyleClass().add((Object)"error");
            this.tfProdutoNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoPesquisa.getStyleClass().remove((Object)"error");
            this.tfProdutoNome.getStyleClass().remove((Object)"error");
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfQuantidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfQuantidade.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaPedidoForm() {
        boolean valido = true;
        if (this.tfDataEmissao.getValue() == null) {
            this.tfDataEmissao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataEmissao.getStyleClass().remove((Object)"error");
        }
        if (this.cbbMotivo.getSelectionModel().getSelectedItem() == null) {
            this.cbbMotivo.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbMotivo.getStyleClass().remove((Object)"error");
        }
        if (this.baixaProdutoItemList == null || this.baixaProdutoItemList.isEmpty()) {
            this.tabela.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tabela.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void calculaTotalCusto() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (this.produto == null || quantidade == null) {
            this.tfTotalCusto.setText(null);
            return;
        }
        BigDecimal custoUnitario = this.produto.getUltimoCusto();
        BigDecimal totalCusto = custoUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalCusto, (int)2));
    }

    private void calculaTotalVenda() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (this.produto == null || quantidade == null) {
            this.tfTotalCusto.setText(null);
            return;
        }
        BigDecimal vendaUnitario = this.produto.getPrecoVenda();
        BigDecimal totalVenda = vendaUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalVenda, (int)2));
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colCusto.setCellValueFactory((Callback)new PropertyValueFactory("precoCusto"));
        this.colCustoTotal.setCellValueFactory((Callback)new PropertyValueFactory("totalCusto"));
        this.colVenda.setCellValueFactory((Callback)new PropertyValueFactory("precoVenda"));
        this.colVendaTotal.setCellValueFactory((Callback)new PropertyValueFactory("totalVenda"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colCusto.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colCustoTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colVenda.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colVendaTotal.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnFinaliza.setOnAction(event -> this.finalizaBaixa());
        this.btnCancela.setOnAction(event -> this.cancelaBaixa());
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaProduto();
            }
        });
        this.btnProdutoPesquisa.setOnAction(event -> this.pesquisaProdutoForm());
        this.btnProdutoAdd.setOnAction(event -> this.addItem());
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem();
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.TAB) {
                BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
                if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
                    this.tfQuantidade.requestFocus();
                    this.tfQuantidade.selectAll();
                    return;
                }
                this.addItem();
            }
        });
        this.tfQuantidade.textProperty().addListener((observable, oldValue, newValue) -> {
            this.calculaTotalCusto();
            this.calculaTotalVenda();
        });
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem());
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnProdutoPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnProdutoAdd.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnFinaliza.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnCancela.setGraphic((Node)maximaIcone.cancel_24());
    }

    private void carregaCombos() {
        this.cbbMotivo.setItems(FXCollections.observableArrayList((Collection)this.baixaProdutoMotivoService.combo()));
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoNome.setText(this.produto.getNome().toUpperCase());
            this.tfPrecoCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getUltimoCusto(), (int)2));
            this.tfPrecoVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
        } else {
            this.tfProdutoNome.setText("");
            this.tfProdutoPesquisa.setText("");
            this.tfQuantidade.setText("");
            this.tfPrecoCusto.setText("");
            this.tfPrecoVenda.setText("");
            this.tfTotalCusto.setText("");
            this.tfTotalVenda.setText("");
            this.tfProdutoPesquisa.requestFocus();
        }
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfPrecoCusto);
        MaximaMask.monetaryField((TextField)this.tfPrecoVenda);
        MaximaMask.monetaryField((TextField)this.tfTotalCusto);
        MaximaMask.monetaryField((TextField)this.tfTotalVenda);
        MaximaMask.monetaryField((TextField)this.tfBaixaTotalCusto);
        MaximaMask.monetaryField((TextField)this.tfBaixaTotalVenda);
    }

    private void closeWindowEvent(WindowEvent event) {
    }

    private BaixaProdutoItem createBaixaProdutoItem(Produto produto, BigDecimal quantidade) {
        BaixaProdutoItem item = new BaixaProdutoItem();
        item.setAtivo(Boolean.TRUE);
        item.setDescricao(produto.getNome().toUpperCase());
        item.setNumItem(Integer.valueOf(this.itens.size() + 1));
        item.setProduto(produto);
        item.setPrecoCusto(produto.getUltimoCusto());
        item.setPrecoVenda(produto.getPrecoVenda());
        item.setQuantidade(quantidade);
        item.setTotalCusto(item.getPrecoCusto().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
        item.setTotalVenda(item.getPrecoVenda().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
        item.setUnidade(produto.getUnidade().getSigla());
        return item;
    }

    private BaixaProduto createBaixaProduto() {
        if (this.baixaProduto == null) {
            this.baixaProduto = new BaixaProduto();
        }
        this.baixaProduto.setDataEmissao((LocalDate)this.tfDataEmissao.getValue());
        this.baixaProduto.setExcluida(Boolean.FALSE);
        this.baixaProduto.setMotivo((BaixaProdutoMotivo)this.cbbMotivo.getSelectionModel().getSelectedItem());
        this.baixaProduto.setObservacao(MaximaUtils.getText((String)this.tfObservacao.getText()));
        this.baixaProduto.setUsuario(this.stageManager.getUsuario().getLogin());
        return this.baixaProduto;
    }
}

