/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CondicionalListaController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnImprime;
    @FXML
    private Button btnFechar;
    @FXML
    private Button btnAbrir;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TableView<VendaProduto> tabela;
    @FXML
    private TableColumn<VendaProduto, String> colCliente;
    @FXML
    private TableColumn<VendaProduto, String> colCodigo;
    @FXML
    private TableColumn<VendaProduto, String> colObservacao;
    @FXML
    private TableColumn<VendaProduto, String> colData;
    @FXML
    private TableColumn<VendaProduto, BigDecimal> colTotal;
    @FXML
    private TextField tfPesquisa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    private ObservableList<VendaProduto> vendaProdutoList;
    private VendaProduto vendaProduto;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.vendaProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.abrirCondicional();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public VendaProduto getCondicional() {
        return this.vendaProduto;
    }

    public void inicializa(ControleSAT controleSAT, Configuracao configuracao) {
        this.vendaProduto = null;
    }

    private void abrirCondicional() {
        this.vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (this.vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma condicional para abrir.");
            return;
        }
        this.fecharForm();
    }

    private void imprimeVendaSelecionada() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o.");
            return;
        }
        try {
            this.vendaProdutoService.imprimeVenda(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(CondicionalListaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("observacao"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.setRowFactory(tv -> new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadTabela() {
        this.vendaProdutoList.clear();
        List list = this.vendaProdutoService.listaCondicional(MaximaUtils.getText((String)this.tfPesquisa.getText()));
        this.vendaProdutoList.addAll((Collection)list);
        this.tabela.setItems(this.vendaProdutoList);
    }

    private void carregaIcones() {
        this.btnImprime.setGraphic((Node)new MaximaIcone().print());
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void registraAcoes() {
        this.btnPesquisa.setOnAction(evt -> this.loadTabela());
        this.btnImprime.setOnAction(event -> this.imprimeVendaSelecionada());
        this.btnFechar.setOnAction(evt -> this.fecharForm());
        this.btnAbrir.setOnAction(evt -> this.abrirCondicional());
        this.tabela.setOnMouseClicked(evt -> {
            if (evt.getClickCount() == 2) {
                this.abrirCondicional();
            }
        });
        this.tfPesquisa.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }

    private void fecharForm() {
        Stage stage = (Stage)this.btnFechar.getScene().getWindow();
        stage.close();
    }
}

