/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.EntradaMateriaPrimaFormController;
import br.com.maximasolutions.estoque.controller.EntradaMateriaPrimaImportaXmlController;
import br.com.maximasolutions.estoque.controller.EntradaProdutoController;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrima;
import br.com.maximasolutions.estoque.service.EntradaMateriaPrimaService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaProcessada;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntradaMateriaPrimaController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnEntradaManual;
    @FXML
    private Button btnImportaXml;
    @FXML
    private Button btnDelete;
    @FXML
    private TableView<EntradaMateriaPrima> tabela;
    @FXML
    private TableColumn<EntradaMateriaPrima, String> colFornecedor;
    @FXML
    private TableColumn<EntradaMateriaPrima, String> colNota;
    @FXML
    private TableColumn<EntradaMateriaPrima, String> colObservacao;
    @FXML
    private TableColumn<EntradaMateriaPrima, String> colData;
    @FXML
    private TableColumn<EntradaMateriaPrima, BigDecimal> colTotal;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @FXML
    private CheckBox ccbExcluida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private EntradaMateriaPrimaService entradaMateriaPrimaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private ObservableList<EntradaMateriaPrima> entradaMateriaPrimaList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.entradaMateriaPrimaList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void importaXml() {
        NFNotaProcessada notaProcessada;
        boolean sucesso;
        if (this.conf.getCaminhoNFeEntrada() == null || this.conf.getCaminhoNFeEntrada().isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Caminho para nota fiscal de entrada n\u00e3o configurado.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
            return;
        }
        File diretorioXml = new File(this.conf.getCaminhoNFeEntrada());
        if (!diretorioXml.exists() && !(sucesso = diretorioXml.mkdir())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: Diret\u00f3rio para armazenar os XML de entrada n\u00e3o encontrado.\nN\u00e3o foi poss\u00edvel criar a pasta.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(diretorioXml);
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Nota Fiscal de Entrada", new String[]{".xml"}));
        File arquivoXml = fileChooser.showOpenDialog(this.btnImportaXml.getScene().getWindow());
        if (arquivoXml == null) {
            return;
        }
        try {
            notaProcessada = (NFNotaProcessada)new DFPersister().read(NFNotaProcessada.class, arquivoXml);
        }
        catch (Exception ex) {
            Logger.getLogger(EntradaMateriaPrimaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel parsear o arquivo xml para objeto nota fiscal.\nVerifique se o arquivo xml \u00e9 uma nota fiscal eletr\u00f4nica 4.0\nN\u00e3o \u00e9 poss\u00edvel continuar.");
            return;
        }
        if (notaProcessada.getNota() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel carregar a nota fiscal.");
            return;
        }
        if (this.entradaMateriaPrimaService.getByChaveAcesso(notaProcessada.getNota().getInfo().getChaveAcesso()) != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nota fiscal j\u00e1 cadastrada no sistema.");
            return;
        }
        try {
            Stage importaXmlForm = new MaximaDialogFX().createWindowVBox(this.stageManager, "/fxml/estoque/entradaMateriaPrima/EntradaMateriaPrimaImportaXml.fxml", "Importa\u00e7\u00e3o Nota Fiscal de Entrada");
            EntradaMateriaPrimaImportaXmlController controller = (EntradaMateriaPrimaImportaXmlController)importaXmlForm.getUserData();
            controller.inicializa(notaProcessada.getNota().getInfo(), notaProcessada.toString());
            importaXmlForm.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EntradaMateriaPrimaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de importa\u00e7\u00e3o de nota fiscal de entrada.\nErro no arquivo: EntradaMateriaPrimaImporta.fxml.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
        }
    }

    private void edita() {
        EntradaMateriaPrima entradaMateriaPrima = (EntradaMateriaPrima)this.tabela.getSelectionModel().getSelectedItem();
        if (entradaMateriaPrima == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma entrada de materiaPrima.");
            return;
        }
        if (entradaMateriaPrima.getExcluida() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Aviso: Entrada de materiaPrima j\u00e1 excluida do banco de dados.\nN\u00e3o pode ser editada.");
            return;
        }
        this.abreForm(entradaMateriaPrima);
    }

    private void entradaManual() {
        this.abreForm(null);
    }

    private void abreForm(EntradaMateriaPrima entradaMateriaPrima) {
        try {
            Stage form = new MaximaDialogFX().createWindowVBox(this.stageManager, "/fxml/estoque/entradaMateriaPrima/EntradaMateriaPrimaForm.fxml", "Cadastro de Entrada de Mat\u00e9ria Prima");
            EntradaMateriaPrimaFormController controller = (EntradaMateriaPrimaFormController)form.getUserData();
            controller.inicializaEntrada(entradaMateriaPrima);
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(EntradaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir form de entrada de produto.");
        }
    }

    private void delete() {
        EntradaMateriaPrima entradaMateriaPrima = (EntradaMateriaPrima)this.tabela.getSelectionModel().getSelectedItem();
        if (entradaMateriaPrima == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma entrada de materiaPrima para remover.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja remover a entrada de materiaPrima?")) {
            return;
        }
        try {
            this.entradaMateriaPrimaService.delete(entradaMateriaPrima);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Entrada de materiaPrima removida com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EntradaMateriaPrimaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel remover a entrada de materiaPrima.\nCausa:" + ex.getMessage()));
        }
    }

    private void setColumnProperties() {
        this.colNota.setCellValueFactory((Callback)new PropertyValueFactory("numeroNota"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colFornecedor.setCellValueFactory((Callback)new PropertyValueFactory("fornecedor"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("observacao"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.entradaMateriaPrimaList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.entradaMateriaPrimaService.lista(inicio, fim, Boolean.valueOf(this.ccbExcluida.isSelected()), filtro);
        this.entradaMateriaPrimaList.addAll((Collection)list);
        this.tabela.setItems(this.entradaMateriaPrimaList);
        this.lblTotal.setText("R$ " + MaximaNumber.bigDecimalToString((BigDecimal)this.entradaMateriaPrimaService.totalLista(inicio, fim, Boolean.valueOf(this.ccbExcluida.isSelected()), filtro), (int)2));
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnEntradaManual.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void registraAcoes() {
        this.btnEntradaManual.setOnAction(event -> this.entradaManual());
        this.btnImportaXml.setOnAction(event -> this.importaXml());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.edita();
            }
        });
    }
}

