/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.MateriaPrimaPesquisaController;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrima;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrimaItem;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.service.EntradaMateriaPrimaService;
import br.com.maximasolutions.estoque.service.MateriaPrimaService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.geral.controller.FornecedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntradaMateriaPrimaFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private MateriaPrimaService materiaPrimaService;
    @Autowired
    private EntradaMateriaPrimaService entradaMateriaPrimaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private Configuracao conf;
    private Fornecedor fornecedor;
    private MateriaPrima materiaPrima;
    private ObservableList<EntradaMateriaPrimaItem> entradaMateriaPrimaItemList;
    private EntradaMateriaPrima entradaMateriaPrima;
    private List<EntradaMateriaPrimaItem> itens;
    @FXML
    private VBox vBox;
    @FXML
    private Pane painelTotal;
    @FXML
    private DatePicker tfDataEmissao;
    @FXML
    private DatePicker tfDataEntrada;
    @FXML
    private TextField tfNumeroNota;
    @FXML
    private TextField tfChaveAcessoNfe;
    @FXML
    private TextField tfFornecedorPesquisa;
    @FXML
    private TextField tfFornecedorNome;
    @FXML
    private TextField tfFornecedorTelefone;
    @FXML
    private TextField tfFornecedorEndereco;
    @FXML
    private TextField tfMateriaPrimaPesquisa;
    @FXML
    private TextField tfMateriaPrimaNome;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfPrecoUnitario;
    @FXML
    private TextField tfTotalItem;
    @FXML
    private TextField tfValorMateriaPrimas;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorFrete;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TableView<EntradaMateriaPrimaItem> tabela;
    @FXML
    private TableColumn<EntradaMateriaPrimaItem, String> colMateriaPrima;
    @FXML
    private TableColumn<EntradaMateriaPrimaItem, String> colCodigo;
    @FXML
    private TableColumn<EntradaMateriaPrimaItem, String> colReferencia;
    @FXML
    private TableColumn<EntradaMateriaPrimaItem, String> colItem;
    @FXML
    private TableColumn<EntradaMateriaPrimaItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<EntradaMateriaPrimaItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<EntradaMateriaPrimaItem, BigDecimal> colTotalItem;
    @FXML
    private Button btnFornecedorPesquisa;
    @FXML
    private Button btnMateriaPrimaPesquisa;
    @FXML
    private Button btnMateriaPrimaAdd;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnFinaliza;

    public void initialize(URL location, ResourceBundle resources) {
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
    }

    public void inicializaEntrada(EntradaMateriaPrima entradaMateriaPrima1) {
        if (entradaMateriaPrima1 == null) {
            this.fornecedor = null;
            this.entradaMateriaPrima = null;
            this.itens = new ArrayList();
        } else {
            this.entradaMateriaPrima = entradaMateriaPrima1;
            this.fornecedor = this.entradaMateriaPrima.getFornecedor();
            this.itens = this.entradaMateriaPrimaService.itens(this.entradaMateriaPrima);
            this.tfDataEmissao.setValue((Object)this.entradaMateriaPrima.getDataEmissao());
            this.tfDataEntrada.setValue((Object)this.entradaMateriaPrima.getDataEntrada());
            this.tfNumeroNota.setText(this.entradaMateriaPrima.getNumeroNota());
            this.tfChaveAcessoNfe.setText(this.entradaMateriaPrima.getNfeChaveAcesso());
        }
        this.inicializaItem();
        this.loadDadosFornecedor();
        Stage stage = (Stage)this.vBox.getScene().getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        this.tfDataEmissao.requestFocus();
    }

    private void inicializaItem() {
        this.materiaPrima = null;
        this.loadDadosMateriaPrima();
        this.loadValoresTotais();
        this.loadItens();
    }

    private void loadItens() {
        this.entradaMateriaPrimaItemList = FXCollections.observableArrayList();
        this.entradaMateriaPrimaItemList.clear();
        BigDecimal total = BigDecimal.ZERO;
        for (EntradaMateriaPrimaItem item : this.itens) {
            if (item.getExcluido().booleanValue()) continue;
            total = total.add(item.getTotalCusto());
            this.entradaMateriaPrimaItemList.add((Object)item);
        }
        this.tabela.setItems(this.entradaMateriaPrimaItemList);
        this.tfValorMateriaPrimas.setText(MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
    }

    private void addItem() {
        if (!this.validaItemForm()) {
            return;
        }
        this.itens.add(this.createEntradaMateriaPrimaItem(this.materiaPrima, MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText()), MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText())));
        this.inicializaItem();
    }

    private void editaItem() {
    }

    private void deleteItem() {
        EntradaMateriaPrimaItem item = (EntradaMateriaPrimaItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum materiaPrima selecionado.");
            return;
        }
        int cont = 0;
        for (EntradaMateriaPrimaItem i : this.itens) {
            if (i.getNumItem().equals(item.getNumItem())) {
                i.setExcluido(Boolean.TRUE);
                break;
            }
            ++cont;
        }
        cont = 0;
        for (EntradaMateriaPrimaItem i : this.itens) {
            ++cont;
            if (i.getExcluido().booleanValue()) continue;
            i.setNumItem(Integer.valueOf(cont));
        }
        this.inicializaItem();
    }

    private void finalizaEntrada() {
        if (!this.validaPedidoForm()) {
            return;
        }
        try {
            this.entradaMateriaPrimaService.salva(this.createEntradaMateriaPrima(), this.itens);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Entrada de materiaPrima cadastrada com sucesso.");
            Stage form = (Stage)this.btnFinaliza.getScene().getWindow();
            form.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EntradaMateriaPrimaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel salvar a entrada de materiaPrimas.\nCausa: " + ex.getMessage()));
        }
    }

    private void cancelaEntrada() {
        this.inicializaEntrada(null);
    }

    private void loadValoresTotais() {
        if (this.entradaMateriaPrima == null) {
            this.tfValorMateriaPrimas.setText("");
            this.tfValorFrete.setText("");
            this.tfValorDesconto.setText("");
            this.tfValorTotal.setText("");
        } else {
            this.tfValorMateriaPrimas.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.entradaMateriaPrima.getValorProdutos(), (int)2));
            this.tfValorFrete.setText(MaximaNumber.bigDecimalToString((BigDecimal)BigDecimal.ZERO, (int)2));
            this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.entradaMateriaPrima.getDesconto(), (int)2));
            this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.entradaMateriaPrima.getTotal(), (int)2));
        }
    }

    private boolean validaItemForm() {
        boolean valido = true;
        if (this.materiaPrima == null) {
            this.tfMateriaPrimaPesquisa.getStyleClass().add((Object)"error");
            this.tfMateriaPrimaNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfMateriaPrimaPesquisa.getStyleClass().remove((Object)"error");
            this.tfMateriaPrimaNome.getStyleClass().remove((Object)"error");
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfQuantidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfQuantidade.getStyleClass().remove((Object)"error");
        }
        BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
        if (precoUnitario == null || precoUnitario.compareTo(BigDecimal.ZERO) < 0) {
            this.tfPrecoUnitario.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfPrecoUnitario.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaPedidoForm() {
        boolean valido = true;
        if (this.tfDataEmissao.getValue() == null) {
            this.tfDataEmissao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataEmissao.getStyleClass().remove((Object)"error");
        }
        if (this.fornecedor == null) {
            this.tfFornecedorPesquisa.getStyleClass().add((Object)"error");
            this.tfFornecedorNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfFornecedorPesquisa.getStyleClass().remove((Object)"error");
            this.tfFornecedorNome.getStyleClass().remove((Object)"error");
        }
        if (this.entradaMateriaPrimaItemList == null || this.entradaMateriaPrimaItemList.isEmpty()) {
            this.tabela.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tabela.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void calculaTotalItem() {
        BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (precoUnitario == null || quantidade == null) {
            this.tfTotalItem.setText(null);
            return;
        }
        BigDecimal totalItem = precoUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalItem.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalItem, (int)2));
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colReferencia.setCellValueFactory((Callback)new PropertyValueFactory("referencia"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigoBarras"));
        this.colMateriaPrima.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoCusto"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("totalCusto"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalItem.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnFinaliza.setOnAction(event -> this.finalizaEntrada());
        this.btnCancela.setOnAction(event -> this.cancelaEntrada());
        this.tfFornecedorPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaFornecedor();
            }
        });
        this.btnFornecedorPesquisa.setOnAction(event -> this.pesquisaFornecedorForm());
        this.tfMateriaPrimaPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaMateriaPrima();
            }
        });
        this.btnMateriaPrimaPesquisa.setOnAction(event -> this.pesquisaMateriaPrimaForm());
        this.btnMateriaPrimaAdd.setOnAction(event -> this.addItem());
        this.vBox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F2) {
                this.pesquisaFornecedorForm();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem();
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.TAB) {
                System.out.println("EVENTO: " + event.getCode() + " - " + KeyCode.TAB);
                BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
                if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
                    this.tfQuantidade.requestFocus();
                    this.tfQuantidade.selectAll();
                    return;
                }
                this.tfPrecoUnitario.requestFocus();
                this.tfPrecoUnitario.selectAll();
                this.calculaTotalItem();
            }
        });
        this.tfPrecoUnitario.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
                if (precoUnitario == null || precoUnitario.compareTo(BigDecimal.ZERO) <= 0) {
                    this.tfPrecoUnitario.requestFocus();
                    this.tfPrecoUnitario.selectAll();
                    return;
                }
                this.tfObservacao.requestFocus();
                this.tfObservacao.selectAll();
                this.calculaTotalItem();
            }
        });
        this.tfObservacao.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addItem();
            }
        });
        this.tfQuantidade.textProperty().addListener((observable, oldValue, newValue) -> this.calculaTotalItem());
        this.tfPrecoUnitario.setOnKeyReleased(event -> this.calculaTotalItem());
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem());
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnFornecedorPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnMateriaPrimaPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnMateriaPrimaAdd.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnFinaliza.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnCancela.setGraphic((Node)maximaIcone.cancel_24());
    }

    private void carregaCombos() {
    }

    private void pesquisaMateriaPrima() {
        String materiaPrimaCodigo = this.tfMateriaPrimaPesquisa.getText().trim();
        if (materiaPrimaCodigo.isEmpty()) {
            return;
        }
        this.materiaPrima = this.materiaPrimaService.getByCodigo(materiaPrimaCodigo);
        if (this.materiaPrima != null) {
            this.loadDadosMateriaPrima();
        } else {
            this.pesquisaMateriaPrimaForm();
        }
    }

    private void pesquisaMateriaPrimaForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/materiaPrima/MateriaPrimaPesquisa.fxml", "Pesquisa de materiaPrima");
            MateriaPrimaPesquisaController controller = (MateriaPrimaPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMateriaPrimaPesquisa.getText().trim());
            stage.showAndWait();
            this.materiaPrima = controller.getMateriaPrimaSelecionado();
            this.loadDadosMateriaPrima();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'MateriaPrimaPesquisa.fxml'");
        }
    }

    private void loadDadosMateriaPrima() {
        if (this.materiaPrima != null) {
            this.tfMateriaPrimaPesquisa.setText(this.materiaPrima.getCodigo());
            this.tfMateriaPrimaNome.setText(this.materiaPrima.getNome().toUpperCase());
            this.tfPrecoUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.materiaPrima.getUltimoCusto(), (int)2));
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
        } else {
            this.tfMateriaPrimaNome.setText("");
            this.tfMateriaPrimaPesquisa.setText("");
            this.tfObservacao.setText("");
            this.tfQuantidade.setText("");
            this.tfPrecoUnitario.setText("");
            this.tfTotalItem.setText("");
            this.tfMateriaPrimaPesquisa.requestFocus();
        }
    }

    private void pesquisaFornecedor() {
        String fornecedorCodigo = this.tfFornecedorPesquisa.getText().trim();
        if (fornecedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long fornecedorCodigoNumero = Long.valueOf(fornecedorCodigo);
            Fornecedor fornecedorPesquisa = this.fornecedorService.getById(fornecedorCodigoNumero);
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
            } else {
                this.fornecedor = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de fornecedor n\u00e3o encontrado.");
                this.tfFornecedorPesquisa.requestFocus();
                this.tfFornecedorPesquisa.selectAll();
            }
            this.loadDadosFornecedor();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaFornecedorForm();
            return;
        }
    }

    private void pesquisaFornecedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/fornecedor/FornecedorPesquisa.fxml", "Pesquisa de fornecedor");
            FornecedorPesquisaController controller = (FornecedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfFornecedorPesquisa.getText().trim());
            stage.showAndWait();
            Fornecedor fornecedorPesquisa = controller.getFornecedorSelecionado();
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
                this.loadDadosFornecedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'FornecedorPesquisa'");
        }
    }

    private void loadDadosFornecedor() {
        if (this.fornecedor != null) {
            this.tfFornecedorPesquisa.setText(this.fornecedor.getId().toString());
            this.tfFornecedorNome.setText(this.fornecedor.getNome().toUpperCase());
            this.tfFornecedorTelefone.setText(this.fornecedor.getTelefone());
            this.tfFornecedorEndereco.setText(this.fornecedor.getEnderecoCompleto());
            this.tfMateriaPrimaPesquisa.requestFocus();
            this.tfMateriaPrimaPesquisa.selectAll();
        } else {
            this.tfFornecedorNome.setText("");
            this.tfFornecedorPesquisa.setText("");
            this.tfFornecedorTelefone.setText("");
            this.tfFornecedorEndereco.setText("");
            this.tfFornecedorPesquisa.requestFocus();
        }
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfPrecoUnitario);
    }

    private void closeWindowEvent(WindowEvent event) {
    }

    private EntradaMateriaPrimaItem createEntradaMateriaPrimaItem(MateriaPrima materiaPrima, BigDecimal precoCusto, BigDecimal quantidade) {
        EntradaMateriaPrimaItem item = new EntradaMateriaPrimaItem();
        item.setAtivo(Boolean.TRUE);
        item.setDataOperacao(LocalDate.now());
        item.setDescricao(materiaPrima.getNome().toUpperCase());
        item.setNumItem(Integer.valueOf(this.itens.size() + 1));
        item.setMateriaPrima(materiaPrima);
        item.setPrecoCusto(precoCusto);
        item.setQuantidade(quantidade);
        item.setTotalCusto(item.getPrecoCusto().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
        item.setUnidade(materiaPrima.getUnidade().getSigla());
        item.setCodigoBarras(materiaPrima.getCodigo());
        return item;
    }

    private EntradaMateriaPrima createEntradaMateriaPrima() {
        if (this.entradaMateriaPrima == null) {
            this.entradaMateriaPrima = new EntradaMateriaPrima();
        }
        this.entradaMateriaPrima.setDataEmissao((LocalDate)this.tfDataEmissao.getValue());
        this.entradaMateriaPrima.setDataEntrada((LocalDate)this.tfDataEntrada.getValue());
        this.entradaMateriaPrima.setDataOperacao(LocalDateTime.now());
        this.entradaMateriaPrima.setDesconto(BigDecimal.ZERO);
        this.entradaMateriaPrima.setDespesa(BigDecimal.ZERO);
        this.entradaMateriaPrima.setExcluida(Boolean.FALSE);
        this.entradaMateriaPrima.setFornecedor(this.fornecedor);
        this.entradaMateriaPrima.setFrete(BigDecimal.ZERO);
        this.entradaMateriaPrima.setHistorico("");
        this.entradaMateriaPrima.setHistoricoDespesa("");
        this.entradaMateriaPrima.setNumeroNota(MaximaUtils.getText((String)this.tfNumeroNota.getText()));
        this.entradaMateriaPrima.setNfeChaveAcesso(MaximaUtils.removeCaracteres((String)this.tfChaveAcessoNfe.getText()));
        this.entradaMateriaPrima.setTotal(BigDecimal.ZERO);
        this.entradaMateriaPrima.setValorProdutos(BigDecimal.ZERO);
        return this.entradaMateriaPrima;
    }
}

