/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.bean.EntradaMateriaPrimaItemBean;
import br.com.maximasolutions.estoque.controller.MateriaPrimaFormController;
import br.com.maximasolutions.estoque.controller.MateriaPrimaPesquisaController;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrima;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrimaItem;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.EntradaMateriaPrimaService;
import br.com.maximasolutions.estoque.service.MateriaPrimaService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.fiscal.modelo.ConfiguracaoFiscalEntradaSaida;
import br.com.maximasolutions.fiscal.service.ConfiguracaoFiscalEntradaSaidaService;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoEmitente;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItem;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTotal;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntradaMateriaPrimaImportaXmlController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private MateriaPrimaService materiaPrimaService;
    @Autowired
    private EntradaMateriaPrimaService entradaMateriaPrimaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private UnidadeService unidadeService;
    @Autowired
    private ConfiguracaoFiscalEntradaSaidaService configuracaoFiscalEntradaSaidaService;
    @Autowired
    private MunicipioService municipioService;
    private Configuracao conf;
    private Fornecedor fornecedor;
    private List<EntradaMateriaPrimaItemBean> lista;
    private ObservableList<EntradaMateriaPrimaItemBean> entradaMateriaPrimaItemList;
    private EntradaMateriaPrima entradaMateriaPrima;
    private NFNotaInfo nota;
    @FXML
    private VBox vBox;
    @FXML
    private Pane painelTotal;
    @FXML
    private DatePicker tfDataEmissao;
    @FXML
    private DatePicker tfDataEntrada;
    @FXML
    private TextField tfNumeroNota;
    @FXML
    private TextField tfChaveAcessoNfe;
    @FXML
    private TextField tfFornecedorCnpj;
    @FXML
    private TextField tfFornecedorNome;
    @FXML
    private TextField tfFornecedorTelefone;
    @FXML
    private TextField tfFornecedorEndereco;
    @FXML
    private TextField tfBaseCalculoICMS;
    @FXML
    private TextField tfValorICMS;
    @FXML
    private TextField tfBaseCalculoICMSST;
    @FXML
    private TextField tfValorICMSST;
    @FXML
    private TextField tfValorProdutos;
    @FXML
    private TextField tfValorFrete;
    @FXML
    private TextField tfValorSeguro;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorOutrasDespesas;
    @FXML
    private TextField tfValorIpi;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TableView<EntradaMateriaPrimaItemBean> tabela;
    @FXML
    private TableColumn<EntradaMateriaPrimaItemBean, String> colProduto;
    @FXML
    private TableColumn<EntradaMateriaPrimaItemBean, String> colCodigo;
    @FXML
    private TableColumn<EntradaMateriaPrimaItemBean, String> colReferencia;
    @FXML
    private TableColumn<EntradaMateriaPrimaItemBean, String> colItem;
    @FXML
    private TableColumn<EntradaMateriaPrimaItemBean, BigDecimal> colUnitario;
    @FXML
    private TableColumn<EntradaMateriaPrimaItemBean, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<EntradaMateriaPrimaItemBean, BigDecimal> colTotalItem;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnFinaliza;
    private HashMap<Integer, MateriaPrima> vinculados;
    private String xml;

    public void initialize(URL location, ResourceBundle resources) {
        this.entradaMateriaPrimaItemList = FXCollections.observableArrayList();
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
    }

    public void inicializa(NFNotaInfo nota, String xml) {
        this.entradaMateriaPrima = null;
        this.fornecedor = null;
        this.lista = null;
        this.xml = xml;
        this.vinculados = new HashMap();
        this.nota = nota;
        this.tfDataEmissao.setValue((Object)nota.getIdentificacao().getDataHoraEmissao().toLocalDate());
        this.tfNumeroNota.setText(nota.getIdentificacao().getNumeroNota());
        this.tfChaveAcessoNfe.setText(nota.getChaveAcesso());
        this.loadDadosFornecedor(nota.getEmitente());
        this.loadValoresTotais(nota.getTotal());
        this.loadTabela();
    }

    private void loadDadosFornecedor(NFNotaInfoEmitente emitente) {
        String cnpj = emitente.getCnpj();
        try {
            this.fornecedor = this.fornecedorService.getByCnpj(cnpj);
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(EntradaMateriaPrimaImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
            return;
        }
        if (this.fornecedor == null) {
            this.fornecedor = new Fornecedor();
            this.fornecedor.setAtivo(Boolean.TRUE);
            this.fornecedor.setBairro(emitente.getEndereco().getBairro());
            this.fornecedor.setCep(emitente.getEndereco().getCep());
            if (emitente.getEndereco().getComplemento() != null) {
                this.fornecedor.setComplemento(emitente.getEndereco().getComplemento());
            }
            this.fornecedor.setCpf(cnpj);
            this.fornecedor.setDataCadastro(LocalDate.now());
            this.fornecedor.setEndereco(emitente.getEndereco().getLogradouro());
            if (emitente.getNomeFantasia() != null) {
                this.fornecedor.setFantasia(emitente.getNomeFantasia());
            }
            this.fornecedor.setMunicipio(this.municipioService.getByIbge(emitente.getEndereco().getCodigoMunicipio()));
            this.fornecedor.setNome(emitente.getRazaoSocial());
            this.fornecedor.setNumero(emitente.getEndereco().getNumero());
            if (emitente.getInscricaoEstadual() != null) {
                this.fornecedor.setRg(emitente.getInscricaoEstadual());
            }
            if (emitente.getEndereco().getTelefone() != null && !emitente.getEndereco().getTelefone().isEmpty()) {
                this.fornecedor.setTelefone(emitente.getEndereco().getTelefone());
            } else {
                this.fornecedor.setTelefone("00000000");
            }
            try {
                this.fornecedor = this.fornecedorService.save(this.fornecedor);
            }
            catch (MaximaException ex) {
                Logger.getLogger(EntradaMateriaPrimaImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel cadastrar o fornecedor.\n" + ex.getMessage()));
            }
        }
        if (this.fornecedor != null) {
            this.tfFornecedorCnpj.setText(this.fornecedor.getCpf());
            this.tfFornecedorNome.setText(this.fornecedor.getNome().toUpperCase());
            this.tfFornecedorTelefone.setText(this.fornecedor.getTelefone());
            this.tfFornecedorEndereco.setText(this.fornecedor.getEnderecoCompleto());
        }
    }

    private void loadItens() {
        this.lista = new ArrayList();
        for (NFNotaInfoItem item : this.nota.getItens()) {
            EntradaMateriaPrimaItemBean bean = new EntradaMateriaPrimaItemBean();
            if (item.getProduto().getCodigoDeBarras() != null && !item.getProduto().getCodigoDeBarras().isEmpty() && !item.getProduto().getCodigoDeBarras().equals("SEM GTIN")) {
                bean.setCodigo(item.getProduto().getCodigoDeBarras());
            } else {
                bean.setCodigo(item.getProduto().getCodigo());
            }
            if (item.getProduto().getValorDesconto() != null) {
                bean.setDesconto(new BigDecimal(item.getProduto().getValorDesconto()));
            } else {
                bean.setDesconto(BigDecimal.ZERO);
            }
            bean.setDescricao(item.getProduto().getDescricao().toUpperCase());
            if (item.getProduto().getValorFrete() != null) {
                bean.setFrete(new BigDecimal(item.getProduto().getValorFrete()));
            } else {
                bean.setFrete(BigDecimal.ZERO);
            }
            bean.setNumeroItem(item.getNumeroItem());
            bean.setPrecoTotal(new BigDecimal(item.getProduto().getValorTotalBruto()));
            bean.setPrecoUnitario(new BigDecimal(item.getProduto().getValorUnitario()));
            bean.setQuantidade(new BigDecimal(item.getProduto().getQuantidadeComercial()));
            bean.setReferencia(item.getProduto().getCodigo());
            bean.setMateriaPrima(this.existeMateriaPrima(bean.getCodigo(), bean.getReferencia()));
            bean.setExiste(Boolean.valueOf(bean.getMateriaPrima() != null));
            if (!bean.getExiste().booleanValue() && this.vinculados.containsKey(bean.getNumeroItem())) {
                bean.setMateriaPrima((MateriaPrima)this.vinculados.get(bean.getNumeroItem()));
                bean.setExiste(Boolean.valueOf(true));
            }
            bean.setNcm(item.getProduto().getNcm());
            System.out.println("**& &*&* : " + bean.getMateriaPrima());
            if (!(bean.getMateriaPrima() == null || bean.getMateriaPrima().getUnidade().getSigla().equals(item.getProduto().getUnidadeComercial()) || bean.getMateriaPrima().getUnidadeEntrada() != null && bean.getMateriaPrima().getUnidadeEntrada().getSigla().equals(item.getProduto().getUnidadeComercial()))) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)(bean.getMateriaPrima().getNome() + ": unidade de entrada diferente da unidade configurada."));
            }
            bean.setUnidade(item.getProduto().getUnidadeComercial());
            bean.setCfopEntrada(item.getProduto().getCfop());
            if (bean.getCfopEntrada().equals("5101")) {
                bean.setCfopFiscal("1101");
            }
            if (bean.getCfopEntrada().equals("6101")) {
                bean.setCfopFiscal("2101");
            }
            if (bean.getCfopEntrada().equals("5102")) {
                bean.setCfopFiscal("1101");
            }
            if (bean.getCfopEntrada().equals("6102")) {
                bean.setCfopFiscal("2101");
            }
            bean.setOrigem(NFOrigem.NACIONAL);
            if (item.getImposto().getIcms().getIcms00() != null) {
                bean.setAliquotaIcms(new BigDecimal(item.getImposto().getIcms().getIcms00().getPercentualAliquota()));
                bean.setBaseCalculoIcms(new BigDecimal(item.getImposto().getIcms().getIcms00().getValorBaseCalculo()));
                bean.setValorIcms(new BigDecimal(item.getImposto().getIcms().getIcms00().getValorTributo()));
                bean.setCst(item.getImposto().getIcms().getIcms00().getSituacaoTributaria());
            }
            if (item.getImposto().getIcms().getIcms10() != null) {
                bean.setAliquotaIcms(new BigDecimal(item.getImposto().getIcms().getIcms10().getPercentualAliquota()));
                bean.setBaseCalculoIcms(new BigDecimal(item.getImposto().getIcms().getIcms10().getValorBaseCalculo()));
                bean.setValorIcms(new BigDecimal(item.getImposto().getIcms().getIcms10().getValorTributo()));
                bean.setCst(item.getImposto().getIcms().getIcms10().getSituacaoTributaria());
            }
            if (item.getImposto().getIcms().getIcms20() != null) {
                bean.setAliquotaIcms(new BigDecimal(item.getImposto().getIcms().getIcms20().getPercentualAliquota()));
                bean.setBaseCalculoIcms(new BigDecimal(item.getImposto().getIcms().getIcms20().getValorBCICMS()));
                bean.setValorIcms(new BigDecimal(item.getImposto().getIcms().getIcms20().getValorTributo()));
                bean.setCst(item.getImposto().getIcms().getIcms20().getSituacaoTributaria());
            }
            if (item.getImposto().getIcms().getIcms30() != null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Importa\u00e7\u00e3o n\u00e3o implementada. Entre em contato com a empresa respons\u00e1vel pelo software.");
                break;
            }
            if (item.getImposto().getIcms().getIcms40() != null) {
                bean.setAliquotaIcms(BigDecimal.ZERO);
                bean.setBaseCalculoIcms(BigDecimal.ZERO);
                bean.setValorIcms(BigDecimal.ZERO);
                bean.setCst(item.getImposto().getIcms().getIcms40().getSituacaoTributaria());
            }
            if (item.getImposto().getIcms().getIcms51() != null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Importa\u00e7\u00e3o n\u00e3o implementada. Entre em contato com a empresa respons\u00e1vel pelo software.");
                break;
            }
            if (item.getImposto().getIcms().getIcms60() != null) {
                bean.setAliquotaIcms(BigDecimal.ZERO);
                bean.setBaseCalculoIcms(BigDecimal.ZERO);
                bean.setValorIcms(BigDecimal.ZERO);
                bean.setCst(item.getImposto().getIcms().getIcms60().getSituacaoTributaria());
            }
            if (item.getImposto().getIcms().getIcms70() != null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Importa\u00e7\u00e3o n\u00e3o implementada. Entre em contato com a empresa respons\u00e1vel pelo software.");
                break;
            }
            if (item.getImposto().getIcms().getIcms90() != null) {
                bean.setAliquotaIcms(new BigDecimal(item.getImposto().getIcms().getIcms90().getPercentualAliquota()));
                bean.setBaseCalculoIcms(new BigDecimal(item.getImposto().getIcms().getIcms90().getValorBC()));
                bean.setValorIcms(new BigDecimal(item.getImposto().getIcms().getIcms90().getValorTributo()));
                bean.setCst(item.getImposto().getIcms().getIcms90().getSituacaoTributaria());
            }
            if (item.getImposto().getIcms().getIcmssn101() != null) {
                bean.setAliquotaCreditoIcms(new BigDecimal(item.getImposto().getIcms().getIcmssn101().getPercentualAliquotaAplicavelCalculoCreditoSN()));
                bean.setValorCreditoIcms(new BigDecimal(item.getImposto().getIcms().getIcmssn101().getValorCreditoICMSSN()));
                bean.setCsosn(item.getImposto().getIcms().getIcmssn101().getSituacaoOperacaoSN());
            }
            if (item.getImposto().getIcms().getIcmssn102() != null) {
                bean.setCsosn(item.getImposto().getIcms().getIcmssn102().getSituacaoOperacaoSN());
            }
            if (item.getImposto().getIcms().getIcmssn201() != null) {
                bean.setAliquotaCreditoIcms(new BigDecimal(item.getImposto().getIcms().getIcmssn201().getPercentualAliquotaAplicavelCalculoCreditoSN()));
                bean.setValorCreditoIcms(new BigDecimal(item.getImposto().getIcms().getIcmssn201().getValorCreditoICMSSN()));
                bean.setCsosn(item.getImposto().getIcms().getIcmssn201().getSituacaoOperacaoSN());
            }
            if (item.getImposto().getIcms().getIcmssn202() != null) {
                bean.setCsosn(item.getImposto().getIcms().getIcmssn202().getSituacaoOperacaoSN());
            }
            if (item.getImposto().getIcms().getIcmssn500() != null) {
                bean.setCsosn(item.getImposto().getIcms().getIcmssn500().getSituacaoOperacaoSN());
            }
            if (item.getImposto().getPis() != null) {
                if (item.getImposto().getPis().getAliquota() != null) {
                    bean.setPis(item.getImposto().getPis().getAliquota().getSituacaoTributaria());
                    bean.setBaseCalculoPis(new BigDecimal(item.getImposto().getPis().getAliquota().getValorBaseCalculo()));
                    bean.setAliquotaPis(new BigDecimal(item.getImposto().getPis().getAliquota().getPercentualAliquota()));
                    bean.setValorPis(new BigDecimal(item.getImposto().getPis().getAliquota().getValorTributo()));
                } else if (item.getImposto().getPis().getOutrasOperacoes() != null) {
                    bean.setPis(item.getImposto().getPis().getOutrasOperacoes().getSituacaoTributaria());
                    bean.setBaseCalculoPis(new BigDecimal(item.getImposto().getPis().getOutrasOperacoes().getValorBaseCalculo()));
                    bean.setAliquotaPis(new BigDecimal(item.getImposto().getPis().getOutrasOperacoes().getPercentualAliquota()));
                    bean.setValorPis(new BigDecimal(item.getImposto().getPis().getOutrasOperacoes().getValorTributo()));
                } else {
                    bean.setPis(item.getImposto().getPis().getNaoTributado().getSituacaoTributaria());
                    bean.setValorPis(BigDecimal.ZERO);
                }
            } else {
                bean.setValorPis(BigDecimal.ZERO);
            }
            if (item.getImposto().getCofins() != null) {
                if (item.getImposto().getCofins().getAliquota() != null) {
                    bean.setCofins(item.getImposto().getCofins().getAliquota().getSituacaoTributaria());
                    bean.setBaseCalculoCofins(new BigDecimal(item.getImposto().getCofins().getAliquota().getValorBaseCalculo()));
                    bean.setAliquotaCofins(new BigDecimal(item.getImposto().getCofins().getAliquota().getPercentualAliquota()));
                    bean.setValorCofins(new BigDecimal(item.getImposto().getCofins().getAliquota().getValor()));
                } else if (item.getImposto().getCofins().getOutrasOperacoes() != null) {
                    bean.setCofins(item.getImposto().getCofins().getOutrasOperacoes().getSituacaoTributaria());
                    bean.setBaseCalculoCofins(new BigDecimal(item.getImposto().getCofins().getOutrasOperacoes().getValorBaseCalculo()));
                    bean.setAliquotaCofins(new BigDecimal(item.getImposto().getCofins().getOutrasOperacoes().getPercentualCOFINS()));
                    bean.setValorCofins(new BigDecimal(item.getImposto().getCofins().getOutrasOperacoes().getValorCOFINS()));
                } else {
                    bean.setCofins(item.getImposto().getCofins().getNaoTributavel().getSituacaoTributaria());
                    bean.setValorCofins(BigDecimal.ZERO);
                }
            } else {
                bean.setValorCofins(BigDecimal.ZERO);
            }
            if (item.getImposto().getIpi() != null) {
                if (item.getImposto().getIpi().getTributado() != null) {
                    bean.setIpi(item.getImposto().getIpi().getTributado().getSituacaoTributaria());
                    bean.setBaseCalculoIpi(new BigDecimal(item.getImposto().getIpi().getTributado().getValorBaseCalculo()));
                    bean.setAliquotaIpi(new BigDecimal(item.getImposto().getIpi().getTributado().getPercentualAliquota()));
                    bean.setValorIpi(new BigDecimal(item.getImposto().getIpi().getTributado().getValorTributo()));
                } else {
                    bean.setIpi(item.getImposto().getIpi().getNaoTributado().getSituacaoTributaria());
                    bean.setValorIpi(BigDecimal.ZERO);
                }
            } else {
                bean.setValorIpi(BigDecimal.ZERO);
            }
            this.lista.add(bean);
        }
    }

    private MateriaPrima existeMateriaPrima(String codigo, String referencia) {
        MateriaPrima materiaPrima = this.materiaPrimaService.getByCodigo(codigo);
        if (materiaPrima != null) {
            return materiaPrima;
        }
        materiaPrima = this.materiaPrimaService.getByCodigo(referencia);
        if (materiaPrima != null) {
            return materiaPrima;
        }
        return null;
    }

    private void loadValoresTotais(NFNotaInfoTotal total) {
        this.tfBaseCalculoICMS.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getBaseCalculoICMS()), (int)2));
        this.tfValorICMS.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalICMS()), (int)2));
        this.tfBaseCalculoICMSST.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getBaseCalculoICMSST()), (int)2));
        this.tfValorICMSST.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalICMSST()), (int)2));
        this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalDosProdutosServicos()), (int)2));
        this.tfValorFrete.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalFrete()), (int)2));
        this.tfValorSeguro.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalSeguro()), (int)2));
        this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalDesconto()), (int)2));
        this.tfValorOutrasDespesas.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getOutrasDespesasAcessorias()), (int)2));
        this.tfValorIpi.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalIPI()), (int)2));
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)new BigDecimal(total.getIcmsTotal().getValorTotalNFe()), (int)2));
    }

    private void finalizaEntrada() {
        if (this.lista == null || this.lista.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum materiaPrima adicionado na lista.");
            return;
        }
        for (EntradaMateriaPrimaItemBean bean2 : this.lista) {
            if (bean2.getExiste().booleanValue()) continue;
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Item '" + bean2.getNumeroItem() + "': materiaPrima n\u00e3o cadastrado."));
            break;
        }
        ArrayList entradaMateriaPrimaItems = new ArrayList();
        this.lista.forEach(bean -> entradaMateriaPrimaItems.add(this.createEntradaMateriaPrimaItem(bean.getMateriaPrima(), bean.getPrecoUnitario(), bean.getQuantidade(), bean)));
        try {
            this.entradaMateriaPrimaService.salva(this.createEntradaMateriaPrima(), entradaMateriaPrimaItems);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Entrada de materiaPrima cadastrada com sucesso.");
            Stage form = (Stage)this.btnFinaliza.getScene().getWindow();
            form.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EntradaMateriaPrimaImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel salvar a entrada de materiaPrimas.\nCausa: " + ex.getMessage()));
        }
    }

    private void cancelaEntrada() {
    }

    private void loadTabela() {
        this.loadItens();
        this.entradaMateriaPrimaItemList.clear();
        this.entradaMateriaPrimaItemList.addAll((Collection)this.lista);
        this.tabela.setItems(this.entradaMateriaPrimaItemList);
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numeroItem"));
        this.colReferencia.setCellValueFactory((Callback)new PropertyValueFactory("referencia"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalItem.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.setRowFactory(row -> new /* Unavailable Anonymous Inner Class!! */);
    }

    private void registraAcoes() {
        this.btnFinaliza.setOnAction(event -> this.finalizaEntrada());
        this.btnCancela.setOnAction(event -> this.cancelaEntrada());
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                // empty if block
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
    }

    private void cadastraMateriaPrima() {
        EntradaMateriaPrimaItemBean bean = (EntradaMateriaPrimaItemBean)this.tabela.getSelectionModel().getSelectedItem();
        if (bean.getExiste().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: MateriaPrima j\u00e1 cadastrado.");
            return;
        }
        MateriaPrima materiaPrima = new MateriaPrima();
        materiaPrima.setNome(bean.getDescricao());
        materiaPrima.setCodigo(bean.getCodigo());
        Unidade unidade = null;
        try {
            unidade = this.unidadeService.getBySigla(bean.getUnidade());
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(EntradaMateriaPrimaImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
            return;
        }
        if (unidade == null) {
            unidade = new Unidade();
            unidade.setNome(bean.getUnidade());
            unidade.setSigla(bean.getUnidade());
            try {
                unidade = this.unidadeService.save(unidade);
            }
            catch (MaximaException ex) {
                Logger.getLogger(EntradaMateriaPrimaImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel cadastrar o tipo de unidade.");
                return;
            }
        }
        materiaPrima.setUnidade(unidade);
        materiaPrima.setEstoqueInicial(BigDecimal.ZERO);
        materiaPrima.setEstoqueAtual(BigDecimal.ZERO);
        materiaPrima.setUltimoCusto(bean.getPrecoUnitario());
        ConfiguracaoFiscalEntradaSaida configuracaoFiscalEntradaSaida = this.configuracaoFiscalEntradaSaidaService.getByCfopEntrada(bean.getCfopEntrada());
        if (configuracaoFiscalEntradaSaida == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhuma configura\u00e7\u00e3o cadastrada para este CFOP de entrada.");
            return;
        }
        try {
            Stage materiaPrimaForm = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/materiaPrima/MateriaPrimaForm.fxml", "Cadastro de MateriaPrima");
            MateriaPrimaFormController controller = (MateriaPrimaFormController)materiaPrimaForm.getUserData();
            controller.inicializa(materiaPrima);
            materiaPrimaForm.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(EntradaMateriaPrimaImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de cadastro de materiaPrima ( MateriaPrimaForm.fxml ).");
        }
        this.loadTabela();
    }

    private void vinculaMateriaPrima() {
        EntradaMateriaPrimaItemBean bean = (EntradaMateriaPrimaItemBean)this.tabela.getSelectionModel().getSelectedItem();
        if (bean == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum item da tabela selecionado.");
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/materiaPrima/MateriaPrimaPesquisa.fxml", "Pesquisa de mat\u00e9ria prima");
            MateriaPrimaPesquisaController controller = (MateriaPrimaPesquisaController)form.getUserData();
            form.showAndWait();
            MateriaPrima materiaPrima = controller.getMateriaPrimaSelecionado();
            if (materiaPrima != null) {
                this.vinculados.put(bean.getNumeroItem(), materiaPrima);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(EntradaMateriaPrimaImportaXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo de pesquisa de mat\u00e9ria prima.");
        }
        this.loadTabela();
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuCadastraMateriaPrima = new MenuItem("Cadastrar");
        menuCadastraMateriaPrima.setOnAction(event -> this.cadastraMateriaPrima());
        MenuItem menuVinculaMateriaPrima = new MenuItem("Vincular");
        menuVinculaMateriaPrima.setOnAction(event -> this.vinculaMateriaPrima());
        cm.getItems().add((Object)menuCadastraMateriaPrima);
        cm.getItems().add((Object)menuVinculaMateriaPrima);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnFinaliza.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnCancela.setGraphic((Node)maximaIcone.cancel_24());
    }

    private void carregaCombos() {
    }

    private void carregaMascaras() {
    }

    private EntradaMateriaPrimaItem createEntradaMateriaPrimaItem(MateriaPrima materiaPrima, BigDecimal precoCusto, BigDecimal quantidade, EntradaMateriaPrimaItemBean bean) {
        EntradaMateriaPrimaItem item = new EntradaMateriaPrimaItem();
        item.setAtivo(Boolean.TRUE);
        item.setDescricao(materiaPrima.getNome().toUpperCase());
        item.setMateriaPrima(materiaPrima);
        item.setPrecoCusto(precoCusto);
        item.setQuantidade(quantidade);
        item.setTotalCusto(item.getPrecoCusto().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
        item.setUnidade(materiaPrima.getUnidade().getSigla());
        item.setCodigoBarras(materiaPrima.getCodigo());
        item.setCfopEntrada(bean.getCfopEntrada());
        item.setCfopFiscal(bean.getCfopFiscal());
        item.setNcm(bean.getNcm());
        item.setOrigem(bean.getOrigem());
        item.setCst(bean.getCst());
        item.setCsosn(bean.getCsosn());
        item.setPis(bean.getPis());
        item.setCofins(bean.getCofins());
        item.setIpi(bean.getIpi());
        item.setAliquotaCreditoIcms(bean.getAliquotaCreditoIcms());
        item.setValorCreditoIcms(bean.getValorCreditoIcms());
        item.setBaseCalculoIcms(bean.getBaseCalculoIcms());
        item.setAliquotaIcms(bean.getAliquotaIcms());
        item.setValorIcms(bean.getValorIcms());
        item.setBaseCalculoPis(bean.getBaseCalculoPis());
        item.setAliquotaPis(bean.getAliquotaPis());
        item.setValorPis(bean.getValorPis());
        item.setBaseCalculoCofins(bean.getBaseCalculoCofins());
        item.setAliquotaCofins(bean.getAliquotaCofins());
        item.setValorCofins(bean.getValorCofins());
        item.setBaseCalculoIpi(bean.getBaseCalculoIpi());
        item.setAliquotaIpi(bean.getAliquotaIpi());
        item.setValorIpi(bean.getValorIpi());
        return item;
    }

    private EntradaMateriaPrima createEntradaMateriaPrima() {
        if (this.entradaMateriaPrima == null) {
            this.entradaMateriaPrima = new EntradaMateriaPrima();
        }
        this.entradaMateriaPrima.setDataEmissao((LocalDate)this.tfDataEmissao.getValue());
        this.entradaMateriaPrima.setDataEntrada((LocalDate)this.tfDataEntrada.getValue());
        this.entradaMateriaPrima.setDataOperacao(LocalDateTime.now());
        this.entradaMateriaPrima.setBaseCalculoIcms(MaximaNumber.moneyToBigDecimal((String)this.tfBaseCalculoICMS.getText()));
        this.entradaMateriaPrima.setValorIcms(MaximaNumber.moneyToBigDecimal((String)this.tfValorICMS.getText()));
        this.entradaMateriaPrima.setBaseCalculoIcmsSt(MaximaNumber.moneyToBigDecimal((String)this.tfBaseCalculoICMSST.getText()));
        this.entradaMateriaPrima.setValorIcmsSt(MaximaNumber.moneyToBigDecimal((String)this.tfValorICMSST.getText()));
        this.entradaMateriaPrima.setValorProdutos(BigDecimal.ZERO);
        this.entradaMateriaPrima.setFrete(MaximaNumber.moneyToBigDecimal((String)this.tfValorFrete.getText()));
        this.entradaMateriaPrima.setSeguro(MaximaNumber.moneyToBigDecimal((String)this.tfValorSeguro.getText()));
        this.entradaMateriaPrima.setDesconto(MaximaNumber.moneyToBigDecimal((String)this.tfValorDesconto.getText()));
        this.entradaMateriaPrima.setDespesa(MaximaNumber.moneyToBigDecimal((String)this.tfValorOutrasDespesas.getText()));
        this.entradaMateriaPrima.setIpi(MaximaNumber.moneyToBigDecimal((String)this.tfValorIpi.getText()));
        this.entradaMateriaPrima.setPis(new BigDecimal(this.nota.getTotal().getIcmsTotal().getValorPIS()));
        this.entradaMateriaPrima.setCofins(new BigDecimal(this.nota.getTotal().getIcmsTotal().getValorCOFINS()));
        this.entradaMateriaPrima.setTotal(MaximaNumber.moneyToBigDecimal((String)this.tfValorTotal.getText()));
        this.entradaMateriaPrima.setExcluida(Boolean.FALSE);
        this.entradaMateriaPrima.setFornecedor(this.fornecedor);
        this.entradaMateriaPrima.setHistorico("");
        this.entradaMateriaPrima.setHistoricoDespesa("");
        this.entradaMateriaPrima.setSerie(this.nota.getIdentificacao().getSerie());
        this.entradaMateriaPrima.setNumeroNota(MaximaUtils.getText((String)this.tfNumeroNota.getText()));
        this.entradaMateriaPrima.setNfeChaveAcesso(MaximaUtils.removeCaracteres((String)this.tfChaveAcessoNfe.getText()));
        this.entradaMateriaPrima.setModalidadeFrete(this.nota.getTransporte().getModalidadeFrete());
        this.entradaMateriaPrima.setCondicaoPagamento(((NFNotaInfoFormaPagamento)this.nota.getPagamento().getDetalhamentoFormasPagamento().get(0)).getIndicadorFormaPagamento());
        this.entradaMateriaPrima.setXml(this.xml);
        return this.entradaMateriaPrima;
    }
}

