/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.EntradaProduto;
import br.com.maximasolutions.estoque.modelo.EntradaProdutoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.geral.controller.FornecedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntradaProdutoFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private EntradaProdutoService entradaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private Configuracao conf;
    private Fornecedor fornecedor;
    private Produto produto;
    private ObservableList<EntradaProdutoItem> entradaProdutoItemList;
    private EntradaProduto entradaProduto;
    private List<EntradaProdutoItem> itens;
    @FXML
    private VBox vBox;
    @FXML
    private Pane painelTotal;
    @FXML
    private DatePicker tfDataEmissao;
    @FXML
    private DatePicker tfDataEntrada;
    @FXML
    private TextField tfNumeroNota;
    @FXML
    private TextField tfChaveAcessoNfe;
    @FXML
    private TextField tfFornecedorPesquisa;
    @FXML
    private TextField tfFornecedorNome;
    @FXML
    private TextField tfFornecedorTelefone;
    @FXML
    private TextField tfFornecedorEndereco;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoNome;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfPrecoUnitario;
    @FXML
    private TextField tfPrecoVenda;
    @FXML
    private TextField tfTotalItem;
    @FXML
    private TextField tfMargemCusto;
    @FXML
    private TextField tfMargemVenda;
    @FXML
    private TextField tfValorProdutos;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorFrete;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TableView<EntradaProdutoItem> tabela;
    @FXML
    private TableColumn<EntradaProdutoItem, String> colProduto;
    @FXML
    private TableColumn<EntradaProdutoItem, String> colCodigo;
    @FXML
    private TableColumn<EntradaProdutoItem, String> colReferencia;
    @FXML
    private TableColumn<EntradaProdutoItem, String> colItem;
    @FXML
    private TableColumn<EntradaProdutoItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<EntradaProdutoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<EntradaProdutoItem, BigDecimal> colTotalItem;
    @FXML
    private Button btnFornecedorPesquisa;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private Button btnProdutoAdd;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnFinaliza;

    public void initialize(URL location, ResourceBundle resources) {
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
    }

    public void inicializa() {
        this.conf = this.configuracaoService.load();
        this.tfDataEmissao.setValue((Object)LocalDate.now());
        if (!this.conf.getEntradaAlteraValores().booleanValue()) {
            this.tfDataEmissao.setDisable(true);
            this.tfMargemCusto.setDisable(true);
            this.tfMargemVenda.setDisable(true);
            this.tfPrecoUnitario.setDisable(true);
            this.tfPrecoVenda.setDisable(true);
        }
    }

    public void inicializaEntrada(EntradaProduto entradaProduto1) {
        if (entradaProduto1 == null) {
            this.fornecedor = null;
            this.entradaProduto = null;
            this.itens = new ArrayList();
        } else {
            this.entradaProduto = entradaProduto1;
            this.fornecedor = this.entradaProduto.getFornecedor();
            this.itens = this.entradaProdutoService.listItens(this.entradaProduto);
            this.tfDataEmissao.setValue((Object)this.entradaProduto.getDataEmissao());
            this.tfDataEntrada.setValue((Object)this.entradaProduto.getDataEntrada());
            this.tfNumeroNota.setText(this.entradaProduto.getNumeroNota());
            this.tfChaveAcessoNfe.setText(this.entradaProduto.getNfeChaveAcesso());
        }
        this.inicializaItem();
        this.loadDadosFornecedor();
        Stage stage = (Stage)this.vBox.getScene().getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        this.tfDataEmissao.requestFocus();
    }

    private void inicializaItem() {
        this.produto = null;
        this.loadDadosProduto();
        this.loadValoresTotais();
        this.loadItens();
    }

    private void loadItens() {
        this.entradaProdutoItemList = FXCollections.observableArrayList();
        this.entradaProdutoItemList.clear();
        BigDecimal valorProdutos = BigDecimal.ZERO;
        for (EntradaProdutoItem item : this.itens) {
            if (item.getExcluido().booleanValue()) continue;
            valorProdutos = valorProdutos.add(item.getTotalCusto());
            this.entradaProdutoItemList.add((Object)item);
        }
        this.tabela.setItems(this.entradaProdutoItemList);
        this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorProdutos, (int)2));
        BigDecimal valorFrete = MaximaNumber.moneyToBigDecimal((String)this.tfValorFrete.getText());
        if (valorFrete == null) {
            valorFrete = BigDecimal.ZERO;
        }
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorProdutos.add(valorFrete), (int)2));
    }

    private void addItem() {
        if (!this.validaItemForm()) {
            return;
        }
        this.itens.add(this.createEntradaProdutoItem(this.produto, MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText()), MaximaNumber.moneyToBigDecimal((String)this.tfPrecoVenda.getText()), MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText())));
        this.inicializaItem();
    }

    private void editaItem() {
    }

    private void deleteItem() {
        EntradaProdutoItem item = (EntradaProdutoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum produto selecionado.");
            return;
        }
        int cont = 0;
        for (EntradaProdutoItem i : this.itens) {
            if (i.getNumItem().equals(item.getNumItem())) {
                i.setExcluido(Boolean.TRUE);
                break;
            }
            ++cont;
        }
        cont = 0;
        for (EntradaProdutoItem i : this.itens) {
            ++cont;
            if (i.getExcluido().booleanValue()) continue;
            i.setNumItem(Integer.valueOf(cont));
        }
        this.inicializaItem();
    }

    private void finalizaEntrada() {
        if (!this.validaPedidoForm()) {
            return;
        }
        try {
            this.entradaProdutoService.salva(this.createEntradaProduto(), this.itens);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Entrada de produto cadastrada com sucesso.");
            Stage form = (Stage)this.btnFinaliza.getScene().getWindow();
            form.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EntradaProdutoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel salvar a entrada de produtos.\nCausa: " + ex.getMessage()));
        }
    }

    private void cancelaEntrada() {
        this.inicializaEntrada(null);
    }

    private void calculaPrecoVendaMargemCusto() {
        System.out.println("==== calcular preco venda ===");
        BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
        BigDecimal margemCusto = MaximaNumber.moneyToBigDecimal((String)this.tfMargemCusto.getText());
        if (precoUnitario == null) {
            precoUnitario = BigDecimal.ZERO;
        }
        if (margemCusto == null) {
            margemCusto = BigDecimal.ZERO;
        }
        if (precoUnitario.compareTo(BigDecimal.ZERO) == 0 || margemCusto.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal precoVenda = BigDecimal.ZERO;
        if (margemCusto.compareTo(BigDecimal.ZERO) > 0 && precoUnitario.compareTo(BigDecimal.ZERO) > 0) {
            System.out.println("============ margem custo: " + margemCusto);
            precoVenda = precoUnitario.add(precoUnitario.multiply(margemCusto).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN)).setScale(2, RoundingMode.HALF_EVEN);
        }
        System.out.println("================= venda: " + precoVenda);
        this.tfPrecoVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)precoVenda, (int)2));
    }

    private void calculaMargemCusto() {
        BigDecimal precoCusto = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
        BigDecimal precoVenda = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoVenda.getText());
        BigDecimal margemCusto = BigDecimal.ZERO;
        if (precoCusto == null || precoCusto.compareTo(BigDecimal.ZERO) <= 0 || precoVenda == null || precoVenda.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfMargemCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)margemCusto, (int)2));
            return;
        }
        margemCusto = precoVenda.subtract(precoCusto).divide(precoCusto, 4, RoundingMode.HALF_EVEN).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_EVEN);
        this.tfMargemCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)margemCusto, (int)2));
    }

    private void calculaMargemVenda() {
        BigDecimal precoCusto = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
        BigDecimal precoVenda = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoVenda.getText());
        BigDecimal margemVenda = BigDecimal.ZERO;
        if (precoCusto == null || precoCusto.compareTo(BigDecimal.ZERO) <= 0 || precoVenda == null || precoVenda.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfMargemVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)margemVenda, (int)2));
            return;
        }
        margemVenda = precoVenda.subtract(precoCusto).divide(precoVenda, 4, RoundingMode.HALF_EVEN).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_EVEN);
        this.tfMargemVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)margemVenda, (int)2));
    }

    private void loadValoresTotais() {
        if (this.entradaProduto == null) {
            this.tfValorProdutos.setText("");
            this.tfValorFrete.setText("");
            this.tfValorDesconto.setText("");
            this.tfValorTotal.setText("");
        } else {
            this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.entradaProduto.getValorProdutos(), (int)2));
            this.tfValorFrete.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.entradaProduto.getFrete(), (int)2));
            this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.entradaProduto.getDesconto(), (int)2));
            this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.entradaProduto.getTotal(), (int)2));
        }
    }

    private boolean validaItemForm() {
        boolean valido = true;
        if (this.produto == null) {
            this.tfProdutoPesquisa.getStyleClass().add((Object)"error");
            this.tfProdutoNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoPesquisa.getStyleClass().remove((Object)"error");
            this.tfProdutoNome.getStyleClass().remove((Object)"error");
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfQuantidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfQuantidade.getStyleClass().remove((Object)"error");
        }
        BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
        if (precoUnitario == null || precoUnitario.compareTo(BigDecimal.ZERO) < 0) {
            this.tfPrecoUnitario.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfPrecoUnitario.getStyleClass().remove((Object)"error");
        }
        BigDecimal precoVenda = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoVenda.getText());
        if (precoVenda == null || precoVenda.compareTo(BigDecimal.ZERO) < 0) {
            this.tfPrecoVenda.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfPrecoVenda.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaPedidoForm() {
        boolean valido = true;
        if (this.tfDataEmissao.getValue() == null) {
            this.tfDataEmissao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataEmissao.getStyleClass().remove((Object)"error");
        }
        if (this.fornecedor == null) {
            this.tfFornecedorPesquisa.getStyleClass().add((Object)"error");
            this.tfFornecedorNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfFornecedorPesquisa.getStyleClass().remove((Object)"error");
            this.tfFornecedorNome.getStyleClass().remove((Object)"error");
        }
        if (this.entradaProdutoItemList == null || this.entradaProdutoItemList.isEmpty()) {
            this.tabela.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tabela.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void calculaTotalItem() {
        BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (precoUnitario == null || quantidade == null) {
            this.tfTotalItem.setText(null);
            return;
        }
        BigDecimal totalItem = precoUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalItem.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalItem, (int)2));
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colReferencia.setCellValueFactory((Callback)new PropertyValueFactory("referencia"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigoBarras"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoCusto"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("totalCusto"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalItem.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnFinaliza.setOnAction(event -> this.finalizaEntrada());
        this.btnCancela.setOnAction(event -> this.cancelaEntrada());
        this.tfFornecedorPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaFornecedor();
            }
        });
        this.btnFornecedorPesquisa.setOnAction(event -> this.pesquisaFornecedorForm());
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaProduto();
            }
        });
        this.btnProdutoPesquisa.setOnAction(event -> this.pesquisaProdutoForm());
        this.btnProdutoAdd.setOnAction(event -> this.addItem());
        this.vBox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F2) {
                this.pesquisaFornecedorForm();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem();
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.TAB) {
                System.out.println("EVENTO: " + event.getCode() + " - " + KeyCode.TAB);
                BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
                if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
                    this.tfQuantidade.requestFocus();
                    this.tfQuantidade.selectAll();
                    return;
                }
                if (this.conf.getEntradaAlteraValores().booleanValue()) {
                    this.tfPrecoUnitario.requestFocus();
                    this.tfPrecoUnitario.selectAll();
                } else {
                    this.tfObservacao.requestFocus();
                    this.tfObservacao.selectAll();
                }
                this.calculaTotalItem();
            }
        });
        this.tfPrecoUnitario.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                BigDecimal precoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfPrecoUnitario.getText());
                if (precoUnitario == null) {
                    this.tfPrecoUnitario.requestFocus();
                    this.tfPrecoUnitario.selectAll();
                    return;
                }
                this.tfMargemCusto.requestFocus();
                this.tfMargemCusto.selectAll();
                this.calculaTotalItem();
            }
        });
        this.tfMargemCusto.setOnKeyReleased(evt -> this.calculaPrecoVendaMargemCusto());
        this.tfPrecoVenda.setOnKeyReleased(evt -> {
            this.calculaMargemCusto();
            this.calculaMargemVenda();
        });
        this.tfMargemCusto.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfPrecoVenda.requestFocus();
                this.tfPrecoVenda.selectAll();
            }
        });
        this.tfPrecoVenda.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfObservacao.requestFocus();
                this.tfObservacao.selectAll();
            }
        });
        this.tfObservacao.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addItem();
            }
        });
        this.tfQuantidade.textProperty().addListener((observable, oldValue, newValue) -> this.calculaTotalItem());
        this.tfPrecoUnitario.textProperty().addListener((observable, oldValue, newValue) -> {
            this.calculaMargemCusto();
            this.calculaMargemVenda();
        });
        this.tfMargemCusto.textProperty().addListener((observable, oldValue, newValue) -> this.calculaMargemVenda());
        this.tfPrecoVenda.textProperty().addListener((observable, oldValue, newValue) -> this.calculaMargemVenda());
        this.tfPrecoUnitario.setOnKeyReleased(event -> this.calculaTotalItem());
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem());
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnFornecedorPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnProdutoPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnProdutoAdd.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnFinaliza.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnCancela.setGraphic((Node)maximaIcone.cancel_24());
    }

    private void carregaCombos() {
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            controller.setEnableCadastrarProduto();
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoNome.setText(this.produto.getNome().toUpperCase());
            this.tfPrecoUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getUltimoCusto(), (int)2));
            this.tfMargemCusto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getMargemLucroCusto(), (int)2));
            this.tfMargemVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getMargemLucroVenda(), (int)2));
            this.tfPrecoVenda.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
        } else {
            this.tfProdutoNome.setText("");
            this.tfProdutoPesquisa.setText("");
            this.tfObservacao.setText("");
            this.tfQuantidade.setText("");
            this.tfPrecoUnitario.setText("");
            this.tfPrecoVenda.setText("");
            this.tfTotalItem.setText("");
            this.tfProdutoPesquisa.requestFocus();
        }
    }

    private void pesquisaFornecedor() {
        String fornecedorCodigo = this.tfFornecedorPesquisa.getText().trim();
        if (fornecedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long fornecedorCodigoNumero = Long.valueOf(fornecedorCodigo);
            Fornecedor fornecedorPesquisa = this.fornecedorService.getById(fornecedorCodigoNumero);
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
            } else {
                this.fornecedor = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de fornecedor n\u00e3o encontrado.");
                this.tfFornecedorPesquisa.requestFocus();
                this.tfFornecedorPesquisa.selectAll();
            }
            this.loadDadosFornecedor();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaFornecedorForm();
            return;
        }
    }

    private void pesquisaFornecedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/fornecedor/FornecedorPesquisa.fxml", "Pesquisa de fornecedor");
            FornecedorPesquisaController controller = (FornecedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfFornecedorPesquisa.getText().trim());
            stage.showAndWait();
            Fornecedor fornecedorPesquisa = controller.getFornecedorSelecionado();
            if (fornecedorPesquisa != null) {
                this.fornecedor = fornecedorPesquisa;
                this.loadDadosFornecedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'FornecedorPesquisa'");
        }
    }

    private void loadDadosFornecedor() {
        if (this.fornecedor != null) {
            this.tfFornecedorPesquisa.setText(this.fornecedor.getId().toString());
            this.tfFornecedorNome.setText(this.fornecedor.getNome().toUpperCase());
            this.tfFornecedorTelefone.setText(this.fornecedor.getTelefone());
            this.tfFornecedorEndereco.setText(this.fornecedor.getEnderecoCompleto());
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        } else {
            this.tfFornecedorNome.setText("");
            this.tfFornecedorPesquisa.setText("");
            this.tfFornecedorTelefone.setText("");
            this.tfFornecedorEndereco.setText("");
            this.tfFornecedorPesquisa.requestFocus();
        }
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfPrecoUnitario);
        MaximaMask.monetaryField((TextField)this.tfPrecoVenda);
        MaximaMask.monetaryField((TextField)this.tfMargemCusto);
        MaximaMask.monetaryField((TextField)this.tfMargemVenda);
    }

    private void closeWindowEvent(WindowEvent event) {
    }

    private EntradaProdutoItem createEntradaProdutoItem(Produto produto, BigDecimal precoCusto, BigDecimal precoVenda, BigDecimal quantidade) {
        EntradaProdutoItem item = new EntradaProdutoItem();
        item.setAtivo(Boolean.TRUE);
        item.setDataOperacao(LocalDate.now());
        item.setDescricao(produto.getNome().toUpperCase());
        item.setNumItem(Integer.valueOf(this.itens.size() + 1));
        item.setProduto(produto);
        item.setPrecoCusto(precoCusto);
        item.setPrecoVenda(precoVenda);
        item.setQuantidade(quantidade);
        item.setTotalCusto(item.getPrecoCusto().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN));
        item.setUnidade(produto.getUnidade().getSigla());
        item.setCodigoBarras(produto.getCodigo());
        item.setReferencia(produto.getReferencia());
        return item;
    }

    private EntradaProduto createEntradaProduto() {
        if (this.entradaProduto == null) {
            this.entradaProduto = new EntradaProduto();
        }
        this.entradaProduto.setDataEmissao((LocalDate)this.tfDataEmissao.getValue());
        this.entradaProduto.setDataEntrada((LocalDate)this.tfDataEntrada.getValue());
        this.entradaProduto.setDataOperacao(LocalDateTime.now());
        this.entradaProduto.setDesconto(BigDecimal.ZERO);
        this.entradaProduto.setDespesa(BigDecimal.ZERO);
        this.entradaProduto.setExcluida(Boolean.FALSE);
        this.entradaProduto.setFornecedor(this.fornecedor);
        this.entradaProduto.setFrete(BigDecimal.ZERO);
        this.entradaProduto.setHistorico("");
        this.entradaProduto.setHistoricoDespesa("");
        this.entradaProduto.setNumeroNota(MaximaUtils.getText((String)this.tfNumeroNota.getText()));
        this.entradaProduto.setNfeChaveAcesso(MaximaUtils.removeCaracteres((String)this.tfChaveAcessoNfe.getText()));
        this.entradaProduto.setTotal(BigDecimal.ZERO);
        this.entradaProduto.setValorProdutos(BigDecimal.ZERO);
        return this.entradaProduto;
    }
}

