/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.EstoqueBalanco;
import br.com.maximasolutions.estoque.modelo.EstoqueBalancoProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.EstoqueBalancoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EstoqueBalancoFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private EstoqueBalancoService estoqueBalancoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private Configuracao conf;
    private Produto produto;
    private EstoqueBalancoProduto itemEditar;
    private ObservableList<EstoqueBalancoProduto> produtoList;
    private List<EstoqueBalancoProduto> itens;
    private EstoqueBalanco estoqueBalanco;
    @FXML
    private VBox vBox;
    @FXML
    private Pane painelTotal;
    @FXML
    private DatePicker tfDataEmissao;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoNome;
    @FXML
    private TextField tfPrecoUnitario;
    @FXML
    private TextField tfEstoqueAnterior;
    @FXML
    private TextField tfEstoqueAtual;
    @FXML
    private CheckBox ccbZerarEstoque;
    @FXML
    private TableView<EstoqueBalancoProduto> tabela;
    @FXML
    private TableColumn<EstoqueBalancoProduto, String> colProduto;
    @FXML
    private TableColumn<EstoqueBalancoProduto, String> colCodigo;
    @FXML
    private TableColumn<EstoqueBalancoProduto, String> colReferencia;
    @FXML
    private TableColumn<EstoqueBalancoProduto, String> colItem;
    @FXML
    private TableColumn<EstoqueBalancoProduto, BigDecimal> colEstoqueAnterior;
    @FXML
    private TableColumn<EstoqueBalancoProduto, BigDecimal> colEstoqueAtual;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private Button btnProdutoAdd;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnFinaliza;

    public void initialize(URL location, ResourceBundle resources) {
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
    }

    public void inicializaBalanco() {
        this.tfDataEmissao.setValue((Object)LocalDate.now());
        this.itens = new ArrayList();
        this.estoqueBalanco = null;
        this.inicializaItem(null);
        Stage stage = (Stage)this.vBox.getScene().getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        this.tfDataEmissao.requestFocus();
    }

    private void inicializaItem(Integer index) {
        this.produto = null;
        this.itemEditar = null;
        this.loadDadosProduto();
        this.loadItens(index);
    }

    private void loadItens(Integer index) {
        this.produtoList = FXCollections.observableArrayList((Collection)this.itens);
        this.tabela.getItems().clear();
        this.tabela.setItems(this.produtoList);
        if (index != null) {
            this.tabela.getSelectionModel().select(index.intValue());
        }
    }

    private void addItem() {
        if (!this.validaItemForm()) {
            return;
        }
        if (this.itemEditar != null) {
            int index = 0;
            for (EstoqueBalancoProduto ebp : this.itens) {
                if (ebp.getUuid().equals(this.itemEditar.getUuid())) {
                    ebp.setQuantidade(MaximaNumber.quantidadeToBigDecimal((String)this.tfEstoqueAtual.getText()));
                    ebp.setEstoqueAtual(MaximaNumber.quantidadeToBigDecimal((String)this.tfEstoqueAtual.getText()));
                    break;
                }
                ++index;
            }
            this.inicializaItem(Integer.valueOf(index));
            return;
        }
        EstoqueBalancoProduto item = this.novoBalancoItem(this.produto, MaximaNumber.quantidadeToBigDecimal((String)this.tfEstoqueAtual.getText()));
        boolean retornar = false;
        int index = 0;
        boolean adicionar = false;
        for (EstoqueBalancoProduto prod : this.itens) {
            if (prod.getProduto().getId().equals(this.produto.getId())) {
                if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Produto j\u00e1 conta no balan\u00e7o. Deseja adicionar?")) {
                    adicionar = true;
                    break;
                }
                retornar = true;
                break;
            }
            ++index;
        }
        if (adicionar) {
            System.out.println("--- item ja cadastrado: adicionar quantidade ---");
            BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfEstoqueAtual.getText());
            ((EstoqueBalancoProduto)this.itens.get(index)).setQuantidade(((EstoqueBalancoProduto)this.itens.get(index)).getQuantidade().add(quantidade));
            ((EstoqueBalancoProduto)this.itens.get(index)).setEstoqueAtual(((EstoqueBalancoProduto)this.itens.get(index)).getEstoqueAtual().add(quantidade));
            this.inicializaItem(Integer.valueOf(index));
            return;
        }
        if (retornar) {
            this.inicializaItem(null);
            return;
        }
        this.itens.add(item);
        this.inicializaItem(null);
    }

    private void editaItem() {
        this.itemEditar = (EstoqueBalancoProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (this.itemEditar == null) {
            return;
        }
        this.produto = this.itemEditar.getProduto();
        this.loadDadosProduto();
    }

    private void deleteItem() {
        EstoqueBalancoProduto selecionado = (EstoqueBalancoProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (selecionado == null) {
            return;
        }
        int count = 0;
        for (EstoqueBalancoProduto ebp : this.itens) {
            if (ebp.getUuid().equals(selecionado.getUuid())) {
                this.itens.remove(count);
                break;
            }
            ++count;
        }
        this.inicializaItem(null);
    }

    private void finalizaBalanco() {
        if (!this.validaPedidoForm()) {
            return;
        }
        this.estoqueBalanco = this.novoBalanco();
        if (this.estoqueBalanco.getZerarEstoqueOutrosProdutos().booleanValue()) {
            List produtos = this.produtoService.pesquisa("");
            for (Produto prod : produtos) {
                boolean existe = false;
                for (EstoqueBalancoProduto ebp : this.itens) {
                    if (!prod.getId().equals(ebp.getProduto().getId())) continue;
                    existe = true;
                    break;
                }
                if (existe) continue;
                this.itens.add(this.novoBalancoItem(prod, BigDecimal.ZERO));
            }
        }
        try {
            this.estoqueBalancoService.salva(this.estoqueBalanco, this.itens);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Balan\u00e7o cadastrado com sucesso.");
            this.fechaForm();
        }
        catch (MaximaException ex) {
            Logger.getLogger(EstoqueBalancoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void cancelaEntrada() {
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cancelar o balan\u00e7o em andamento?")) {
            this.inicializaBalanco();
        }
    }

    private boolean validaItemForm() {
        boolean valido = true;
        if (this.produto == null) {
            this.tfProdutoPesquisa.getStyleClass().add((Object)"error");
            this.tfProdutoNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoPesquisa.getStyleClass().remove((Object)"error");
            this.tfProdutoNome.getStyleClass().remove((Object)"error");
        }
        BigDecimal estoqueAtual = MaximaNumber.quantidadeToBigDecimal((String)this.tfEstoqueAtual.getText());
        if (estoqueAtual == null || estoqueAtual.compareTo(BigDecimal.ZERO) < 0) {
            this.tfEstoqueAtual.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfEstoqueAtual.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private boolean validaPedidoForm() {
        boolean valido = true;
        if (this.tfDataEmissao.getValue() == null) {
            this.tfDataEmissao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataEmissao.getStyleClass().remove((Object)"error");
        }
        if (this.itens == null || this.itens.isEmpty()) {
            this.tabela.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tabela.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colReferencia.setCellValueFactory((Callback)new PropertyValueFactory("referencia"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
        this.colEstoqueAnterior.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAnterior"));
        this.colEstoqueAtual.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAtual"));
        this.colEstoqueAtual.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colEstoqueAnterior.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnFinaliza.setOnAction(event -> this.finalizaBalanco());
        this.btnCancela.setOnAction(event -> this.cancelaEntrada());
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaProduto();
            }
        });
        this.btnProdutoPesquisa.setOnAction(event -> this.pesquisaProdutoForm());
        this.btnProdutoAdd.setOnAction(event -> this.addItem());
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem();
            }
        });
        this.tabela.setContextMenu(this.getTableMenu());
        this.tfEstoqueAtual.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.addItem();
            }
        });
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem());
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnProdutoPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnProdutoAdd.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnFinaliza.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnCancela.setGraphic((Node)maximaIcone.cancel_24());
    }

    private void carregaCombos() {
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoNome.setText(this.produto.getNome().toUpperCase());
            this.tfPrecoUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getUltimoCusto(), (int)2));
            this.tfEstoqueAnterior.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getEstoqueAtual(), (int)4));
            this.tfEstoqueAtual.requestFocus();
            this.tfEstoqueAtual.selectAll();
        } else {
            this.tfProdutoNome.setText("");
            this.tfProdutoPesquisa.setText("");
            this.tfPrecoUnitario.setText("");
            this.tfEstoqueAnterior.setText("");
            this.tfEstoqueAtual.setText("");
            this.tfProdutoPesquisa.requestFocus();
        }
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfPrecoUnitario);
    }

    private void closeWindowEvent(WindowEvent event) {
    }

    private EstoqueBalanco novoBalanco() {
        EstoqueBalanco balanco = new EstoqueBalanco();
        balanco.setDataOperacao((LocalDate)this.tfDataEmissao.getValue());
        balanco.setExcluido(Boolean.FALSE);
        balanco.setHistorico(MaximaUtils.getText((String)this.tfHistorico.getText()));
        balanco.setHoraOperacao(LocalDateTime.now());
        balanco.setUsuario(this.stageManager.getUsuario());
        balanco.setZerarEstoqueOutrosProdutos(Boolean.valueOf(this.ccbZerarEstoque.isSelected()));
        return balanco;
    }

    private EstoqueBalancoProduto novoBalancoItem(Produto produto, BigDecimal estoqueAtual) {
        if (this.itens == null) {
            this.itens = new ArrayList();
        }
        EstoqueBalancoProduto item = new EstoqueBalancoProduto();
        item.setCodigo(produto.getCodigo());
        item.setDataOperacao(LocalDateTime.now());
        item.setDescricao(produto.getNome().toUpperCase());
        item.setEstoqueAnterior(produto.getEstoqueAtual());
        item.setEstoqueAtual(estoqueAtual);
        item.setExcluido(Boolean.FALSE);
        item.setNumItem(Integer.valueOf(this.itens.size() + 1));
        item.setProduto(produto);
        item.setQuantidade(item.getEstoqueAtual());
        item.setReferencia(produto.getReferencia());
        item.setUuid(UUID.randomUUID().toString());
        return item;
    }

    private void fechaForm() {
        Stage form = (Stage)this.vBox.getScene().getWindow();
        form.close();
    }
}

