/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.stereotype.Controller;

@Controller
public class EstoqueController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnLogin;
    @FXML
    private Button btnFechar;
    @FXML
    private TextField tfEstoque;
    @FXML
    private Label mensagemLabel;
    private BigDecimal estoque;
    private Boolean confirma;

    public void inicializa() {
        this.confirma = false;
        this.estoque = null;
        this.tfEstoque.requestFocus();
    }

    public BigDecimal getEstoque() {
        return this.estoque;
    }

    public Boolean getConfirma() {
        return this.confirma;
    }

    private void confirma() {
        this.estoque = MaximaNumber.quantidadeToBigDecimal((String)this.tfEstoque.getText());
        if (this.estoque == null) {
            this.mensagemLabel.setText("Informe uma quantidade v\u00e1lida.");
            this.tfEstoque.requestFocus();
            this.tfEstoque.selectAll();
            return;
        }
        this.confirma = true;
        this.fecha();
    }

    private void fecha() {
        Stage form = (Stage)this.btnLogin.getScene().getWindow();
        form.close();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.registraAcoes();
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void registraAcoes() {
        this.btnLogin.setOnAction(t -> this.confirma());
        this.btnFechar.setOnAction(evt -> this.fecha());
        this.tfEstoque.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
    }
}

