/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.MateriaPrimaFormController;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.service.MateriaPrimaService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MateriaPrimaController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDuplica;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<MateriaPrima> tabela;
    @FXML
    private TableColumn<MateriaPrima, String> colNome;
    @FXML
    private TableColumn<MateriaPrima, String> colCodigo;
    @FXML
    private TableColumn<MateriaPrima, String> colUnidade;
    @FXML
    private TableColumn<MateriaPrima, BigDecimal> colEstoque;
    @FXML
    private TableColumn<MateriaPrima, BigDecimal> colPrecoVenda;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MateriaPrimaService materiaPrimaService;
    private ObservableList<MateriaPrima> materiaPrimaList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.materiaPrimaList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.carregaCombos();
    }

    private void delete() {
        MateriaPrima materiaPrima = (MateriaPrima)this.tabela.getSelectionModel().getSelectedItem();
        if (materiaPrima != null && MaximaAlert.confirmacao((String)("Deseja remover a mat\u00e9ria prima: '" + materiaPrima.getNome() + "'?"))) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)"M\u00e9todo n\u00e3o implementado.");
        }
        this.loadTabela();
    }

    private void novo() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/materiaPrima/MateriaPrimaForm.fxml", "Novo MateriaPrima");
            MateriaPrimaFormController controller = (MateriaPrimaFormController)stage.getUserData();
            controller.inicializa(null);
            stage.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(MateriaPrimaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de cadastro de materiaPrima.");
        }
    }

    private void editaMateriaPrima() {
        MateriaPrima materiaPrima = (MateriaPrima)this.tabela.getSelectionModel().getSelectedItem();
        if (materiaPrima != null) {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/materiaPrima/MateriaPrimaForm.fxml", "Edita MateriaPrima");
                MateriaPrimaFormController controller = (MateriaPrimaFormController)stage.getUserData();
                controller.inicializa(materiaPrima);
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(MateriaPrimaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void duplicaMateriaPrima() {
        MateriaPrima materiaPrima = (MateriaPrima)this.tabela.getSelectionModel().getSelectedItem();
        if (materiaPrima != null) {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/materiaPrima/MateriaPrimaForm.fxml", "Novo MateriaPrima");
                MateriaPrimaFormController controller = (MateriaPrimaFormController)stage.getUserData();
                materiaPrima.setId(null);
                materiaPrima.setCodigo(null);
                materiaPrima.setEstoqueInicial(null);
                materiaPrima.setEstoqueAtual(null);
                materiaPrima.setEstoqueMinimo(null);
                materiaPrima.setUltimoCusto(null);
                controller.inicializa(materiaPrima);
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(MateriaPrimaController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form de cadastro de materiaPrima.\n" + ex.getMessage()));
            }
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um materiaPrima para duplicar.");
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colUnidade.setCellValueFactory((Callback)new PropertyValueFactory("unidade"));
        this.colEstoque.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAtual"));
        this.colPrecoVenda.setCellValueFactory((Callback)new PropertyValueFactory("ultimoCusto"));
        this.colEstoque.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colPrecoVenda.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.materiaPrimaList.clear();
        List list = this.materiaPrimaService.pesquisa(valorPesquisa);
        this.materiaPrimaList.addAll((Collection)list);
        this.tabela.setItems(this.materiaPrimaList);
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDuplica.setGraphic((Node)new MaximaIcone().duplca());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novo());
        this.btnEdita.setOnAction(event -> this.editaMateriaPrima());
        this.btnDuplica.setOnAction(t -> this.duplicaMateriaPrima());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(t -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaMateriaPrima();
            }
        });
    }
}

