/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.service.MateriaPrimaService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MateriaPrimaPesquisaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnSelecionar;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<MateriaPrima> tabela;
    @FXML
    private TableColumn<MateriaPrima, String> colCodigo;
    @FXML
    private TableColumn<MateriaPrima, String> colDescricao;
    @FXML
    private TableColumn<MateriaPrima, String> colUnidade;
    @FXML
    private TableColumn<MateriaPrima, BigDecimal> colEstoque;
    @FXML
    private TableColumn<MateriaPrima, BigDecimal> colPrecoUnitario;
    @Autowired
    private MateriaPrimaService materiaPrimaService;
    private ObservableList<MateriaPrima> materiaPrimaList;
    private MateriaPrima materiaPrimaSelecionado;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.materiaPrimaList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
    }

    public MateriaPrima getMateriaPrimaSelecionado() {
        return this.materiaPrimaSelecionado;
    }

    public void setValorPesquisa(String valor) {
        this.tfPesquisa.setText(valor);
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
        if (valor != null && !valor.isEmpty()) {
            this.loadTabela();
        }
    }

    private void seleciona() {
        this.materiaPrimaSelecionado = (MateriaPrima)this.tabela.getSelectionModel().getSelectedItem();
        if (this.materiaPrimaSelecionado == null) {
            MaximaAlert.alerta((String)"Selecione uma mat\u00e9ria prima para continuar.");
            return;
        }
        this.fechaForm();
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.materiaPrimaList.clear();
        List list = new ArrayList();
        if (!valorPesquisa.isEmpty()) {
            list = this.materiaPrimaService.pesquisa(valorPesquisa);
        }
        this.materiaPrimaList.addAll(list);
        this.tabela.setItems(this.materiaPrimaList);
    }

    private void carregaIcones() {
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
        this.btnSelecionar.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colDescricao.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colUnidade.setCellValueFactory((Callback)new PropertyValueFactory("unidade"));
        this.colEstoque.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAtual"));
        this.colPrecoUnitario.setCellValueFactory((Callback)new PropertyValueFactory("ultimoCusto"));
        this.colEstoque.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colPrecoUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void registraAcoes() {
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
            if (event.getCode() == KeyCode.DOWN) {
                this.tabela.requestFocus();
            }
        });
        this.btnSelecionar.setOnAction(event -> this.seleciona());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.seleciona();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER && this.tabela.getSelectionModel().getSelectedItem() != null) {
                this.seleciona();
            }
        });
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnPesquisa.getScene().getWindow();
        stage.close();
    }
}

