/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.HtmlEditorController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.OrcamentoViewController;
import br.com.maximasolutions.estoque.controller.VendaProdutoController;
import br.com.maximasolutions.estoque.modelo.Orcamento;
import br.com.maximasolutions.estoque.service.OrcamentoService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class OrcamentosController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnVisualiza;
    @FXML
    private Button btnImprime;
    @FXML
    private Button btnDeleteOrcamento;
    @FXML
    private Button btnEmail;
    @FXML
    private TableView<Orcamento> tabela;
    @FXML
    private TableColumn<Orcamento, String> colCliente;
    @FXML
    private TableColumn<Orcamento, String> colCodigo;
    @FXML
    private TableColumn<Orcamento, String> colObservacao;
    @FXML
    private TableColumn<Orcamento, String> colData;
    @FXML
    private TableColumn<Orcamento, BigDecimal> colTotal;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label labelTotal;
    @FXML
    private Label labelQuantidade;
    @FXML
    private CheckBox ccbFaturado;
    @FXML
    private CheckBox ccbExcluida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private OrcamentoService orcamentoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<Orcamento> orcamentoList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)LocalDate.now());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.orcamentoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Orcamento);
    }

    private void deleteOrcamento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Orcamento orcamento = (Orcamento)this.tabela.getSelectionModel().getSelectedItem();
        if (orcamento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma orcamento para excluir.");
            return;
        }
        if (!(orcamento = this.orcamentoService.getById(orcamento.getId().longValue())).isAtivo().booleanValue() || orcamento.isExcluida().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Orcamento exclu\u00edda do sistema.\nN\u00e3o \u00e9 poss\u00edvel excluir o faturamento.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Essa opera\u00e7\u00e3o ir\u00e1 excluir todas informa\u00e7\u00f5es da orcamento.\nTem certeza que deseja continuar?")) {
            return;
        }
        try {
            this.orcamentoService.delete(orcamento);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Orcamento exclu\u00edda com sucesso.");
            this.loadTabela();
        }
        catch (MaximaException ex) {
            Logger.getLogger(OrcamentosController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    private void visualiza() {
        Orcamento orcamento = (Orcamento)this.tabela.getSelectionModel().getSelectedItem();
        if (orcamento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma orcamento selecionada para impress\u00e3o.");
            return;
        }
        try {
            Stage orcamentoView = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.tabela.getScene().getWindow(), "/fxml/estoque/orcamento/OrcamentoView.fxml", "");
            OrcamentoViewController controller = (OrcamentoViewController)orcamentoView.getUserData();
            controller.inicializa(orcamento);
            orcamentoView.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel visualziar a venda.");
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("observacao"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    private void loadTabela() {
        this.orcamentoList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "";
        List list = this.orcamentoService.lista(inicio, fim, filtro);
        this.orcamentoList.addAll((Collection)list);
        this.tabela.setItems(this.orcamentoList);
        BigDecimal total = BigDecimal.ZERO;
        for (Orcamento orc : this.orcamentoList) {
            total = total.add(orc.getTotal());
        }
        this.labelTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
        this.labelQuantidade.setText(MaximaUtils.completaZeroEsquerda((String)String.valueOf(this.orcamentoList.size()), (Integer)3));
    }

    private void carregaIcones() {
        this.btnVisualiza.setGraphic((Node)new MaximaIcone().iconeVisualizar());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void email() {
        Orcamento orcamento = (Orcamento)this.tabela.getSelectionModel().getSelectedItem();
        if (orcamento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Selecione uma orcamento para enviar por e-mail.");
            return;
        }
        if (orcamento.isExcluida().booleanValue() || !orcamento.isAtivo().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o \u00e9 permitido o envio de orcamento exclu\u00edda.");
            return;
        }
        String emailCliente = orcamento.getCliente().getEmail();
        if (emailCliente == null || emailCliente.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: E-mail n\u00e3o cadastrado para o cliente.");
            return;
        }
        String textoHtml = "";
        try {
            Stage htmlEditor = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/HtmlEditor.fxml", "Conte\u00fado E-mail");
            HtmlEditorController htmlEditorController = (HtmlEditorController)htmlEditor.getUserData();
            htmlEditorController.inicializa();
            htmlEditor.showAndWait();
            textoHtml = htmlEditorController.getTextoHtml();
        }
        catch (IOException ex) {
            Logger.getLogger(OrcamentosController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void registraAcoes() {
        this.btnDeleteOrcamento.setOnAction(evt -> this.deleteOrcamento());
        this.btnVisualiza.setOnAction(event -> this.visualiza());
        this.btnImprime.setOnAction(evt -> this.imprime());
        this.btnEmail.setOnAction(evt -> this.email());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }

    private void imprime() {
        Orcamento orcamento = (Orcamento)this.tabela.getSelectionModel().getSelectedItem();
        if (orcamento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Selecione uma orcamento para imprimir.");
            return;
        }
        try {
            this.orcamentoService.imprime(orcamento);
        }
        catch (MaximaException ex) {
            Logger.getLogger(OrcamentosController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel imprimir o or\u00e7amento.\n" + ex.getMessage()));
        }
    }
}

