/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.food.modelo.Comanda;
import br.com.maximasolutions.food.service.MesaService;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVTouchComandasController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MesaService mesaService;
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private Button btnFechar;
    @FXML
    private ScrollPane paneComandas;
    private Comanda comanda;

    public void initialize(URL location, ResourceBundle resources) {
        this.registraAcoes();
    }

    public void inicializa() {
        this.comanda = null;
        this.atualizaComandas();
    }

    public Comanda getComanda() {
        return this.comanda;
    }

    private void atualizaComandas() {
        List mesaList = this.mesaService.listaOcupadasOrderEmissao();
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        int contColunas = 0;
        int contLinhas = 0;
        double btnWidth = this.paneComandas.getPrefWidth() / 5.0;
        for (Comanda mesa : mesaList) {
            Button btn = new Button();
            VBox vBox = new VBox();
            vBox.setAlignment(Pos.CENTER);
            Label mesaNome = new Label(mesa.getNome());
            mesaNome.getStyleClass().add((Object)"labelComanda");
            vBox.getChildren().addAll((Object[])new Node[]{mesaNome});
            btn.setGraphic((Node)vBox);
            btn.setPrefWidth(btnWidth);
            btn.setPrefHeight(90.0);
            btn.setFont(new Font(32.0));
            btn.setOnAction(event -> {
                this.comanda = mesa;
                this.fechaForm();
            });
            gridPane.add((Node)btn, contColunas, contLinhas);
            if (++contColunas < 5) continue;
            contColunas = 0;
            ++contLinhas;
        }
        this.paneComandas.setContent((Node)gridPane);
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> this.fechaForm());
    }

    private void fechaForm() {
        Stage form = (Stage)this.anchorPane.getScene().getWindow();
        form.close();
    }
}

