/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.ValidacaoController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.PDVTouchComandasController;
import br.com.maximasolutions.estoque.controller.PDVTouchFechamentoController;
import br.com.maximasolutions.estoque.controller.PDVTouchProdutosController;
import br.com.maximasolutions.estoque.controller.PDVTouchQuantidadeController;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.controller.VendaProdutoPDVController;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.food.modelo.Comanda;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.modelo.SatModelo;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVTouchController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ValidacaoService validacaoService;
    private Configuracao conf;
    private ObservableList<PedidoItem> pedidoItemList;
    private Pedido pedido;
    @FXML
    private VBox vBox;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private Pane paneCategorias;
    @FXML
    private ScrollPane touch;
    @FXML
    private TableView<PedidoItem> tabelaTouch;
    @FXML
    private TableColumn<PedidoItem, String> colProduto;
    @FXML
    private TableColumn<PedidoItem, String> colItem;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colTotalItem;
    @FXML
    private Button btnFinalizar;
    @FXML
    private Button btnCancelaPedido;
    @FXML
    private Button btnCancelarItem;
    @FXML
    private Button btnAbrirComanda;
    @FXML
    private Button btnPedidos;
    @FXML
    private Button btnProduto;
    @FXML
    private TextField tfProduto;
    private Boolean atalho;
    private ControleSAT controleSAT;

    public void initialize(URL location, ResourceBundle resources) {
        new ValidacaoController().validaAtivacao(this.stageManager, this.configuracaoService, this.validacaoService);
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
    }

    public void inicializaForm(Scene scene) {
        this.conf = this.configuracaoService.load();
        Stage form = (Stage)this.vBox.getScene().getWindow();
        form.setMaximized(true);
        form.setResizable(true);
        this.vBox.setStyle("-fx-background-image: url('images/bg_azul.png');-fx-background-repeat: stretch;-fx-background-position: center center;");
        this.carregaAtalhos(scene);
        this.inicializaSAT();
        this.inicializaPedido();
    }

    private void inicializaSAT() {
        String sat = MaximaConfig.getInstance().getProperty("sat", "");
        if (sat == null || sat.isEmpty()) {
            return;
        }
        SatModelo satModelo = SatModelo.get((String)sat);
        if (satModelo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Modelo de SAT n\u00e3o configurado no sistema.");
            return;
        }
        System.out.println("== MODELO SAT: " + satModelo);
        try {
            this.loadSAT(satModelo);
        }
        catch (MaximaException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
    }

    private void loadSAT(SatModelo satModelo) throws MaximaException {
        try {
            this.controleSAT = new ControleSAT(satModelo.getDll());
        }
        catch (UnsatisfiedLinkError e) {
            throw new MaximaException("AVISO: Falha ao carregar DLL do equipamento SAT: " + satModelo.toString() + ".");
        }
    }

    public void inicializaPedido() {
        this.atalho = false;
        this.pedido = null;
        this.pedidoItemList = null;
        this.inicializaItem();
        this.loadItens();
    }

    private void inicializaItem() {
        if (MaximaConfig.getInstance().getProperty("touch_categoria", "n").equalsIgnoreCase("s")) {
            this.listaCategorias();
        } else {
            this.listaProdutos(null);
        }
        this.loadItens();
        this.tfProduto.setText("");
        this.tfProduto.requestFocus();
    }

    private void getQuantidade(Produto produto) {
        BigDecimal quantidade = null;
        BigDecimal valorUnitario = null;
        Boolean brinde = false;
        try {
            Stage formQuantidade = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVTouchQuantidade.fxml", "PRODUTO");
            PDVTouchQuantidadeController controller = (PDVTouchQuantidadeController)formQuantidade.getUserData();
            controller.inicializa(produto);
            formQuantidade.showAndWait();
            quantidade = controller.getQuantidade();
            valorUnitario = controller.getValorUnitario();
            brinde = controller.getBrinde();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o foi poss\u00edvel abrir form de quantidade.");
            return;
        }
        if (quantidade != null) {
            this.addItem(produto, quantidade, valorUnitario, brinde);
            this.inicializaItem();
        }
    }

    private void produtos(CategoriaProduto categoriaProduto) {
        try {
            Stage formProdutos = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVTouchProdutos.fxml", "Produtos");
            PDVTouchProdutosController controller = (PDVTouchProdutosController)formProdutos.getUserData();
            controller.inicializa(categoriaProduto);
            formProdutos.showAndWait();
            Produto produto = controller.getProduto();
            if (produto != null) {
                this.getQuantidade(produto);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o foi poss\u00edvel abrir lista de produtos.");
        }
    }

    private void listaProdutos(CategoriaProduto categoria) {
        int linha = 1;
        int coluna = 1;
        int largura = 131;
        int altura = 60;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        List produtos = new ArrayList();
        if (categoria == null) {
            produtos = this.produtoService.getListaOrdenada();
        } else {
            produtos = this.produtoService.lista(categoria, null);
            Button btn = new Button("VOLTAR");
            btn.setTextAlignment(TextAlignment.CENTER);
            btn.wrapTextProperty().setValue(Boolean.valueOf(true));
            btn.setPrefWidth((double)largura);
            btn.setPrefHeight((double)altura);
            btn.setFont(Font.font((double)12.0));
            btn.setOnAction(evt -> this.listaCategorias());
            gridPane.add((Node)btn, coluna, linha);
            ++coluna;
        }
        for (Produto prod : produtos) {
            Button btn = new Button(prod.getNome().toUpperCase());
            btn.setTextAlignment(TextAlignment.CENTER);
            btn.wrapTextProperty().setValue(Boolean.valueOf(true));
            btn.setPrefWidth((double)largura);
            btn.setPrefHeight((double)altura);
            btn.setFont(Font.font((double)12.0));
            if (MaximaConfig.getInstance().getProperty("touch_validar_estoque", "s").equalsIgnoreCase("s")) {
                if (prod.getEstoqueAtual().compareTo(BigDecimal.ZERO) > 0) {
                    if (prod.getEstoqueAtual().compareTo(prod.getEstoqueMinimo()) > 0) {
                        btn.getStyleClass().add((Object)"btn-rich-blue");
                    } else {
                        btn.getStyleClass().add((Object)"btn-rich-orange");
                    }
                } else {
                    btn.getStyleClass().add((Object)"btn-rich-red-produto");
                }
            } else {
                btn.getStyleClass().add((Object)"btn-rich-blue");
            }
            btn.setOnAction(evt -> this.getQuantidade(prod));
            gridPane.add((Node)btn, coluna, linha);
            if (++coluna <= 4) continue;
            coluna = 1;
            ++linha;
        }
        this.touch.setContent((Node)gridPane);
    }

    private void listaCategorias() {
        List categorias = this.categoriaProdutoService.pesquisa("");
        int linha = 1;
        int coluna = 1;
        int largura = 131;
        int altura = 60;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        for (CategoriaProduto cat : categorias) {
            Button btn = new Button(cat.getNome().toUpperCase());
            btn.wrapTextProperty().setValue(Boolean.valueOf(true));
            btn.setPrefWidth((double)largura);
            btn.setPrefHeight((double)altura);
            btn.setFont(Font.font((double)18.0));
            btn.getStyleClass().add((Object)"btn-rich-blue");
            btn.setOnAction(evt -> this.listaProdutos(cat));
            gridPane.add((Node)btn, coluna, linha);
            if (++coluna <= 4) continue;
            coluna = 1;
            ++linha;
        }
        this.touch.setContent((Node)gridPane);
    }

    private void setColumnProperties() {
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricaoCompleta"));
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidadeFormatada"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalItem.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void carregaIcones() {
        this.btnFinalizar.getStyleClass().add((Object)"btn-green");
        this.btnCancelaPedido.getStyleClass().add((Object)"btn-rich-red");
        this.btnCancelarItem.getStyleClass().add((Object)"btn-rich-red");
        this.btnAbrirComanda.getStyleClass().add((Object)"btn-green-14");
        this.btnPedidos.getStyleClass().add((Object)"btn-green-14");
        this.btnProduto.setGraphic((Node)new MaximaIcone().icone_pesquisa_48());
    }

    private void carregaCombos() {
    }

    private void loadItens() {
        this.pedidoItemList = FXCollections.observableArrayList();
        this.pedidoItemList.clear();
        if (this.pedido != null && this.pedido.getId() != null) {
            this.pedidoItemList.addAll((Collection)this.pedidoService.itens(this.pedido));
            this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getTotal(), (int)2));
        } else {
            this.tfValorTotal.setText("0,00");
        }
        this.tabelaTouch.setItems(this.pedidoItemList);
        this.tabelaTouch.scrollTo(this.pedidoItemList.size() - 1);
    }

    private void carregaMascaras() {
    }

    private void registraAcoes() {
        this.btnPedidos.setOnAction(evt -> this.loadVendas());
        this.btnAbrirComanda.setOnAction(evt -> this.abreComanda());
        this.btnFinalizar.setOnAction(evt -> this.finalizaPedido());
        this.btnCancelaPedido.setOnAction(evt -> this.cancelarPedido());
        this.btnCancelarItem.setOnAction(evt -> this.cancelarItem());
        this.tfProduto.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                if (this.tfProduto.getText() == null || this.tfProduto.getText().isEmpty()) {
                    return;
                }
                Produto produto = this.pesquisaProduto();
                if (produto != null) {
                    this.getQuantidade(produto);
                }
            }
        });
        this.btnProduto.setOnAction(evt -> {
            Produto produto = this.pesquisaProdutoForm();
            if (produto != null) {
                this.getQuantidade(produto);
            }
        });
    }

    private void loadVendas() {
        try {
            Stage stage = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/VendaProdutoPDV.fxml", "Pedidos Recentes");
            VendaProdutoPDVController controller = (VendaProdutoPDVController)stage.getUserData();
            controller.inicializa(this.controleSAT, this.conf);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir janela de vendas.\n" + ex.getMessage()));
        }
    }

    private void abreComanda() {
        Comanda comanda;
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVTouchComandas.fxml", "");
            PDVTouchComandasController controller = (PDVTouchComandasController)form.getUserData();
            form.showAndWait();
            comanda = controller.getComanda();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir as comandas.\n" + ex.getMessage()));
            return;
        }
        if (comanda == null) {
            return;
        }
        this.pedido = this.pedidoService.getByComanda(comanda);
        if (this.pedido == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido n\u00e3o encontrado ou j\u00e1 finalizado.");
            return;
        }
        this.inicializaItem();
    }

    private void cancelarItem() {
        PedidoItem item = (PedidoItem)this.tabelaTouch.getSelectionModel().getSelectedItem();
        if (item == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Selecione um item para cancelar.");
            return;
        }
        try {
            this.pedido = this.pedidoService.deleteItem(item);
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Erro ao cancelar item.\n" + ex.getMessage()));
        }
        this.inicializaItem();
    }

    private void cancelarPedido() {
        if (this.pedido == null || this.pedido.getId() == null) {
            this.inicializaPedido();
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cancelar o pedido em andamento?")) {
            return;
        }
        try {
            this.pedidoService.cancela(this.pedido);
            this.inicializaPedido();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Ocorreu um erro ao cancelar o pedido.");
        }
    }

    private void addItem(Produto produto, BigDecimal quantidade, BigDecimal valorUnitario, Boolean brinde) {
        if (this.pedido == null || this.pedido.getId() == null) {
            try {
                this.iniciaPedido();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
        if (valorUnitario == null) {
            valorUnitario = BigDecimal.ZERO;
        }
        try {
            this.pedido = this.pedidoService.addItem(this.pedido, null, produto, quantidade, valorUnitario, BigDecimal.ZERO, "", brinde, Boolean.valueOf(false));
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void iniciaPedido() throws MaximaException {
        if (this.pedido != null && this.pedido.getId() != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Existe um pedido em andamento.\nN\u00e3o \u00e9 poss\u00edvel iniciar outro pedido.");
            return;
        }
        this.pedido = this.pedidoService.inicia(null, this.conf.getCliente(), LocalDate.now(), null, null);
    }

    private void finalizaPedido() {
        if (this.pedido == null || this.pedido.getId() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhum pedido iniciado.");
            return;
        }
        if (this.pedido.getTotal().compareTo(BigDecimal.ZERO) == 0) {
            VendaProduto vendaProduto = null;
            try {
                vendaProduto = this.vendaProdutoService.fechamentoSemFaturamento(this.pedido, null);
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Erro ao finalizar pedido.\n" + ex.getMessage()));
                return;
            }
            if (vendaProduto != null) {
                try {
                    this.vendaProdutoService.imprimeVenda(vendaProduto);
                }
                catch (MaximaException ex) {
                    Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)("Venda realizada com sucesso.\nAVISO: Erro ao imprimir comprovante de venda.\n" + ex.getMessage()));
                }
            }
            this.inicializaPedido();
            return;
        }
        try {
            Stage formFechamento = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.touch.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVTouchFechamento.fxml", "FECHAMENTO");
            PDVTouchFechamentoController controller = (PDVTouchFechamentoController)formFechamento.getUserData();
            controller.inicializa(this.pedido);
            formFechamento.showAndWait();
            if (controller.isFinalizado().booleanValue()) {
                this.inicializaPedido();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o foi poss\u00edvel abrir form de fechamento.");
        }
    }

    private void closeWindowEvent(WindowEvent event) {
        if (this.pedido == null || this.pedido.getId() == null) {
            if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja finalizar o sistema?")) {
                event.consume();
            }
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Existe um pedido em andamento. Cancele o pedido para encerrar o sistema.");
            event.consume();
        }
    }

    private void carregaAtalhos(Scene scene) {
        Stage stage = (Stage)scene.getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        stage.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!this.atalho.booleanValue() && event.getCode() == KeyCode.F1) {
                this.atalho = true;
                this.servidorApiForm();
                this.atalho = false;
            }
        });
    }

    private void servidorApiForm() {
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVTouchServidorApi.fxml", "");
            form.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVTouchController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo de SERVIDOR API Aplicativo");
        }
    }

    private Produto pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProduto.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return null;
        }
        Produto produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            produto = (Produto)produtos.get(0);
        }
        if (produto != null) {
            return produto;
        }
        return this.pesquisaProdutoForm();
    }

    private Produto pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProduto.getText().trim());
            stage.showAndWait();
            return controller.getProdutoSelecionado();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
            return null;
        }
    }
}

