/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.ProdutoService;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVTouchProdutosController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    @FXML
    private Pane paneProdutos;
    @FXML
    private AnchorPane mainPane;
    @FXML
    private Button btnFechar;
    private CategoriaProduto categoriaProduto;
    private Produto produto;

    public void initialize(URL location, ResourceBundle resources) {
        this.registraAcoes();
        this.icones();
    }

    public void inicializa(CategoriaProduto categoriaProduto) {
        this.categoriaProduto = categoriaProduto;
        this.produto = null;
        this.listaProdutos();
    }

    public Produto getProduto() {
        return this.produto;
    }

    private void confirma(Produto prod) {
        this.produto = prod;
        this.fechaForm();
    }

    private void listaProdutos() {
        List produtos = this.produtoService.lista(this.categoriaProduto, null);
        int linha = 1;
        int coluna = 1;
        int largura = 278;
        int altura = 80;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        for (Produto prod : produtos) {
            Button btn = new Button(prod.getNome().toUpperCase());
            btn.wrapTextProperty().setValue(Boolean.valueOf(true));
            btn.setPrefWidth((double)largura);
            btn.setPrefHeight((double)altura);
            btn.setFont(Font.font((double)18.0));
            if (prod.getEstoqueAtual().compareTo(prod.getEstoqueMinimo()) <= 0) {
                btn.getStyleClass().add((Object)"btn-rich-red");
            } else {
                btn.getStyleClass().add((Object)"btn-rich-blue");
            }
            btn.setOnAction(evt -> this.confirma(prod));
            gridPane.add((Node)btn, coluna, linha);
            if (++coluna <= 3) continue;
            coluna = 1;
            ++linha;
        }
        this.paneProdutos.getChildren().clear();
        this.paneProdutos.getChildren().add((Object)gridPane);
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> this.fechaForm());
    }

    private void cancela() {
        this.produto = null;
        this.fechaForm();
    }

    private void fechaForm() {
        Stage form = (Stage)this.mainPane.getScene().getWindow();
        form.close();
    }

    private void icones() {
        this.btnFechar.getStyleClass().add((Object)"btn-rich-red");
    }
}

