/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.ToledoDll;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.utils.MaximaNumber;
import com.sun.jna.Native;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVTouchQuantidadeController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    private Produto produto;
    @FXML
    private Button btnBrinde;
    @FXML
    private Button btn1;
    @FXML
    private Button btn2;
    @FXML
    private Button btn3;
    @FXML
    private Button btn4;
    @FXML
    private Button btn5;
    @FXML
    private Button btn6;
    @FXML
    private Button btn7;
    @FXML
    private Button btn8;
    @FXML
    private Button btn9;
    @FXML
    private Button btn10;
    @FXML
    private Button btnFechar;
    @FXML
    private Button btnConfirma;
    @FXML
    private Button btnBalanca;
    @FXML
    private Label labelDescricaoProduto;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfValorUnitario;
    private BigDecimal quantidade;
    private BigDecimal valorUnitario;
    private Boolean brinde;
    private ToledoDll balancaToledo;

    public void initialize(URL location, ResourceBundle resources) {
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.registraAcoes();
        this.btnBrinde.getStyleClass().add((Object)"btn-green");
        this.btn1.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btn2.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btn3.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btn4.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btn5.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btn6.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btn7.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btn8.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btn9.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btn10.getStyleClass().add((Object)"btn-dark-blue-qtd");
        this.btnConfirma.setGraphic((Node)new MaximaIcone().icone_confirma_48());
    }

    public void inicializa(Produto produto) {
        this.inicializaBalanca();
        this.produto = produto;
        this.brinde = false;
        this.labelDescricaoProduto.setText(this.produto.getNome().toUpperCase());
        if (MaximaConfig.getInstance().getProperty("touch_brinde", "s").equalsIgnoreCase("n")) {
            this.btnBrinde.setVisible(false);
        }
        this.tfQuantidade.setText("");
        this.tfValorUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
        this.tfQuantidade.requestFocus();
    }

    private void inicializaBalanca() {
        String porta = MaximaConfig.getBalancaPorta();
        if (porta.isEmpty()) {
            return;
        }
        this.inicializaBalancaToledo();
    }

    private void inicializaBalancaToledo() {
        String portaBalanca = MaximaConfig.getBalancaPorta();
        if (portaBalanca == null || portaBalanca.isEmpty()) {
            return;
        }
        Integer portaCom = null;
        try {
            portaCom = Integer.parseInt(portaBalanca);
        }
        catch (NumberFormatException numberFormatException) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A porta da balan\u00e7a deve ser um N\u00daMERO inteiro.");
            return;
        }
        try {
            this.balancaToledo = (ToledoDll)Native.loadLibrary((String)"P05", ToledoDll.class);
            System.out.println("=== balanca toledo: " + this.balancaToledo);
            this.balancaToledo.DeterminaUmStopBit();
            int retorno = this.balancaToledo.AbrePorta(portaCom.intValue(), 0, 1, 0);
            System.out.println("Retorno abre porta: " + retorno);
            if (retorno != 1) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir porta de comunica\u00e7\u00e3o com a balan\u00e7a.");
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("--- erro ao inicializar balan\u00e7a ---");
        }
        catch (Exception e) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um ao carregar a dll para balan\u00e7a.");
        }
    }

    public BigDecimal getQuantidade() {
        return this.quantidade;
    }

    public BigDecimal getValorUnitario() {
        return this.valorUnitario;
    }

    public Boolean getBrinde() {
        return this.brinde;
    }

    private void setBrinde() {
        this.brinde = true;
        this.quantidade = BigDecimal.ONE;
        this.fechaForm();
    }

    private void setQuantidade(BigDecimal valor) {
        this.quantidade = valor;
        this.valorUnitario = MaximaNumber.quantidadeToBigDecimal((String)this.tfValorUnitario.getText());
        this.fechaForm();
    }

    private void registraAcoes() {
        this.btnBrinde.setOnAction(evt -> this.setBrinde());
        this.btn1.setOnAction(evt -> this.setQuantidade(new BigDecimal(1)));
        this.btn2.setOnAction(evt -> this.setQuantidade(new BigDecimal(2)));
        this.btn3.setOnAction(evt -> this.setQuantidade(new BigDecimal(3)));
        this.btn4.setOnAction(evt -> this.setQuantidade(new BigDecimal(4)));
        this.btn5.setOnAction(evt -> this.setQuantidade(new BigDecimal(5)));
        this.btn6.setOnAction(evt -> this.setQuantidade(new BigDecimal(6)));
        this.btn7.setOnAction(evt -> this.setQuantidade(new BigDecimal(7)));
        this.btn8.setOnAction(evt -> this.setQuantidade(new BigDecimal(8)));
        this.btn9.setOnAction(evt -> this.setQuantidade(new BigDecimal(9)));
        this.btn10.setOnAction(evt -> this.setQuantidade(new BigDecimal(10)));
        this.btnFechar.setOnAction(evt -> this.cancela());
        this.tfQuantidade.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                if (this.tfQuantidade.getText() == null || this.tfQuantidade.getText().isEmpty()) {
                    return;
                }
                this.tfValorUnitario.requestFocus();
                this.tfValorUnitario.selectAll();
            }
        });
        this.tfValorUnitario.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                if (this.tfValorUnitario.getText() == null || this.tfValorUnitario.getText().isEmpty()) {
                    return;
                }
                BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
                this.setQuantidade(quantidade);
            }
        });
        this.btnConfirma.setOnAction(evt -> {
            if (this.tfQuantidade.getText() == null || this.tfQuantidade.getText().isEmpty()) {
                return;
            }
            BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
            this.setQuantidade(quantidade);
        });
        this.btnBalanca.setOnAction(evt -> this.capturarPesoBalanca());
    }

    private void capturarPesoBalanca() {
        System.out.println("--- capturar peso balan\u00e7a ---");
        if (this.balancaToledo == null) {
            this.inicializaBalancaToledo();
        }
        if (this.balancaToledo == null) {
            return;
        }
        byte[] peso = new byte[6];
        String local = "C:\\Maxima\\";
        int ret = this.balancaToledo.PegaPeso(0, peso, local);
        System.out.println("Retorno Pega Peso: " + ret);
        if (ret != 1) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao capturar peso da balan\u00e7a.");
            return;
        }
        BigDecimal quantidadePeso = MaximaNumber.convertStringToNumberToledo((String)new String(peso));
        this.tfQuantidade.setText(MaximaNumber.quantidadeToString((BigDecimal)quantidadePeso));
    }

    private void cancela() {
        this.quantidade = null;
        this.fechaForm();
    }

    private void fechaForm() {
        Stage form = (Stage)this.btn1.getScene().getWindow();
        form.close();
    }
}

