/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.SincronizacaoPdvService;
import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.GetNumeroFormController;
import br.com.maximasolutions.controller.GetValorFormController;
import br.com.maximasolutions.controller.PrincipalController;
import br.com.maximasolutions.controller.ValidacaoController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.core.print.ElginPrinter;
import br.com.maximasolutions.estoque.controller.CondicionalListaController;
import br.com.maximasolutions.estoque.controller.DevolucaoFechamentoFormController;
import br.com.maximasolutions.estoque.controller.PDVFechamentoFormController;
import br.com.maximasolutions.estoque.controller.PDVGetItemFormController;
import br.com.maximasolutions.estoque.controller.PDVVendedorFormController;
import br.com.maximasolutions.estoque.controller.PedidoItemEditaFormController;
import br.com.maximasolutions.estoque.controller.PedidoVendaConstrucaoFormController;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.controller.VendaProdutoController;
import br.com.maximasolutions.estoque.controller.VendaProdutoPDVController;
import br.com.maximasolutions.estoque.modelo.DevolucaoTipo;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.Promocao;
import br.com.maximasolutions.estoque.modelo.TipoMovimentacao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.DevolucaoService;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaFechaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaIniciaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaSangriaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaSuprimentoFormController;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.fiscal.controller.CPFFormController;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnQuantidadeFormatter;
import br.com.maximasolutions.nfce.controller.NFCeController;
import br.com.maximasolutions.nfce.controller.NFCeImportaVenda;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfce.modelo.NFCeDestinatario;
import br.com.maximasolutions.nfce.modelo.NFCeEmitente;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.sat.controller.SATController;
import br.com.maximasolutions.sat.controller.SatEnviaController;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.modelo.SatCFeXml;
import br.com.maximasolutions.sat.modelo.SatModelo;
import br.com.maximasolutions.sat.print.SatImpressaoController;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.sat.xml.modelo.CFe;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Controller
public class PDVVendedorFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private CaixaService caixaService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ValidacaoService validacaoService;
    @Autowired
    private NcmService ncmService;
    @Autowired
    private SatCFeService satCFeService;
    @Autowired
    private DevolucaoService devolucaoService;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private SincronizacaoPdvService sincronizacaoPdvService;
    @Autowired
    private NFCeService nFCeService;
    private Configuracao conf;
    private Produto produto;
    private Promocao promocao;
    private ObservableList<PedidoItem> pedidoItemList;
    private Pedido pedido;
    private Cliente cliente;
    @FXML
    private VBox vBox;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoDescricao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfValorUnitario;
    @FXML
    private TextField tfTotalItem;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfCliente;
    @FXML
    private TableView<PedidoItem> tabela;
    @FXML
    private TableColumn<PedidoItem, String> colProduto;
    @FXML
    private TableColumn<PedidoItem, String> colItem;
    @FXML
    private TableColumn<PedidoItem, String> colCodigo;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colTotalItem;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private Button btnProdutoAdd;
    @FXML
    private Button btnFinaliza;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnProdutoLimpar;
    @FXML
    private Button btnCliente;
    @FXML
    private ImageView imageLogo;
    @FXML
    private ComboBox<TipoMovimentacao> comboTipoPedido;
    @FXML
    private ComboBox<Vendedor> comboVendedor;
    @FXML
    private Button btnPedidos;
    @FXML
    private Button btnCondicionais;
    private Boolean atalho;
    private ControleSAT controleSAT;
    private Scene scene;

    public void initialize(URL location, ResourceBundle resources) {
        new ValidacaoController().validaAtivacao(this.stageManager, this.configuracaoService, this.validacaoService);
        this.stageManager.getStage().setUserData((Object)this);
    }

    public void inicializaPDV(Scene scene) {
        this.scene = scene;
        if (MaximaConfig.getInstance().getProperty("caixa_local", "n").equals("s")) {
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Sincronizando PDV com SERVIDOR.......");
            progress.show();
            this.sincronizaPDV(progress);
        }
        this.inicializaForm(scene);
    }

    private void sincronizaPDV(Stage progress) {
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$sincronizaPDV$0(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Falha na sincroniza\u00e7\u00e3o com o servidor.\nO sistema ser\u00e1 encerrado.");
            System.exit(0);
        });
        service.start();
    }

    public void inicializaForm(Scene scene) {
        System.out.println("==== INICILIZA FORM ====");
        this.conf = this.configuracaoService.load();
        if (this.conf != null && this.conf.getBloqueaPrecoVenda().booleanValue()) {
            this.tfValorUnitario.setDisable(true);
        } else {
            this.tfValorUnitario.setDisable(false);
        }
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
        this.carregaAtalhos(scene);
        this.validaMovimentoCaixa();
        this.inicializaSAT();
        this.formataCampos();
        this.inicializaPedido();
    }

    private void validaMovimentoCaixa() {
        String caixaIdTxt = MaximaConfig.getInstance().getProperty("caixa_id");
        if (caixaIdTxt == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Caixa n\u00e3o configurado no arquivo properties.");
            return;
        }
        Long caixaId = Long.parseLong(caixaIdTxt);
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixaId.longValue());
        if (movimentoCaixa == null) {
            try {
                Stage abreMovimentoCaixaForm = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentoCaixa/AbrirCaixaForm.fxml", "Abertura de Movimento de Caixa");
                MovimentoCaixaIniciaFormController controller = (MovimentoCaixaIniciaFormController)abreMovimentoCaixaForm.getUserData();
                controller.inicializa(null);
                abreMovimentoCaixaForm.showAndWait();
            }
            catch (IOException ex) {
                Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo: ABERTURA DE MOVIMENTO DE CAIXA.");
                System.exit(0);
            }
            movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixaId.longValue());
            if (movimentoCaixa == null) {
                this.vBox.setDisable(true);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhum movimento de caixa aberto.");
            }
        } else if (movimentoCaixa.getDataAbertura().toLocalDate().isBefore(LocalDate.now())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Movimento de caixa n\u00e3o fechado do dia anterior.");
        }
    }

    private void inicializaSAT() {
        String sat = MaximaConfig.getInstance().getProperty("sat", "");
        if (sat == null || sat.isEmpty()) {
            return;
        }
        SatModelo satModelo = SatModelo.get((String)sat);
        if (satModelo == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Modelo de SAT n\u00e3o configurado no sistema.");
            return;
        }
        System.out.println("== MODELO SAT: " + satModelo);
        try {
            this.loadSAT(satModelo);
        }
        catch (MaximaException ex) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
    }

    private void loadSAT(SatModelo satModelo) throws MaximaException {
        try {
            this.controleSAT = new ControleSAT(satModelo.getDll());
        }
        catch (UnsatisfiedLinkError e) {
            throw new MaximaException("AVISO: Falha ao carregar DLL do equipamento SAT: " + satModelo.toString() + ".");
        }
    }

    public void inicializaPedido() {
        this.atalho = false;
        this.pedido = null;
        this.cliente = null;
        this.pedidoItemList = null;
        this.comboTipoPedido.getSelectionModel().select((Object)TipoMovimentacao.PEDIDO_VENDA);
        this.comboVendedor.getSelectionModel().select(null);
        this.inicializaItem();
        this.carregaCliente();
    }

    private void carregaCliente() {
        if (this.cliente == null) {
            this.tfCliente.setText("");
        } else {
            String texto = this.cliente.getNome().toUpperCase();
            texto = this.cliente.getTelefone() == null || this.cliente.getTelefone().isEmpty() ? texto + "  |  FONE N\u00c3O CADASTRADO" : texto + "  |  " + this.cliente.getTelefone();
            this.tfCliente.setText(texto);
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        }
    }

    private void inicializaItem() {
        this.produto = null;
        this.promocao = null;
        this.loadDadosProduto();
        this.loadItens();
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricaoCompleta"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidadeFormatada"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        ColumnNumberFormatter valorFormatter = new ColumnNumberFormatter();
        ColumnQuantidadeFormatter quantidadeFormatter = new ColumnQuantidadeFormatter();
        this.colQuantidade.setCellFactory((Callback)quantidadeFormatter);
        this.colUnitario.setCellFactory((Callback)valorFormatter);
        this.colTotalItem.setCellFactory((Callback)valorFormatter);
    }

    private void imprimeUltimaVenda() {
        try {
            this.vendaProdutoService.imprimeUltimaVenda();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem(null));
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnProdutoAdd.setGraphic((Node)maximaIcone.icone_add_48());
        this.btnProdutoLimpar.setGraphic((Node)maximaIcone.icone_delete_48());
        this.btnFinaliza.setGraphic((Node)maximaIcone.icone_confirma_40());
        this.btnCancela.setGraphic((Node)maximaIcone.icone_cancela_40());
        this.btnProdutoPesquisa.setGraphic((Node)maximaIcone.icone_pesquisa_48());
        this.btnCliente.setGraphic((Node)maximaIcone.icone_usuario_48());
        this.btnPedidos.setGraphic((Node)maximaIcone.cart_28());
        this.btnCondicionais.setGraphic((Node)maximaIcone.cesta_28());
        Image logo = new Image(this.getClass().getResourceAsStream("/icones/logo_texto_220.png"));
        this.imageLogo.setImage(logo);
    }

    private void carregaCombos() {
        ArrayList tipoMovimentacaos = new ArrayList();
        tipoMovimentacaos.add(null);
        tipoMovimentacaos.addAll(TipoMovimentacao.comboPDV());
        this.comboTipoPedido.setItems(FXCollections.observableArrayList(tipoMovimentacaos));
        ArrayList vendedores = new ArrayList();
        vendedores.add(null);
        vendedores.addAll(this.vendedorService.list());
        this.comboVendedor.setItems(FXCollections.observableArrayList(vendedores));
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            this.produto = null;
            this.promocao = null;
            this.loadDadosProduto();
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto == null && produtoCodigo.length() == 13 && produtoCodigo.substring(0, 1).equals("2")) {
            String codigoProduto = produtoCodigo.substring(1, 5);
            String precoTotal1 = produtoCodigo.substring(5, 10);
            String precoTotal2 = produtoCodigo.substring(10, 12);
            BigDecimal precoTotal = new BigDecimal(precoTotal1 + "." + precoTotal2);
            this.produto = this.produtoService.getByCodigoBarras(codigoProduto);
            if (this.produto != null) {
                BigDecimal quantidade = precoTotal.divide(this.produto.getPrecoVenda(), 3, RoundingMode.HALF_UP).setScale(3, RoundingMode.HALF_UP);
                this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
            } else {
                codigoProduto = produtoCodigo.substring(3, 7);
                precoTotal1 = produtoCodigo.substring(7, 10);
                precoTotal2 = produtoCodigo.substring(10, 12);
                precoTotal = new BigDecimal(precoTotal1 + "." + precoTotal2);
                List produtos2 = this.produtoService.getByCodigoInterno(codigoProduto);
                if (produtos2 != null && produtos2.size() == 1) {
                    this.produto = (Produto)produtos2.get(0);
                }
                if (this.produto != null) {
                    BigDecimal quantidade = precoTotal.divide(this.produto.getPrecoVenda(), 3, RoundingMode.HALF_UP).setScale(3, RoundingMode.HALF_UP);
                    this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                } else {
                    codigoProduto = produtoCodigo.substring(4, 7);
                    produtos2 = this.produtoService.getByCodigoInterno(codigoProduto);
                    if (produtos2 != null && produtos2.size() == 1) {
                        this.produto = (Produto)produtos2.get(0);
                    }
                    if (this.produto != null) {
                        BigDecimal quantidade = precoTotal.divide(this.produto.getPrecoVenda(), 3, RoundingMode.HALF_UP).setScale(3, RoundingMode.HALF_UP);
                        this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                    }
                }
            }
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoDescricao.setText(MaximaNumber.quantidadeToString((BigDecimal)MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText())) + "  X  " + this.produto.getNome().toUpperCase());
            this.tfValorUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            if (this.cliente != null && this.cliente.getTabela2().booleanValue()) {
                this.tfValorUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPreco2(), (int)2));
            }
            this.calculaTotalItem();
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
        } else {
            if (this.pedido == null || this.pedido.getId() == null) {
                this.tfProdutoDescricao.setText("");
                this.tfValorUnitario.setText("");
            }
            this.calculaTotalItem();
            this.tfQuantidade.setText("1");
            this.tfProdutoPesquisa.setText("");
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        }
    }

    private void loadItens() {
        this.pedidoItemList = FXCollections.observableArrayList();
        this.pedidoItemList.clear();
        if (this.pedido != null && this.pedido.getId() != null) {
            this.pedidoItemList.addAll((Collection)this.pedidoService.itens(this.pedido));
            this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getTotal(), (int)2));
        } else {
            this.tfValorTotal.setText("0,00");
        }
        this.tabela.setItems(this.pedidoItemList);
        this.tabela.scrollTo(this.pedidoItemList.size() - 1);
    }

    private void calculaTotalItem() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfTotalItem.setText("");
            return;
        }
        BigDecimal valorUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfValorUnitario.getText());
        if (valorUnitario == null) {
            this.tfTotalItem.setText("");
            return;
        }
        BigDecimal totalItem = valorUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalItem.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalItem, (int)2));
    }

    private void carregaMascaras() {
    }

    private void closeWindowEvent(WindowEvent event) {
        if (this.pedido == null || this.pedido.getId() == null) {
            if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja finalizar o sistema?")) {
                event.consume();
            }
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Existe um pedido em andamento. Cancele o pedido para encerrar o sistema.");
            event.consume();
        }
    }

    private void selecionaProduto() {
        String codigoPesquisa = this.tfProdutoPesquisa.getText();
        if (codigoPesquisa == null || codigoPesquisa.isEmpty()) {
            this.produto = null;
        } else if (this.produto == null || !this.produto.getCodigo().equals(codigoPesquisa.trim())) {
            this.pesquisaProduto();
        }
        if (this.produto != null) {
            if (this.conf.getBloqueaPrecoVenda().booleanValue()) {
                this.addItem();
            } else {
                this.tfQuantidade.selectAll();
                this.tfQuantidade.requestFocus();
            }
        }
    }

    private void selecionaCliente() {
        Cliente clientePesquisa = new ClientePesquisaForm().getCliente(this.stageManager, this.btnCliente.getScene(), "");
        if (clientePesquisa != null) {
            this.cliente = clientePesquisa;
            if (this.pedido != null && this.pedido.getId() != null) {
                this.pedido.setCliente(this.cliente);
                this.pedido = this.pedidoService.salva(this.pedido);
            }
            this.carregaCliente();
        }
    }

    private void registraAcoes() {
        this.tabela.setContextMenu(this.getTableMenu());
        this.btnCondicionais.setOnAction(evt -> this.listaCondicionais());
        this.btnPedidos.setOnAction(evt -> this.listaVendas());
        this.btnCliente.setOnAction(evt -> this.selecionaCliente());
        this.btnProdutoPesquisa.setOnAction(evt -> this.pesquisaProdutoForm());
        this.btnProdutoAdd.setOnAction(evt -> this.addItem());
        this.btnProdutoLimpar.setOnAction(evt -> this.inicializaItem());
        this.btnFinaliza.setOnAction(evt -> this.finalizaPedido());
        this.btnCancela.setOnAction(evt -> this.cancelaPedido());
        this.tfProdutoPesquisa.focusedProperty().addListener((obs, oldVal, newVal) -> {
            if (oldVal.booleanValue()) {
                // empty if block
            }
        });
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.selecionaProduto();
            }
        });
        this.tfQuantidade.setOnKeyReleased(event -> {
            if (!this.conf.getBloqueaPrecoVenda().booleanValue()) {
                this.calculaTotalItem();
            }
        });
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.conf.getBloqueaPrecoVenda().booleanValue()) {
                    this.addItem();
                } else {
                    this.tfValorUnitario.requestFocus();
                    this.tfValorUnitario.selectAll();
                }
            }
        });
        this.tfValorUnitario.setOnKeyReleased(event -> this.calculaTotalItem());
        this.tfValorUnitario.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addItem();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem(null);
            }
        });
        this.comboVendedor.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
            if (this.pedido != null && this.pedido.getId() != null) {
                this.pedido.setVendedor(newValue);
                this.pedido = this.pedidoService.salva(this.pedido);
            }
        });
    }

    private void setQuantidade() {
        this.tfQuantidade.requestFocus();
        this.tfQuantidade.selectAll();
    }

    private void carregaAtalhos(Scene scene) {
        System.out.println("== CARREGA ATALHOS ==");
        Stage stage = (Stage)scene.getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        KeyCodeCombination kcF1 = new KeyCodeCombination(KeyCode.F1, new KeyCombination.Modifier[0]);
        Runnable rnF1 = () -> this.selecionaCliente();
        scene.getAccelerators().put((Object)kcF1, (Object)rnF1);
        KeyCodeCombination kcF2 = new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]);
        Runnable rnF2 = () -> {
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        };
        scene.getAccelerators().put((Object)kcF2, (Object)rnF2);
        KeyCodeCombination kcF3 = new KeyCodeCombination(KeyCode.F3, new KeyCombination.Modifier[0]);
        Runnable rnF3 = () -> this.setQuantidade();
        scene.getAccelerators().put((Object)kcF3, (Object)rnF3);
        KeyCodeCombination kcF4 = new KeyCodeCombination(KeyCode.F4, new KeyCombination.Modifier[0]);
        Runnable rnF4 = () -> this.editaItem();
        scene.getAccelerators().put((Object)kcF4, (Object)rnF4);
        KeyCodeCombination kcF5 = new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]);
        Runnable rnF5 = () -> this.finalizaPedido();
        scene.getAccelerators().put((Object)kcF5, (Object)rnF5);
        KeyCodeCombination kcF6 = new KeyCodeCombination(KeyCode.F6, new KeyCombination.Modifier[0]);
        Runnable rnF6 = () -> this.imprimeUltimaVenda();
        scene.getAccelerators().put((Object)kcF6, (Object)rnF6);
        KeyCodeCombination kcF8 = new KeyCodeCombination(KeyCode.F8, new KeyCombination.Modifier[0]);
        Runnable rnF8 = () -> this.abreGaveta();
        scene.getAccelerators().put((Object)kcF8, (Object)rnF8);
        KeyCodeCombination kcF9 = new KeyCodeCombination(KeyCode.F9, new KeyCombination.Modifier[0]);
        Runnable rnF9 = () -> this.cancelaItem();
        scene.getAccelerators().put((Object)kcF9, (Object)rnF9);
        KeyCodeCombination kcF10 = new KeyCodeCombination(KeyCode.F10, new KeyCombination.Modifier[0]);
        Runnable rnF10 = () -> this.cancelaPedido();
        scene.getAccelerators().put((Object)kcF10, (Object)rnF10);
        KeyCodeCombination kcF11 = new KeyCodeCombination(KeyCode.F11, new KeyCombination.Modifier[0]);
        Runnable rnF11 = () -> this.listaVendas();
        scene.getAccelerators().put((Object)kcF11, (Object)rnF11);
        KeyCodeCombination kcF12 = new KeyCodeCombination(KeyCode.F12, new KeyCombination.Modifier[0]);
        Runnable rnF12 = () -> this.emiteCupomUltimaVenda();
        scene.getAccelerators().put((Object)kcF12, (Object)rnF12);
    }

    private void salvaPedido() throws MaximaException {
        if (this.pedido != null && this.pedido.getId() != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Existe um pedido em andamento.\nN\u00e3o \u00e9 poss\u00edvel iniciar outro pedido.");
            return;
        }
        this.pedido = this.pedidoService.inicia((Vendedor)this.comboVendedor.getSelectionModel().getSelectedItem(), this.cliente == null ? this.conf.getCliente() : this.cliente, LocalDate.now(), null, null);
        this.cliente = this.pedido.getCliente();
        this.carregaCliente();
    }

    private void addItem() {
        if (this.produto == null && this.promocao == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Informe um produto para adicionar o item.");
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
            return;
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) == 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Informe uma quantidade v\u00e1lida (Deve ser um n\u00famero maior que zero).");
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
            return;
        }
        if (this.pedido == null || this.pedido.getId() == null) {
            try {
                this.salvaPedido();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                return;
            }
        }
        BigDecimal valorUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfValorUnitario.getText());
        if (this.conf.getBloqueaPrecoVenda().booleanValue() && (valorUnitario == null || valorUnitario.compareTo(BigDecimal.ZERO) <= 0)) {
            valorUnitario = this.getValorUnitario();
        }
        BigDecimal desconto = BigDecimal.ZERO;
        String observacao = "";
        try {
            boolean isTroca = quantidade.compareTo(BigDecimal.ZERO) < 0;
            this.pedido = this.pedidoService.addItem(this.pedido, null, this.produto, quantidade, valorUnitario, desconto, observacao, Boolean.valueOf(false), Boolean.valueOf(isTroca));
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
    }

    private void editaItem() {
        PedidoItem item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            Long numeroItem;
            try {
                Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/GetNumeroForm.fxml", "Informe o n\u00famero do Item");
                GetNumeroFormController controller = (GetNumeroFormController)form.getUserData();
                form.showAndWait();
                numeroItem = controller.getNumero();
            }
            catch (IOException ex) {
                Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel excluir item.");
                return;
            }
            item = this.pedidoService.getPorNumeroItem(Integer.valueOf(numeroItem.intValue()), this.pedido);
            if (item == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Item n\u00e3o encontrado.");
                return;
            }
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PedidoItemEditaForm.fxml", "Edi\u00e7\u00e3o de produto");
            PedidoItemEditaFormController controller = (PedidoItemEditaFormController)form.getUserData();
            controller.inicializa(item);
            form.showAndWait();
            this.pedido = this.pedidoService.getById(this.pedido.getId());
            this.inicializaItem();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo: 'PedidoItemEditaForm.fxml'.");
        }
    }

    private void deleteItem(PedidoItem item) {
        if (item == null && (item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem()) == null) {
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o item: " + item.getNumItem() + " ?"))) {
            return;
        }
        try {
            this.pedido = this.pedidoService.deleteItem(item);
            this.inicializaItem();
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Item removido com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void finalizaPedido() {
        if (this.pedido == null || this.pedido.getId() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum pedido inicializado.");
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
            return;
        }
        TipoMovimentacao tipoMovimentacao = (TipoMovimentacao)this.comboTipoPedido.getSelectionModel().getSelectedItem();
        if (tipoMovimentacao == null || tipoMovimentacao.equals((Object)TipoMovimentacao.PEDIDO_VENDA)) {
            this.finalizaVenda();
        } else if (tipoMovimentacao.equals((Object)TipoMovimentacao.CONDICIONAL)) {
            this.finalizaCondicional();
        }
    }

    private void finalizaDevolucao() {
        DevolucaoTipo devolucaoTipo;
        boolean erro = false;
        String mensagemErro = "";
        for (PedidoItem item : this.pedidoItemList) {
            if (item.getQuantidade().compareTo(BigDecimal.ZERO) < 0) continue;
            erro = true;
            mensagemErro = mensagemErro + "Item " + item.getNumItem() + ": Quantidade deve ser um n\u00famero negativo.\n";
        }
        if (erro) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + mensagemErro));
            return;
        }
        try {
            Stage formDevolucao = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/DevolucaoFechamentoForm.fxml", "");
            DevolucaoFechamentoFormController controller = (DevolucaoFechamentoFormController)formDevolucao.getUserData();
            formDevolucao.showAndWait();
            devolucaoTipo = controller.getDevolucaoTipo();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir o fechamento de devolu\u00e7\u00e3o.");
            return;
        }
        if (devolucaoTipo == null) {
            return;
        }
        try {
            this.devolucaoService.salva(this.pedido, devolucaoTipo);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Devolu\u00e7\u00e3o efetuada com sucesso.");
            this.inicializaPedido();
        }
        catch (MaximaException | MaximaValidacaoException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    private void finalizaVenda() {
        if (MaximaConfig.pdvVendedorObrigatorio().booleanValue() && this.comboVendedor.getSelectionModel().getSelectedItem() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe o vendedor.");
            return;
        }
        if (this.pedidoItemList == null || this.pedidoItemList.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum produto adicionado no pedido.");
            return;
        }
        if (this.pedido.getTotal().compareTo(BigDecimal.ZERO) < 0) {
            this.finalizaDevolucao();
            return;
        }
        if (this.pedido.getTotal().compareTo(BigDecimal.ZERO) == 0) {
            try {
                VendaProduto venda = this.vendaProdutoService.fechamentoSemFaturamento(this.pedido, this.cliente);
                if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Troca efetuada com sucesso. Deseja imprimir o comprovante?")) {
                    this.vendaProdutoService.imprimeVenda(venda);
                }
                this.inicializaPedido();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: Falha ao finalizar troca.");
            }
            return;
        }
        try {
            Stage formFechamento = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVFechamentoForm.fxml", "FINALIZAR PEDIDO");
            PDVFechamentoFormController controller = (PDVFechamentoFormController)formFechamento.getUserData();
            controller.inicializaFechamento(this.pedido);
            formFechamento.showAndWait();
            if (controller.getSucesso()) {
                VendaProduto vendaProduto = controller.getVendaProduto();
                this.abreGaveta();
                Boolean emitirSat = MaximaConfig.getInstance().getProperty("sat_emitir", "n").equalsIgnoreCase("s");
                if (emitirSat.booleanValue() || controller.isEmitirCupom()) {
                    this.emiteCupomUltimaVenda();
                } else if (!MaximaConfig.pdvImprimeDireto().booleanValue()) {
                    if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Venda emitida com sucesso. Deseja imprimir o comprovante de venda?")) {
                        this.imprimeVenda(vendaProduto);
                    }
                } else {
                    this.imprimeVenda(vendaProduto);
                }
                this.inicializaPedido();
            } else {
                this.pedido = this.pedidoService.getById(this.pedido.getId());
                this.inicializaItem();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o form de fechamento de pedido.\n" + ex.getMessage()));
        }
    }

    private void finalizaCondicional() {
        if (this.cliente == null || this.cliente.getId().equals(this.conf.getCliente().getId())) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Selecione um cliente v\u00e1lido para finalizar a condicional");
            return;
        }
        if (this.pedidoItemList == null || this.pedidoItemList.isEmpty()) {
            VendaProduto vendaProduto = this.vendaProdutoService.getByPedido(this.pedido.getId());
            if (vendaProduto != null && MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja encerrar a condicional?")) {
                try {
                    this.vendaProdutoService.delete(vendaProduto);
                    this.inicializaPedido();
                }
                catch (MaximaException ex) {
                    Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel finalizar a condicional.");
                }
            }
            return;
        }
        try {
            VendaProduto vendaProduto = this.vendaProdutoService.salva(this.pedido, this.cliente == null ? this.conf.getCliente() : this.cliente, TipoMovimentacao.CONDICIONAL);
            if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Condicional salva com sucesso. Deseja imprimir a condicional?")) {
                this.imprimeVenda(vendaProduto);
            }
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Falha ao finalizar a condicional.\n" + ex.getMessage()));
        }
        this.inicializaPedido();
    }

    private void imprimeVenda(VendaProduto vendaProduto) {
        try {
            this.vendaProdutoService.imprimeVenda(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido n\u00e3o impressora. \nFalha na comunica\u00e7\u00e3o com a impress\u00e3o.");
        }
    }

    private void cancelaPedido() {
        VendaProduto condicional;
        if (this.pedido == null || this.pedido.getId() == null) {
            return;
        }
        if (this.pedido.getTipoMovimentacao() != null && this.pedido.getTipoMovimentacao().equals((Object)TipoMovimentacao.CONDICIONAL) ? (condicional = this.vendaProdutoService.getByPedido(this.pedido.getId())) != null && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja EXCLUIR a condicional?") : !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cancelar o pedido em andamento?")) {
            return;
        }
        try {
            this.pedidoService.cancela(this.pedido);
            this.inicializaPedido();
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Pedido cancelado com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void listaCondicionais() {
        VendaProduto condicional = null;
        try {
            Stage stage = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/CondicionalLista.fxml", "Condicionais");
            CondicionalListaController controller = (CondicionalListaController)stage.getUserData();
            controller.inicializa(this.controleSAT, this.conf);
            stage.showAndWait();
            condicional = controller.getCondicional();
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir janela de vendas.\n" + ex.getMessage()));
            return;
        }
        if (condicional != null) {
            if (condicional.getPedido() == null) {
                this.pedidoService.create(condicional);
                condicional = this.vendaProdutoService.getById(condicional.getId());
            }
            if (condicional.getPedido().getExcluido().booleanValue()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido exclu\u00eddo ou desativado.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
                return;
            }
            this.carregaPedido(condicional.getPedido(), null);
        }
    }

    private void carregaPedido(Pedido pedido, String numeroPedido) {
        System.out.println("Carregar Pedido: " + numeroPedido);
        this.pedido = this.pedidoService.getById(pedido.getId());
        this.comboVendedor.getSelectionModel().select((Object)pedido.getVendedor());
        this.cliente = pedido.getCliente();
        this.comboTipoPedido.getSelectionModel().select((Object)pedido.getTipoMovimentacao());
        this.carregaCliente();
        this.inicializaItem();
    }

    private void listaVendas() {
        try {
            Stage stage = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/VendaProdutoPDV.fxml", "Pedidos Recentes");
            VendaProdutoPDVController controller = (VendaProdutoPDVController)stage.getUserData();
            controller.inicializa(this.controleSAT, this.conf);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir janela de vendas.\n" + ex.getMessage()));
        }
    }

    private void emiteCupomUltimaVenda() {
        String cpf;
        String nome;
        VendaProduto ultimaVenda = this.vendaProdutoService.getUltima(Long.valueOf(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id"))));
        if (!ultimaVenda.isFaturado().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido n\u00e3o faturado. N\u00e3o pode ser emitido cupom fiscal.");
            return;
        }
        if (ultimaVenda.isExcluida().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido exclu\u00eddo. N\u00e3o pode ser emitido cupom fiscal.");
            return;
        }
        if (ultimaVenda.getSatCFe() != null || ultimaVenda.getNfce() != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal j\u00e1 emitido para a venda selecioanda. N\u00e3o \u00e9 permitido a opera\u00e7\u00e3o.");
            return;
        }
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/CPFForm.fxml", "CPF ou CNPJ");
            CPFFormController controller = (CPFFormController)stage.getUserData();
            controller.inicializa();
            if (ultimaVenda.getCliente().getCpf() != null && !ultimaVenda.getCliente().getCpf().isEmpty()) {
                controller.setCpf(ultimaVenda.getCliente().getCpf());
            }
            controller.setCliente(ultimaVenda.getCliente().getNome());
            stage.showAndWait();
            if (!controller.isFinalizado()) {
                return;
            }
            nome = controller.getNome();
            cpf = controller.getCpf();
        }
        catch (IOException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir janela de CPF ou CNPJ.");
            return;
        }
        if (MaximaConfig.getCupomTipo().equalsIgnoreCase("sat")) {
            this.emiteCupomSAT(ultimaVenda, cpf, nome);
        } else {
            this.emiteCupomNFCe(ultimaVenda, cpf, nome);
        }
    }

    private void emiteCupomNFCe(VendaProduto ultimaVenda, String cpf, String nome) {
        NFCeCabecalho nfce;
        block10: {
            nfce = null;
            try {
                List list = this.vendaProdutoService.listItens(ultimaVenda);
                List faturamentos = this.vendaProdutoService.listaFaturamentos(ultimaVenda);
                NFCeImportaVenda nFCeImportaVenda = new NFCeImportaVenda(this.conf, this.nFCeService);
                nfce = nFCeImportaVenda.getNFCe(ultimaVenda, list);
                NFCeEmitente emitente = nFCeImportaVenda.getEmitente();
                NFCeDestinatario destinatario = nFCeImportaVenda.getDestinatario(cpf, nome);
                List itens = nFCeImportaVenda.getItensNFe(ultimaVenda, list, this.ncmService);
                List pagamentos = nFCeImportaVenda.pagamentos(faturamentos);
                nfce = this.nFCeService.salva(nfce, emitente, destinatario, itens, pagamentos, ultimaVenda, this.conf);
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Ocorreu um erro ao gerar Cupom Fiscal Consumidor");
                if (nfce == null) break block10;
                try {
                    this.nFCeService.delete(nfce);
                }
                catch (MaximaException ex1) {
                    Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex1);
                }
                nfce = null;
            }
            catch (Exception ex) {
                Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Ocorreu um erro ao validar o xml do Cupom Fiscal Consumidor");
                if (nfce == null) break block10;
                try {
                    this.nFCeService.delete(nfce);
                }
                catch (MaximaException ex1) {
                    Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex1);
                }
                nfce = null;
            }
        }
        if (nfce != null && nfce.getStatusNota().equals((Object)NFeStatus.AUTORIZADA)) {
            try {
                this.nFCeService.imprime(nfce, this.conf);
            }
            catch (MaximaException ex) {
                Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Cupom Fiscal N\u00e3o Impresso.\n" + ex.getMessage()));
            }
        }
    }

    private void emiteCupomSAT(VendaProduto ultimaVenda, String cpf, String nome) {
        SatCFe satCFe;
        byte[] arquivoCupom = null;
        try {
            String xmlEnvio = SatEnviaController.convertVendaProdutoToXmlCupom((NcmService)this.ncmService, (VendaProduto)ultimaVenda, (List)this.vendaProdutoService.listItens(ultimaVenda), (List)this.vendaProdutoService.listaFaturamentos(ultimaVenda), (Configuracao)this.conf, (String)MaximaConfig.getInstance().getProperty("caixa_id", "1"), (String)cpf, (String)nome);
            String xmlCupomEmitido = new SATController(this.controleSAT, this.conf).emiteCupom(xmlEnvio);
            arquivoCupom = SatEnviaController.tratarResultadoVenda((String)xmlCupomEmitido, (Configuracao)this.conf);
            SatCFeXml satCFeXml = new SatCFeXml();
            if (arquivoCupom != null) {
                satCFeXml.setArquivo(arquivoCupom);
            }
            String xmlCupom = ControleArquivos.lerBytesArquivo((String)"C:/Maxima/ultimoCupom.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xmlCupom.getBytes());
            Document doc = db.parse(is);
            NodeList raizes = doc.getChildNodes();
            org.w3c.dom.Node raiz = raizes.item(0);
            CFe xmlCFe = new CFe(raiz);
            satCFe = this.satCFeService.getSatCfeXmlCupom(xmlCFe);
            List itens = this.satCFeService.getSatCfeItemXmlCupom(xmlCFe);
            List parcelas = this.satCFeService.getSatCfePagamento(xmlCFe);
            satCFe = this.satCFeService.salvaCupom(satCFe, itens, parcelas, satCFeXml, ultimaVenda);
        }
        catch (Exception ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao emitir cupom fiscal.\n" + ex.getMessage()));
            return;
        }
        try {
            SatImpressaoController.imprimeCupom((byte[])arquivoCupom, (Configuracao)this.conf, (SatCFe)satCFe);
        }
        catch (Exception ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal emitido com sucesso.\nAVISO:Falha ao imprimir cupom fiscal.");
        }
    }

    private void fecharCaixa() {
        try {
            Long caixaId = Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1"));
            MovimentoCaixa movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixaId.longValue());
            if (movimentoCaixa == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum movimento de caixa aberto.");
                return;
            }
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentoCaixa/FecharCaixaForm.fxml", "Fechamento de Caixa");
            MovimentoCaixaFechaFormController controller = (MovimentoCaixaFechaFormController)stage.getUserData();
            controller.inicializa();
            stage.showAndWait();
            if (controller.isSucesso()) {
                System.exit(0);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir form de fechamento de caixa.");
        }
    }

    private void abreGaveta() {
        boolean acionarGaveta = MaximaConfig.getInstance().getProperty("pdv_gaveta", "n").equalsIgnoreCase("s");
        if (!acionarGaveta) {
            return;
        }
        try {
            ElginPrinter printer = new ElginPrinter();
            printer.acionaGaveta();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Falha ao abrir gaveta.");
        }
    }

    private void cancelaItem() {
        String valor;
        if (this.pedido == null || this.pedido.getId() == null) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVGetItemForm.fxml", "Pesquisar item");
            PDVGetItemFormController controller = (PDVGetItemFormController)form.getUserData();
            form.showAndWait();
            valor = controller.getRetorno();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel excluir item.");
            return;
        }
        PedidoItem item = this.pedidoService.getPorCodigoOuNumeroItem(valor, this.pedido);
        if (item == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Item n\u00e3o encontrado.");
            return;
        }
        this.deleteItem(item);
    }

    private BigDecimal getValorUnitario() {
        BigDecimal valorUnitario = BigDecimal.ZERO;
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/GetValorForm.fxml", "Informe o valor unit\u00e1rio");
            GetValorFormController controller = (GetValorFormController)form.getUserData();
            form.showAndWait();
            valorUnitario = controller.getValor();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return valorUnitario;
    }

    private void sangriaCaixa() {
        try {
            Stage sangriaForm = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/financeiro/movimentoCaixa/SangriaForm.fxml", "SANGRIA");
            MovimentoCaixaSangriaFormController controller = (MovimentoCaixaSangriaFormController)sangriaForm.getUserData();
            controller.inicializa();
            sangriaForm.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel eftuar sangria.");
        }
    }

    private void suprimentoCaixa() {
        try {
            Stage sangriaForm = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/financeiro/movimentoCaixa/SuprimentoForm.fxml", "SUPRIMENTO");
            MovimentoCaixaSuprimentoFormController controller = (MovimentoCaixaSuprimentoFormController)sangriaForm.getUserData();
            controller.inicializa();
            sangriaForm.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVVendedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel eftuar suprimento.");
        }
    }

    private void formataCampos() {
        this.comboTipoPedido.setCellFactory((Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private /* synthetic */ void lambda$sincronizaPDV$0(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Sincroniza\u00e7\u00e3o realizada com sucesso.");
            this.inicializaForm(this.scene);
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ SincronizacaoPdvService access$000(PDVVendedorFormController x0) {
        return x0.sincronizacaoPdvService;
    }
}

