/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.controller.AutorizacaoController;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDescontoException;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.DescontoFormController;
import br.com.maximasolutions.estoque.controller.PDVFechamentoFormController;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PedidoFaturamentoFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private CondicaoRecebimentoService condicaoRecebimentoService;
    @Autowired
    private PedidoService pedidoService;
    private Pedido pedido;
    private ObservableList<VendaProdutoFaturamento> faturamentoList;
    private List<VendaProdutoFaturamento> recebimentos;
    @FXML
    private TableView<VendaProdutoFaturamento> tabela;
    @FXML
    private TableColumn<VendaProdutoFaturamento, String> colCondicaoRecebimento;
    @FXML
    private TableColumn<VendaProdutoFaturamento, BigDecimal> colValor;
    @FXML
    private TextField tfVendedor;
    @FXML
    private TextField tfCliente;
    @FXML
    private TextField tfClienteVale;
    @FXML
    private TextField tfDataVenda;
    @FXML
    private TextField tfValorProdutos;
    @FXML
    private TextField tfValorFrete;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfValorRecebimento;
    @FXML
    private TextField tfValorRecebido;
    @FXML
    private TextField tfValorRestante;
    @FXML
    private TextField tfValorTroco;
    @FXML
    private TextField tfObservacao;
    @FXML
    private ComboBox<CondicaoRecebimento> cbbCondicaoRecebimento;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnAddRecebimento;
    @FXML
    private Button btnDesconto;
    private Configuracao conf;
    private VendaProduto vendaProduto;

    public void initialize(URL location, ResourceBundle resources) {
        this.conf = this.configuracaoService.load();
        this.stageManager.getStage().setUserData((Object)this);
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.carregaMascaras();
        this.setColumnProperties();
    }

    public VendaProduto getVendaProduto() {
        return this.vendaProduto;
    }

    private void closeWindowEvent(WindowEvent event) {
    }

    public void inicializaPedido(Pedido pedido1) {
        this.recebimentos = new ArrayList();
        this.pedido = pedido1;
        this.carregaValores();
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
    }

    private void finalizaFaturamento() {
        BigDecimal valorRestante = MaximaNumber.moneyToBigDecimal((String)this.tfValorRestante.getText());
        if (valorRestante == null || valorRestante.compareTo(BigDecimal.ZERO) > 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"O valor recebido n\u00e3o \u00e9 suficiente para finalizar o faturamento.");
            return;
        }
        try {
            this.vendaProduto = this.vendaProdutoService.fechamentoPDV(this.pedido, this.pedido.getCliente(), this.recebimentos, MaximaNumber.moneyToBigDecimal((String)this.tfValorTroco.getText()));
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Pedido faturado com sucesso.");
            Stage stage = (Stage)this.btnSalva.getScene().getWindow();
            stage.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoFaturamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    public void carregaValores() {
        if (this.pedido.getVendedor() != null) {
            this.tfVendedor.setText(this.pedido.getVendedor().getNome());
        }
        this.tfCliente.setText(this.pedido.getCliente().getNome());
        this.tfClienteVale.setText(MaximaNumber.formataNumero((BigDecimal)this.pedido.getCliente().getVale()));
        this.tfDataVenda.setText(MaximaDate.getData((LocalDate)this.pedido.getDataEmissao()));
        this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getValorProdutos(), (int)2));
        this.tfValorFrete.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getFrete(), (int)2));
        this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getDesconto(), (int)2));
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getTotal(), (int)2));
        this.tfValorRecebido.setText("0,00");
        this.tfValorRestante.setText(this.tfValorTotal.getText());
        this.tfValorTroco.setText("0,00");
        this.reiniciaRecebimento();
        this.loadFaturamento();
    }

    private void desconto() {
        try {
            Stage formDesconto = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.btnDesconto.getScene().getWindow(), "/fxml/estoque/vendaProduto/DescontoForm.fxml", "");
            DescontoFormController controller = (DescontoFormController)formDesconto.getUserData();
            BigDecimal percentual = this.pedido.getDesconto().multiply(new BigDecimal(100)).divide(this.pedido.getValorProdutos(), 2, RoundingMode.HALF_EVEN);
            controller.inicializa(this.pedido.getValorProdutos(), percentual, this.pedido.getDesconto());
            formDesconto.showAndWait();
            BigDecimal valorDesconto = controller.getDesconto();
            BigDecimal percentualDesconto = valorDesconto.multiply(new BigDecimal(100)).divide(this.pedido.getValorProdutos(), 2, RoundingMode.HALF_EVEN);
            BigDecimal descontoPermitido = this.configuracaoService.load().getDescontoAtualPermitido();
            boolean permissao = false;
            if (percentualDesconto.compareTo(descontoPermitido) > 0) {
                permissao = new AutorizacaoController().solicitarAutorizacao(this.stageManager, (Stage)this.btnDesconto.getScene().getWindow());
            }
            this.pedido = this.pedidoService.atualizaDesconto(this.pedido, valorDesconto, Boolean.valueOf(permissao));
            this.carregaValores();
            this.cbbCondicaoRecebimento.requestFocus();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Erro ao abrir desconto.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
        catch (MaximaDescontoException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void addRecebimento() {
        boolean valido = true;
        CondicaoRecebimento condicaoRecebimento = (CondicaoRecebimento)this.cbbCondicaoRecebimento.getSelectionModel().getSelectedItem();
        if (condicaoRecebimento == null) {
            this.cbbCondicaoRecebimento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbCondicaoRecebimento.getStyleClass().remove((Object)"error");
        }
        BigDecimal valor = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebimento.getText());
        if (valor == null || valor.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfValorRecebimento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfValorRecebimento.getStyleClass().remove((Object)"error");
        }
        if (!valido) {
            return;
        }
        BigDecimal valorRestante = MaximaNumber.moneyToBigDecimal((String)this.tfValorRestante.getText());
        BigDecimal valorTroco = BigDecimal.ZERO;
        if (valor.compareTo(valorRestante) > 0) {
            if (!condicaoRecebimento.getPermiteTroco().booleanValue() || condicaoRecebimento.getParcelas() > 1) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Essa forma de recebimento n\u00e3o permite troco.");
                return;
            }
            valorTroco = valor.subtract(valorRestante);
        }
        VendaProdutoFaturamento faturamento = new VendaProdutoFaturamento();
        faturamento.setCondicaoRecebimento(condicaoRecebimento);
        faturamento.setDataEmissao(LocalDateTime.now());
        faturamento.setDataEntrada(LocalDate.now());
        faturamento.setValor(valor);
        faturamento.setValorTroco(valorTroco);
        faturamento.setHistorico(MaximaUtils.getText((String)this.tfObservacao.getText()));
        if (this.recebimentos == null) {
            this.recebimentos = new ArrayList();
        }
        faturamento.setNumItem(Integer.valueOf(this.recebimentos.size() + 1));
        this.recebimentos.add(faturamento);
        this.reiniciaRecebimento();
        this.loadFaturamento();
    }

    private void reiniciaRecebimento() {
        this.cbbCondicaoRecebimento.getSelectionModel().select(null);
        this.tfValorRecebimento.setText("");
        this.tfObservacao.setText("");
        this.cbbCondicaoRecebimento.requestFocus();
    }

    private void deleteItem() {
        VendaProdutoFaturamento selecionado = (VendaProdutoFaturamento)this.tabela.getSelectionModel().getSelectedItem();
        if (selecionado == null) {
            return;
        }
        int count = 0;
        for (VendaProdutoFaturamento fat : this.recebimentos) {
            if (fat.getNumItem().equals(selecionado.getNumItem())) {
                this.recebimentos.remove(count);
                break;
            }
            ++count;
        }
        this.loadFaturamento();
    }

    private void registraAcoes() {
        this.btnDesconto.setOnAction(evt -> this.desconto());
        this.btnAddRecebimento.setOnAction(evt -> this.addRecebimento());
        this.btnSalva.setOnAction(evt -> this.finalizaFaturamento());
        this.tabela.setContextMenu(this.getTableMenu());
        this.tabela.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.DELETE) {
                this.deleteItem();
            }
        });
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem());
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void loadFaturamento() {
        this.faturamentoList = FXCollections.observableArrayList();
        this.faturamentoList.clear();
        BigDecimal totalRecebimento = BigDecimal.ZERO;
        if (this.recebimentos != null) {
            this.faturamentoList.addAll((Collection)this.recebimentos);
            for (VendaProdutoFaturamento fat : this.recebimentos) {
                totalRecebimento = totalRecebimento.add(fat.getValor());
            }
        }
        this.tabela.setItems(this.faturamentoList);
        this.tfValorRecebido.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalRecebimento, (int)2));
        BigDecimal totalRestante = this.pedido.getTotal().subtract(totalRecebimento);
        BigDecimal troco = BigDecimal.ZERO;
        if (totalRestante.compareTo(BigDecimal.ZERO) < 0) {
            troco = totalRecebimento.subtract(this.pedido.getTotal());
            totalRestante = BigDecimal.ZERO;
        }
        this.tfValorRestante.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalRestante, (int)2));
        this.tfValorTroco.setText(MaximaNumber.bigDecimalToString((BigDecimal)troco, (int)2));
    }

    private void setColumnProperties() {
        this.colCondicaoRecebimento.setCellValueFactory((Callback)new PropertyValueFactory("condicaoRecebimento"));
        this.colValor.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colValor.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnSalva.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnAddRecebimento.setGraphic((Node)maximaIcone.getIconeNovo());
    }

    private void carregaCombos() {
        List condicaoRecebimentos = this.condicaoRecebimentoService.list();
        this.cbbCondicaoRecebimento.setItems(FXCollections.observableArrayList((Collection)condicaoRecebimentos));
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValorProdutos);
        MaximaMask.monetaryField((TextField)this.tfValorFrete);
        MaximaMask.monetaryField((TextField)this.tfValorDesconto);
        MaximaMask.monetaryField((TextField)this.tfValorTotal);
        MaximaMask.monetaryField((TextField)this.tfValorRecebimento);
        MaximaMask.monetaryField((TextField)this.tfValorRecebido);
        MaximaMask.monetaryField((TextField)this.tfValorRestante);
        MaximaMask.monetaryField((TextField)this.tfValorTroco);
    }
}

