/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.geral.controller.VendedorPesquisaController;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PedidoItemEditaFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfProduto;
    @FXML
    private TextField tfValorUnitario;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfDesconto;
    @FXML
    private TextField tfTotalItem;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TextField tfVendedorPesquisa;
    @FXML
    private TextField tfVendedorNome;
    @FXML
    private TextField tfFrete;
    @FXML
    private TextField tfDescontoP;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnVendedorPesquisa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private PedidoItem pedidoItem;
    private Vendedor vendedor;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    public void inicializa(PedidoItem pedidoItem1) {
        Configuracao conf = this.configuracaoService.load();
        if (conf.getBloqueaPrecoVenda().booleanValue()) {
            this.tfValorUnitario.setDisable(true);
        }
        this.pedidoItem = pedidoItem1;
        this.vendedor = pedidoItem1.getVendedor();
        this.loadDadosVendedor();
        this.tfProduto.setText(this.pedidoItem.getDescricao());
        this.tfValorUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedidoItem.getPrecoUnitario(), (int)2));
        this.tfQuantidade.setText(this.pedidoItem.getQuantidade().toString());
        this.tfDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedidoItem.getDesconto(), (int)2));
        this.tfTotalItem.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedidoItem.getPrecoTotal(), (int)2));
        this.tfObservacao.setText(this.pedidoItem.getObservacao());
        this.calculaPercentualDescontoItem();
        this.tfQuantidade.requestFocus();
        this.tfQuantidade.selectAll();
    }

    private void calculaPercentualDescontoItem() {
        BigDecimal descontoPerc = BigDecimal.ZERO;
        BigDecimal descontoItem = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        if (descontoItem != null && descontoItem.compareTo(BigDecimal.ZERO) > 0) {
            descontoPerc = descontoItem.multiply(new BigDecimal("100")).divide(this.pedidoItem.getPrecoTotal(), 2, RoundingMode.HALF_UP);
        }
        this.tfDescontoP.setText(MaximaNumber.bigDecimalToString((BigDecimal)descontoPerc, (int)2));
    }

    private void confirma() {
        try {
            this.pedidoService.editaItem(this.pedidoItem, this.vendedor, MaximaNumber.moneyToBigDecimal((String)this.tfValorUnitario.getText()), MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText()), MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText()), MaximaNumber.moneyToBigDecimal((String)this.tfFrete.getText()), MaximaUtils.getText((String)this.tfObservacao.getText()));
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Item editado com sucesso.");
            Stage form = (Stage)this.btnSalva.getScene().getWindow();
            form.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PedidoItemEditaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void calculaTotal() {
        BigDecimal frete;
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        BigDecimal desconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        if (desconto == null) {
            desconto = BigDecimal.ZERO;
        }
        if ((frete = MaximaNumber.moneyToBigDecimal((String)this.tfFrete.getText())) == null) {
            frete = BigDecimal.ZERO;
        }
        BigDecimal totalItem = this.pedidoItem.getPrecoUnitario().multiply(quantidade).subtract(desconto).add(frete).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalItem.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalItem, (int)2));
    }

    private boolean validaForm(String codigoVenda) {
        boolean valido = true;
        return valido;
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfFrete);
        MaximaMask.monetaryField((TextField)this.tfDesconto);
        MaximaMask.monetaryField((TextField)this.tfValorUnitario);
        MaximaMask.monetaryField((TextField)this.tfDescontoP);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.confirma());
        this.btnSalva.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
        this.tfQuantidade.setOnKeyReleased(evt -> this.calculaTotal());
        this.tfDescontoP.setOnKeyReleased(evt -> {
            BigDecimal descontoP = MaximaNumber.moneyToBigDecimal((String)this.tfDescontoP.getText());
            BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
            BigDecimal frete = MaximaNumber.moneyToBigDecimal((String)this.tfFrete.getText());
            if (frete == null) {
                frete = BigDecimal.ZERO;
            }
            BigDecimal totalItem = this.pedidoItem.getPrecoUnitario().multiply(quantidade).add(frete).setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal desc = MaximaNumber.calculaPercentual((BigDecimal)totalItem, (BigDecimal)descontoP);
            this.tfDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)desc, (int)2));
            this.calculaTotal();
        });
        this.tfDesconto.setOnKeyReleased(evt -> {
            this.calculaTotal();
            this.calculaPercentualDescontoItem();
        });
        this.tfFrete.setOnKeyReleased(evt -> this.calculaTotal());
        this.tfQuantidade.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.tfDesconto.requestFocus();
                this.tfDesconto.selectAll();
            }
        });
        this.tfDesconto.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.tfFrete.requestFocus();
                this.tfFrete.selectAll();
            }
        });
        this.tfFrete.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.tfObservacao.requestFocus();
                this.tfObservacao.selectAll();
            }
        });
        this.tfObservacao.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.btnSalva.requestFocus();
            }
        });
        this.tfVendedorPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaVendedor();
            }
        });
        this.btnVendedorPesquisa.setOnAction(event -> this.pesquisaVendedorForm());
    }

    private void pesquisaVendedor() {
        String vendedorCodigo = this.tfVendedorPesquisa.getText().trim();
        if (vendedorCodigo.isEmpty()) {
            return;
        }
        try {
            Long vendedorCodigoNumero = Long.valueOf(vendedorCodigo);
            Vendedor vendedorPesquisa = this.vendedorService.load(vendedorCodigoNumero.longValue());
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
            } else {
                this.vendedor = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de vendedor n\u00e3o encontrado.");
                this.tfVendedorPesquisa.requestFocus();
                this.tfVendedorPesquisa.selectAll();
            }
            this.loadDadosVendedor();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaVendedorForm();
            return;
        }
    }

    private void pesquisaVendedorForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/vendedor/VendedorPesquisa.fxml", "Pesquisa de vendedor");
            VendedorPesquisaController controller = (VendedorPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfVendedorPesquisa.getText().trim());
            stage.showAndWait();
            Vendedor vendedorPesquisa = controller.getVendedorSelecionado();
            if (vendedorPesquisa != null) {
                this.vendedor = vendedorPesquisa;
                this.loadDadosVendedor();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'VendedorPesquisa'");
        }
    }

    private void loadDadosVendedor() {
        if (this.vendedor != null) {
            this.tfVendedorPesquisa.setText(this.vendedor.getId().toString());
            this.tfVendedorNome.setText(this.vendedor.getNome().toUpperCase());
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
        } else {
            this.tfVendedorNome.setText("");
            this.tfVendedorPesquisa.setText("");
            this.tfVendedorPesquisa.requestFocus();
        }
    }
}

