/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.VendaProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PedidoVendaAbreFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfCodigoVenda;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnPesquisa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    private VendaProduto vendaProduto;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.vendaProduto = null;
        this.tfCodigoVenda.setText("");
        this.tfCodigoVenda.requestFocus();
    }

    public VendaProduto getVendaProduto() {
        return this.vendaProduto;
    }

    private void confirma() {
        Long codigo;
        String codigoVenda = MaximaUtils.getText((String)this.tfCodigoVenda.getText());
        if (!this.validaForm(codigoVenda)) {
            return;
        }
        try {
            codigo = Long.parseLong(codigoVenda);
        }
        catch (NumberFormatException numberFormatException) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo informado inv\u00e1ildo.");
            return;
        }
        this.vendaProduto = this.vendaProdutoService.getById(codigo);
        if (this.vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido de Venda n\u00e3o encontrado.");
            this.tfCodigoVenda.requestFocus();
            this.tfCodigoVenda.selectAll();
            return;
        }
        if (this.vendaProduto.isExcluida().booleanValue() || !this.vendaProduto.isAtivo().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido de Venda exclu\u00eddo. N\u00e3o pode ser alterado.");
            this.tfCodigoVenda.requestFocus();
            this.tfCodigoVenda.selectAll();
            this.vendaProduto = null;
            return;
        }
        if (this.vendaProduto.isFaturado().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido de Venda j\u00e1 faturado. N\u00e3o pode ser alterado.");
            this.tfCodigoVenda.requestFocus();
            this.tfCodigoVenda.selectAll();
            this.vendaProduto = null;
            return;
        }
        Stage form = (Stage)this.btnPesquisa.getScene().getWindow();
        form.close();
    }

    private void pesquisa() {
        try {
            Stage formPesquisa = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/vendaProduto/VendaProdutoPesquisa.fxml", "Pesquisar venda");
            VendaProdutoPesquisaController controller = (VendaProdutoPesquisaController)formPesquisa.getUserData();
            controller.inicializa(Boolean.valueOf(false));
            formPesquisa.showAndWait();
            VendaProduto selecionada = controller.getVendaProduto();
            if (selecionada == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum pedido foi selecionado.");
                return;
            }
            this.vendaProduto = this.vendaProdutoService.getById(selecionada.getId());
            if (this.vendaProduto == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido de Venda n\u00e3o encontrado.");
                this.tfCodigoVenda.requestFocus();
                this.tfCodigoVenda.selectAll();
                return;
            }
            if (this.vendaProduto.isExcluida().booleanValue() || !this.vendaProduto.isAtivo().booleanValue()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido de Venda exclu\u00eddo. N\u00e3o pode ser alterado.");
                this.tfCodigoVenda.requestFocus();
                this.tfCodigoVenda.selectAll();
                this.vendaProduto = null;
                return;
            }
            if (this.vendaProduto.isFaturado().booleanValue()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Pedido de Venda j\u00e1 faturado. N\u00e3o pode ser alterado.");
                this.tfCodigoVenda.requestFocus();
                this.tfCodigoVenda.selectAll();
                this.vendaProduto = null;
                return;
            }
            Stage form = (Stage)this.btnPesquisa.getScene().getWindow();
            form.close();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaAbreFormController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir a pesquisa de vendas.");
        }
    }

    private boolean validaForm(String codigoVenda) {
        boolean valido = true;
        if (codigoVenda == null || codigoVenda.isEmpty()) {
            this.tfCodigoVenda.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCodigoVenda.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.confirma());
        this.btnPesquisa.setOnAction(event -> this.pesquisa());
        this.btnSalva.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
        this.tfCodigoVenda.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
    }
}

