/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoComposicao;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoComboItemFormController
extends MaximaController
implements Initializable {
    private ProdutoComposicao produtoComposicao;
    private Produto produto;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private UnidadeService unidadeService;
    @FXML
    private TextField tfId;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private ComboBox<Unidade> cbUnidade;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfCustoUnitario;
    @FXML
    private TextField tfCustoTotal;
    @FXML
    private TextField tfVendaUnitario;
    @FXML
    private TextField tfVendaTotal;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoNome;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public void inicializa(ProdutoComposicao produtoComposicao) {
        this.produto = null;
        this.produtoComposicao = produtoComposicao;
        if (this.produtoComposicao != null) {
            this.produto = this.produtoComposicao.getSubProduto();
        }
    }

    public ProdutoComposicao getProdutoComposicao() {
        return this.produtoComposicao;
    }

    private void salva() {
        this.get();
        if (!this.validaForm()) {
            return;
        }
        this.fechaForm();
    }

    private void get() {
        if (this.produtoComposicao == null || this.produtoComposicao.getId() == null) {
            this.produtoComposicao = new ProdutoComposicao();
        }
        this.produtoComposicao.setCusto(MaximaNumber.moneyToBigDecimal((String)this.tfCustoTotal.getText()));
        this.produtoComposicao.setQuantidade(MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText()));
        this.produtoComposicao.setSubProduto(this.produto);
        this.produtoComposicao.setUnidade((Unidade)this.cbUnidade.getSelectionModel().getSelectedItem());
        this.produtoComposicao.setValorUnitario(MaximaNumber.moneyToBigDecimal((String)this.tfVendaUnitario.getText()));
        this.produtoComposicao.setValorTotal(MaximaNumber.moneyToBigDecimal((String)this.tfVendaTotal.getText()));
    }

    private void calculaPrecoVenda() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfVendaTotal.setText("0,00");
            return;
        }
        BigDecimal vendaUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfVendaUnitario.getText());
        if (vendaUnitario == null || vendaUnitario.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfVendaTotal.setText("0,00");
            return;
        }
        BigDecimal vendaTotal = vendaUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfVendaTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)vendaTotal, (int)2));
    }

    private void calculaPrecoCusto() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfVendaTotal.setText("0,00");
            return;
        }
        BigDecimal custoUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfCustoUnitario.getText());
        if (custoUnitario == null || custoUnitario.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfVendaTotal.setText("0,00");
            return;
        }
        BigDecimal custoTotal = custoUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfCustoTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)custoTotal, (int)2));
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.produtoComposicao.getQuantidade() == null || this.produtoComposicao.getQuantidade().compareTo(BigDecimal.ZERO) <= 0) {
            this.tfQuantidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfQuantidade.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfVendaUnitario);
        MaximaMask.monetaryField((TextField)this.tfVendaTotal);
        MaximaMask.monetaryField((TextField)this.tfCustoUnitario);
        MaximaMask.monetaryField((TextField)this.tfCustoTotal);
    }

    private void loadCombos() {
        this.cbUnidade.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnProdutoPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(t -> this.salva());
        this.tfQuantidade.setOnKeyReleased(evt -> {
            this.calculaPrecoVenda();
            this.calculaPrecoCusto();
        });
        this.tfVendaUnitario.setOnKeyReleased(evt -> this.calculaPrecoVenda());
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaProduto();
            }
        });
        this.btnProdutoPesquisa.setOnAction(event -> this.pesquisaProdutoForm());
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoNome.setText(this.produto.getNome().toUpperCase());
            this.tfCustoUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getUltimoCusto(), (int)2));
            this.cbUnidade.requestFocus();
        } else {
            this.tfProdutoNome.setText("");
            this.tfProdutoPesquisa.setText("");
            this.tfQuantidade.setText("");
            this.tfCustoUnitario.setText("");
            this.tfCustoTotal.setText("");
            this.tfVendaUnitario.setText("");
            this.tfVendaTotal.setText("");
            this.tfProdutoPesquisa.requestFocus();
        }
        this.calculaPrecoCusto();
        this.calculaPrecoVenda();
    }

    private void fechaForm() {
        Stage stage = (Stage)this.tfId.getScene().getWindow();
        stage.close();
    }
}

