/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.ProdutoObservacao;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoObservacaoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoObservacaoFormController
extends MaximaController
implements Initializable {
    private ProdutoObservacao produtoObservacao;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoObservacaoService produtoObservacaoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @Autowired
    private UnidadeService unidadeService;
    @FXML
    private TextField tfId;
    @FXML
    private CheckBox cbAtivo;
    @FXML
    private ComboBox<CategoriaProduto> cbCategoria;
    @FXML
    private Button btnCategoriaProdutoAdd;
    @FXML
    private Button btnSalva;
    @FXML
    private ComboBox<Unidade> cbUnidade;
    @FXML
    private TextField tfNome;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    @FXML
    private void onSalva(ActionEvent event) {
        String mensagem;
        this.produtoObservacao = this.getProdutoObservacao();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.produtoObservacao, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return;
        }
        if (this.produtoObservacao.getId() == null) {
            this.produtoObservacaoService.save((Object)this.produtoObservacao);
            mensagem = "Observa\u00e7\u00e3o adicionada com sucesso.";
        } else {
            this.produtoObservacaoService.update((Object)this.produtoObservacao);
            mensagem = "Observa\u00e7\u00e3o alterada com sucesso.";
        }
        MaximaAlert.informe((StageManager)this.stageManager, (String)mensagem);
        Stage stage = (Stage)this.tfNome.getScene().getWindow();
        stage.close();
    }

    private ProdutoObservacao getProdutoObservacao() {
        if (this.produtoObservacao == null) {
            this.produtoObservacao = new ProdutoObservacao();
        }
        this.produtoObservacao.setNome(this.tfNome.getText().trim());
        this.produtoObservacao.setAtivo(Boolean.valueOf(this.cbAtivo.isSelected()));
        this.produtoObservacao.setCategoriaProduto((CategoriaProduto)this.cbCategoria.getSelectionModel().getSelectedItem());
        this.produtoObservacao.setUnidade((Unidade)this.cbUnidade.getSelectionModel().getSelectedItem());
        return this.produtoObservacao;
    }

    public void setProdutoObservacao(ProdutoObservacao pc) {
        this.produtoObservacao = pc;
        if (this.produtoObservacao != null) {
            this.tfId.setText(this.produtoObservacao.getId().toString());
            this.cbAtivo.setSelected(this.produtoObservacao.getAtivo().booleanValue());
            this.tfNome.setText(this.produtoObservacao.getNome());
            this.cbCategoria.getSelectionModel().select((Object)this.produtoObservacao.getCategoriaProduto());
            this.cbUnidade.getSelectionModel().select((Object)this.produtoObservacao.getUnidade());
            this.tfNome.requestFocus();
        }
    }

    private void setMascaras() {
    }

    private void loadCombos() {
        this.cbCategoria.setItems(FXCollections.observableArrayList((Collection)this.categoriaProdutoService.list()));
        this.cbUnidade.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnCategoriaProdutoAdd.setGraphic((Node)new MaximaIcone().getIconeNovo());
    }

    private void registraAcoes() {
    }
}

