/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.ProdutoService;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoOrdenaFormController
extends MaximaController
implements Initializable {
    @FXML
    private ListView<Produto> listView;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnSubir;
    @FXML
    private Button btnDescer;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    private List<Produto> produtos;

    public void initialize(URL url, ResourceBundle rb) {
    }

    public void inicializa() {
        this.produtos = this.produtoService.getListaOrdenada();
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    private void salva() {
        try {
            this.produtoService.salvaListaOrdenada((List)this.listView.getItems());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Ordena\u00e7\u00e3o salva com sucesso.");
            this.fecharForm();
        }
        catch (MaximaException ex) {
            Logger.getLogger(ProdutoOrdenaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel salvar lista ordenada.");
        }
    }

    private void subir() {
        Produto produto = (Produto)this.listView.getSelectionModel().getSelectedItem();
        if (produto == null) {
            return;
        }
        int posicao = this.listView.getSelectionModel().getSelectedIndex();
        if (posicao == 0) {
            return;
        }
        Produto produtoTroca = (Produto)this.produtos.get(posicao - 1);
        this.produtos.set(posicao, produtoTroca);
        this.produtos.set(posicao - 1, produto);
        this.listView.scrollTo(posicao - 1);
        this.carregaCombos();
    }

    private void descer() {
        Produto produto = (Produto)this.listView.getSelectionModel().getSelectedItem();
        if (produto == null) {
            return;
        }
        int posicao = this.listView.getSelectionModel().getSelectedIndex();
        if (posicao == this.produtos.size() - 1) {
            return;
        }
        Produto produtoTroca = (Produto)this.produtos.get(posicao + 1);
        this.produtos.set(posicao, produtoTroca);
        this.produtos.set(posicao + 1, produto);
        this.listView.scrollTo(posicao + 1);
        this.carregaCombos();
    }

    private void carregaCombos() {
        this.listView.setItems(FXCollections.observableArrayList((Collection)this.produtos));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnSubir.setOnAction(evt -> this.subir());
        this.btnDescer.setOnAction(evt -> this.descer());
    }

    private void fecharForm() {
        Stage form = (Stage)this.btnSalva.getScene().getWindow();
        form.close();
    }
}

