/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoController;
import br.com.maximasolutions.estoque.controller.ProdutoFormController;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoPesquisaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnSelecionar;
    @FXML
    private Button btnCadastrar;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Produto> tabela;
    @FXML
    private TableColumn<Produto, String> colCodigo;
    @FXML
    private TableColumn<Produto, String> colDescricao;
    @FXML
    private TableColumn<Produto, String> colCategoria;
    @FXML
    private TableColumn<Produto, String> colUnidade;
    @FXML
    private TableColumn<Produto, BigDecimal> colEstoque;
    @FXML
    private TableColumn<Produto, BigDecimal> colPrecoUnitario;
    @FXML
    private ComboBox<CategoriaProduto> cbbCategoriaProduto;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private CheckBox ccbEstoquePositivo;
    @FXML
    private CheckBox ccbServico;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    private ObservableList<Produto> produtoList;
    private Produto produtoSelecionado;

    public void initialize(URL url, ResourceBundle rb) {
        this.produtoSelecionado = null;
        this.carregaIcones();
        this.produtoList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
    }

    public void inicializa() {
        this.btnCadastrar.setDisable(true);
        this.carregaCombo();
        this.produtoSelecionado = null;
    }

    public void setEnableCadastrarProduto() {
        this.btnCadastrar.setDisable(false);
    }

    public Produto getProdutoSelecionado() {
        return this.produtoSelecionado;
    }

    public void setValorPesquisa(String valor) {
        this.tfPesquisa.setText(valor);
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
        if (valor != null && !valor.isEmpty()) {
            this.loadTabela();
        }
    }

    private void seleciona() {
        this.produtoSelecionado = (Produto)this.tabela.getSelectionModel().getSelectedItem();
        if (this.produtoSelecionado == null) {
            MaximaAlert.alerta((String)"Selecione um produto para continuar.");
            return;
        }
        this.fechaForm();
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.produtoList.clear();
        List list = this.produtoService.pesquisa((CategoriaProduto)this.cbbCategoriaProduto.getSelectionModel().getSelectedItem(), Boolean.valueOf(this.ccbAtivo.isSelected()), Boolean.valueOf(this.ccbEstoquePositivo.isSelected()), Boolean.valueOf(this.ccbServico.isSelected()), valorPesquisa);
        this.produtoList.addAll((Collection)list);
        this.tabela.setItems(this.produtoList);
    }

    private void carregaIcones() {
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
        this.btnSelecionar.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colCategoria.setCellValueFactory((Callback)new PropertyValueFactory("categoriaProduto"));
        this.colDescricao.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colUnidade.setCellValueFactory((Callback)new PropertyValueFactory("unidade"));
        this.colEstoque.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAtual"));
        this.colPrecoUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoVenda"));
        this.colEstoque.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colPrecoUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colDescricao.setCellFactory((Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void novoProduto() {
        this.formProduto(null);
        this.loadTabela();
    }

    private void formProduto(Produto produto) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoForm.fxml", "Cadastro Produto");
            ProdutoFormController controller = (ProdutoFormController)stage.getUserData();
            controller.inicializa(produto);
            stage.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void registraAcoes() {
        this.btnCadastrar.setOnAction(evt -> this.novoProduto());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
            if (event.getCode() == KeyCode.DOWN) {
                this.tabela.requestFocus();
            }
        });
        this.btnSelecionar.setOnAction(event -> this.seleciona());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.seleciona();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER && this.tabela.getSelectionModel().getSelectedItem() != null) {
                this.seleciona();
            }
        });
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnPesquisa.getScene().getWindow();
        stage.close();
    }

    private void carregaCombo() {
        ArrayList categorias = new ArrayList();
        categorias.add(null);
        categorias.addAll(this.categoriaProdutoService.list());
        this.cbbCategoriaProduto.setItems(FXCollections.observableArrayList(categorias));
    }
}

