/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.ProdutoController;
import br.com.maximasolutions.estoque.controller.ProdutoFormController;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.controller.ProdutoPorTamanhoItemFormController;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.UnidadeService;
import br.com.maximasolutions.fiscal.controller.FiscalProdutoPesquisaController;
import br.com.maximasolutions.fiscal.modelo.FiscalProduto;
import br.com.maximasolutions.fiscal.modelo.Ncm;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoPorTamanhoFormController
extends MaximaController
implements Initializable {
    private Produto produto;
    private List<Produto> subProdutosTamanho;
    private String produtoFoto;
    private Configuracao conf;
    @Lazy
    @Autowired
    StageManager stageManager;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabFiscal;
    @FXML
    private CheckBox cbAtivo;
    @FXML
    private CheckBox cbEstoqueNegativo;
    @FXML
    private CheckBox ccbBalanca;
    @FXML
    private CheckBox ccbAgrupar;
    @FXML
    private ComboBox<CategoriaProduto> cbCategoria;
    @FXML
    private ComboBox<Unidade> cbUnidade;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfCodigoBarras;
    @FXML
    private TextField tfCodigoInterno;
    @FXML
    private TextField tfPrecoCusto;
    @FXML
    private TextField tfPrecoVenda;
    @FXML
    private TextField tfCodigoNcm;
    @FXML
    private TextField tfCodigoCest;
    @FXML
    private TextField tfCfopDentroEstado;
    @FXML
    private TextField tfCfopForaEstado;
    @FXML
    private TextField tfAliquotaCreditoIcms;
    @FXML
    private TextField tfAliquotaIVA;
    @FXML
    private TextField tfAliquotaPis;
    @FXML
    private TextField tfAliquotaCofins;
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private TextField tfDescricao2;
    @FXML
    private TextField tfEstoqueInicial;
    @FXML
    private TextField tfEstoqueAtual;
    @FXML
    private TextField tfEstoqueMinimo;
    @FXML
    private Button btnCategoriaProdutoAdd;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnCodigo;
    @FXML
    private Button btnImage;
    @FXML
    private Button btnTamanhoAdd;
    @FXML
    private Button btnDadosFiscais;
    @FXML
    private Button btnVIncularProduto;
    @FXML
    private ComboBox<NFOrigem> cbOrigem;
    @FXML
    private ComboBox<NFNotaSituacaoOperacionalSimplesNacional> cbCSOSN;
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaPIS> cbPis;
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaCOFINS> cbCofins;
    @FXML
    private ImageView imagePrincipal;
    @FXML
    private TextArea txtComposicao;
    @FXML
    private TableView<Produto> tblProdutoTamanhos;
    @FXML
    private TableColumn<Produto, String> colTamanho;
    @FXML
    private TableColumn<Produto, BigDecimal> colEstoque;
    @FXML
    private TableColumn<Produto, BigDecimal> colValor;
    @Autowired
    CategoriaProdutoService categoriaProdutoService;
    @Autowired
    UnidadeService unidadeService;
    @Autowired
    NcmService ncmService;
    @Autowired
    ProdutoService produtoService;
    @Autowired
    ConfiguracaoService configuracaoService;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
        this.setColumnProperties();
    }

    public void inicializa() {
        this.subProdutosTamanho = new ArrayList();
        this.conf = this.configuracaoService.load();
        this.ccbAgrupar.setSelected(true);
    }

    public void inicializa(Produto produto1) {
        this.subProdutosTamanho = new ArrayList();
        this.produto = produto1;
        if (this.produto != null) {
            if (this.produto.getId() != null) {
                this.produto = this.produtoService.getById(this.produto.getId().longValue());
            }
            this.setProduto(this.produto);
            this.subProdutosTamanho = this.produtoService.listaProdutosTamanhos(this.produto);
        }
        this.loadTabela();
    }

    public void setProduto(Produto produto1) {
        this.produto = produto1;
        if (this.produto != null) {
            if (this.produto.getId() != null) {
                this.tfId.setText(this.produto.getId().toString());
            }
            this.cbAtivo.setSelected(this.produto.isAtivo().booleanValue());
            this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.produto.getUltimaAlteracao()));
            this.tfNome.setText(this.produto.getNome());
            this.cbCategoria.getSelectionModel().select((Object)this.produto.getCategoriaProduto());
            this.cbUnidade.getSelectionModel().select((Object)this.produto.getUnidade());
            this.cbEstoqueNegativo.setSelected(this.produto.isEstoqueNegativo().booleanValue());
            this.tfCodigoBarras.setText(this.produto.getCodigo());
            this.tfCodigoInterno.setText(this.produto.getReferencia());
            this.tfCodigoNcm.setText(this.produto.getNcm());
            this.tfCodigoCest.setText(this.produto.getCest());
            this.tfCfopDentroEstado.setText(this.produto.getCfop());
            this.tfCfopForaEstado.setText(this.produto.getCfopInterEstad());
            this.cbOrigem.getSelectionModel().select((Object)this.produto.getOrigem());
            this.cbCSOSN.getSelectionModel().select((Object)this.produto.getIcmsSN());
            this.cbPis.getSelectionModel().select((Object)this.produto.getPis());
            this.cbCofins.getSelectionModel().select((Object)this.produto.getCofins());
            this.tfAliquotaCreditoIcms.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getAliquotaCreditoICMS(), (int)2));
            this.tfAliquotaIVA.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getAliquotaIVA(), (int)2));
            this.tfAliquotaPis.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getAliquotaPis(), (int)2));
            this.tfAliquotaCofins.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getAliquotaCofins(), (int)2));
            this.ccbBalanca.setSelected(this.produto.getBalanca().booleanValue());
            this.ccbAgrupar.setSelected(this.produto.getAgrupar().booleanValue());
            this.txtComposicao.setText(this.produto.getComposicao());
            String foto = this.produto.getFotoPrincipal() == null || this.produto.getFotoPrincipal().isEmpty() ? "C:/Maxima/images/no-image.jpg" : this.produto.getFotoPrincipal();
            this.exibeImagem(foto);
            this.tfNome.requestFocus();
        }
        this.loadTabela();
    }

    private Produto getProduto() {
        if (this.produto == null) {
            this.produto = new Produto();
        }
        this.produto.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.produto.setObservacao(MaximaUtils.getText((String)this.tfDescricao2.getText()));
        this.produto.setAtivo(Boolean.valueOf(this.cbAtivo.isSelected()));
        this.produto.setEstoqueNegativo(Boolean.valueOf(this.cbEstoqueNegativo.isSelected()));
        this.produto.setCategoriaProduto((CategoriaProduto)this.cbCategoria.getSelectionModel().getSelectedItem());
        this.produto.setUnidade((Unidade)this.cbUnidade.getSelectionModel().getSelectedItem());
        this.produto.setCodigo(MaximaUtils.getText((String)this.tfCodigoBarras.getText()));
        this.produto.setReferencia(MaximaUtils.getText((String)this.tfCodigoInterno.getText()));
        this.produto.setUltimoCusto(BigDecimal.ZERO);
        this.produto.setPrecoVenda(BigDecimal.ZERO);
        this.produto.setNcm(MaximaUtils.getText((String)this.tfCodigoNcm.getText()));
        this.produto.setCest(MaximaUtils.getText((String)this.tfCodigoCest.getText()));
        this.produto.setCfop(MaximaUtils.getText((String)this.tfCfopDentroEstado.getText()));
        this.produto.setCfopInterEstad(MaximaUtils.getText((String)this.tfCfopForaEstado.getText()));
        this.produto.setOrigem((NFOrigem)this.cbOrigem.getSelectionModel().getSelectedItem());
        this.produto.setIcmsSN((NFNotaSituacaoOperacionalSimplesNacional)this.cbCSOSN.getSelectionModel().getSelectedItem());
        this.produto.setPis((NFNotaInfoSituacaoTributariaPIS)this.cbPis.getSelectionModel().getSelectedItem());
        this.produto.setCofins((NFNotaInfoSituacaoTributariaCOFINS)this.cbCofins.getSelectionModel().getSelectedItem());
        this.produto.setAliquotaCreditoICMS(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaCreditoIcms.getText()));
        this.produto.setAliquotaIVA(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaIVA.getText()));
        this.produto.setAliquotaPis(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaPis.getText()));
        this.produto.setAliquotaCofins(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaCofins.getText()));
        this.produto.setBalanca(Boolean.valueOf(this.ccbBalanca.isSelected()));
        this.produto.setAgrupar(Boolean.valueOf(this.ccbAgrupar.isSelected()));
        this.produto.setFotoPrincipal(this.produtoFoto);
        this.produto.setComposicao(MaximaUtils.getText((String)this.txtComposicao.getText()));
        this.produto.setEstoqueAtual(BigDecimal.ZERO);
        this.produto.setEstoqueInicial(BigDecimal.ZERO);
        this.produto.setEstoqueMinimo(BigDecimal.ZERO);
        this.produto.setPrecoVenda(BigDecimal.ZERO);
        this.produto.setUltimoCusto(BigDecimal.ZERO);
        this.produto.setFatorConversaoEntrada(BigDecimal.ZERO);
        this.produto.setDescontoPermitido(BigDecimal.ZERO);
        this.produto.setComissao(BigDecimal.ZERO);
        this.produto.setComposicao(null);
        boolean validarDadosFiscais = MaximaConfig.getInstance().getProperty("produto_fiscal", "s").equalsIgnoreCase("s");
        if (!validarDadosFiscais && (this.produto.getNcm() == null || this.produto.getNcm().isEmpty())) {
            this.produto.setNcm("0");
        }
        return this.produto;
    }

    private void exibeImagem(String foto) {
        try {
            FileInputStream stream = new FileInputStream(foto);
            Image image = new Image((InputStream)stream);
            this.imagePrincipal.setImage(image);
        }
        catch (FileNotFoundException ex) {
            System.out.println("== ERRO: Arquivo 'C:/Maxima/images/no-image.jpg' n\u00e3o encontrado.");
        }
    }

    private void loadCombos() {
        this.cbCategoria.setItems(FXCollections.observableArrayList((Collection)this.categoriaProdutoService.list()));
        this.cbUnidade.setItems(FXCollections.observableArrayList((Collection)this.unidadeService.list()));
        this.cbOrigem.setItems(FXCollections.observableArrayList((Object[])NFOrigem.values()));
        this.cbCSOSN.setItems(FXCollections.observableArrayList((Object[])NFNotaSituacaoOperacionalSimplesNacional.values()));
        this.cbPis.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoSituacaoTributariaPIS.values()));
        this.cbCofins.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoSituacaoTributariaCOFINS.values()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnCategoriaProdutoAdd.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnCodigo.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
        this.btnCodigo.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfAliquotaCreditoIcms);
        MaximaMask.monetaryField((TextField)this.tfAliquotaIVA);
        MaximaMask.monetaryField((TextField)this.tfAliquotaPis);
        MaximaMask.monetaryField((TextField)this.tfAliquotaCofins);
    }

    private void setColumnProperties() {
        this.colTamanho.setCellValueFactory((Callback)new PropertyValueFactory("categoriaProdutoTamanho"));
        this.colValor.setCellValueFactory((Callback)new PropertyValueFactory("precoVenda"));
        this.colEstoque.setCellValueFactory((Callback)new PropertyValueFactory("estoqueAtual"));
        ColumnNumberFormatter numberFormatter = new ColumnNumberFormatter();
        this.colEstoque.setCellFactory((Callback)numberFormatter);
        this.colValor.setStyle("-fx-alignment: CENTER-RIGHT;");
        this.colEstoque.setStyle("-fx-alignment: CENTER-RIGHT;");
    }

    private void loadTabela() {
        if (this.subProdutosTamanho != null) {
            this.subProdutosTamanho.forEach(obj -> System.out.println("preco: " + obj.getCodigo()));
            this.tblProdutoTamanhos.getItems().clear();
            this.tblProdutoTamanhos.setItems(FXCollections.observableArrayList((Collection)this.subProdutosTamanho));
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.produto.getNome() == null || this.produto.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        if (this.produto.getCategoriaProduto() == null) {
            this.cbCategoria.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbCategoria.getStyleClass().remove((Object)"error");
        }
        if (this.produto.getUnidade() == null) {
            this.cbUnidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbUnidade.getStyleClass().remove((Object)"error");
        }
        if (this.produto.getCodigo() == null || this.produto.getCodigo().isEmpty()) {
            this.tfCodigoBarras.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCodigoBarras.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (this.conf.getProdutoFiscal().booleanValue()) {
                if (this.produto.getNcm() == null || this.produto.getNcm().isEmpty()) {
                    this.tabPane.getSelectionModel().select((Object)this.tabFiscal);
                    this.tfCodigoNcm.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    try {
                        Ncm ncm = this.ncmService.loadByNCM(Long.parseLong(this.produto.getNcm()));
                        if (ncm == null) {
                            MaximaAlert.aviso((StageManager)this.stageManager, (String)"NCM informado n\u00e3o \u00e9 v\u00e1lido");
                            this.tfCodigoNcm.getStyleClass().add((Object)"error");
                            valido = false;
                        } else {
                            this.tfCodigoNcm.getStyleClass().remove((Object)"error");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        MaximaAlert.aviso((StageManager)this.stageManager, (String)"NCM informado n\u00e3o \u00e9 v\u00e1lido");
                        this.tfCodigoNcm.getStyleClass().add((Object)"error");
                    }
                    this.tfCodigoNcm.getStyleClass().remove((Object)"error");
                }
                if (this.produto.getCfop() == null || this.produto.getCfop().length() != 4) {
                    this.tfCfopDentroEstado.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.tfCfopDentroEstado.getStyleClass().remove((Object)"error");
                }
                if (this.produto.getOrigem() == null) {
                    this.cbOrigem.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.cbOrigem.getStyleClass().remove((Object)"error");
                }
                if (this.produto.getIcmsSN() == null) {
                    this.cbCSOSN.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.cbCSOSN.getStyleClass().remove((Object)"error");
                }
                if (this.produto.getPis() == null) {
                    this.cbPis.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.cbPis.getStyleClass().remove((Object)"error");
                }
                if (this.produto.getCofins() == null) {
                    this.cbCofins.getStyleClass().add((Object)"error");
                    valido = false;
                } else {
                    this.cbCofins.getStyleClass().remove((Object)"error");
                }
            } else if (this.produto.getNcm() == null || this.produto.getNcm().isEmpty()) {
                this.produto.setNcm("00000000");
            }
        }
        return valido;
    }

    private void fechaForm() {
        Stage stage = (Stage)this.tfNome.getScene().getWindow();
        stage.close();
    }

    private void salva() {
        String mensagemError = "";
        this.produto = this.getProduto();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.produto, new Class[0]);
        if (!this.validaForm()) {
            return;
        }
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return;
        }
        if (this.subProdutosTamanho.size() < 1) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Adicione um tamanho para o produto.");
            return;
        }
        for (Produto obj2 : this.subProdutosTamanho) {
            obj2.setObservacao(MaximaUtils.getText((String)this.produto.getObservacao()));
            obj2.setAtivo(this.produto.isAtivo());
            obj2.setEstoqueNegativo(this.produto.isEstoqueNegativo());
            obj2.setCategoriaProduto(this.produto.getCategoriaProduto());
            obj2.setUnidade(this.produto.getUnidade());
            obj2.setReferencia(this.produto.getReferencia());
            obj2.setNcm(this.produto.getNcm());
            obj2.setCest(this.produto.getCest());
            obj2.setCfop(this.produto.getCfop());
            obj2.setCfopInterEstad(this.produto.getCfopInterEstad());
            obj2.setOrigem(this.produto.getOrigem());
            obj2.setIcmsSN(this.produto.getIcmsSN());
            obj2.setPis(this.produto.getPis());
            obj2.setCofins(this.produto.getCofins());
            obj2.setAliquotaCreditoICMS(this.produto.getAliquotaCreditoICMS());
            obj2.setAliquotaIVA(this.produto.getAliquotaIVA());
            obj2.setAliquotaPis(this.produto.getAliquotaPis());
            obj2.setAliquotaCofins(this.produto.getAliquotaCofins());
            obj2.setBalanca(this.produto.getBalanca());
            obj2.setAgrupar(this.produto.getAgrupar());
            obj2.setFotoPrincipal(this.produto.getFotoPrincipal());
            obj2.setComposicao(this.produto.getComposicao());
        }
        try {
            this.produtoService.salva(this.produto, this.subProdutosTamanho);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Produto salvo com sucesso.");
            this.fechaForm();
        }
        catch (MaximaException ex) {
            Logger.getLogger(ProdutoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void vincularProdutoTamanho() {
        Produto produtoVinculado = null;
        try {
            Stage formPesquisa = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de Produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)formPesquisa.getUserData();
            formPesquisa.showAndWait();
            produtoVinculado = controller.getProdutoSelecionado();
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoPorTamanhoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo para vincular produto.");
        }
        if (produtoVinculado != null) {
            this.produto = this.getProduto();
            this.formTamanho(produtoVinculado, this.produto);
        }
    }

    private void formTamanho(Produto produto, Produto produtoPai) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPorTamanhoItemForm.fxml", "Adicionar Tamanhos");
            ProdutoPorTamanhoItemFormController controller = (ProdutoPorTamanhoItemFormController)stage.getUserData();
            controller.inicializa(produto, produtoPai);
            stage.showAndWait();
            Produto produtoAdicionado = controller.getProduto();
            if (produtoAdicionado != null) {
                System.out.println("=== produto adicionado id: " + produtoAdicionado.getId());
                boolean existeTamanho = false;
                for (Produto p : this.subProdutosTamanho) {
                    if (p.getCategoriaProdutoTamanho().getId() == produtoAdicionado.getCategoriaProdutoTamanho().getId()) {
                        if (produtoAdicionado.getId() != null && p.getId() != null) {
                            if (produtoAdicionado.getId() != p.getId()) {
                                existeTamanho = true;
                            }
                        } else {
                            existeTamanho = true;
                        }
                    }
                    if (!existeTamanho) continue;
                    p.setCodigo(produtoAdicionado.getCodigo());
                    p.setEstoqueAtual(produtoAdicionado.getEstoqueAtual());
                    p.setUltimoCusto(produtoAdicionado.getUltimoCusto());
                    p.setPrecoVenda(produtoAdicionado.getPrecoVenda());
                    break;
                }
                System.out.println("=== existe tamanho: " + existeTamanho);
                if (!existeTamanho) {
                    this.subProdutosTamanho.add(produtoAdicionado);
                    MaximaAlert.informe((StageManager)this.stageManager, (String)"Tamanho de produto salvo com sucesso.");
                }
            }
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de cadastro de tamanhos por produto.");
        }
    }

    private void editaProduto() {
        Produto produto = (Produto)this.tblProdutoTamanhos.getSelectionModel().getSelectedItem();
        if (produto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um produto para editar.");
            return;
        }
        this.formTamanho(produto, produto.getProdutoPaiTamanho());
    }

    private void deleteItem(Produto item) throws MaximaException {
        if (item == null && (item = (Produto)this.tblProdutoTamanhos.getSelectionModel().getSelectedItem()) == null) {
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o item: " + item.getCategoriaProdutoTamanho().getDescricao() + " ?"))) {
            return;
        }
        this.produtoService.remove(item);
        this.inicializa(this.produto);
        MaximaAlert.informe((StageManager)this.stageManager, (String)"Item removido com sucesso.");
    }

    private void carregarDadosFiscais() {
        FiscalProduto fiscalProduto;
        try {
            Stage formPesquisa = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.btnDadosFiscais.getScene().getWindow(), "/fxml/fiscal/produtoFiscal/FiscalProdutoPesquisa.fxml", "Pesquisar Dados Fiscais");
            FiscalProdutoPesquisaController controller = (FiscalProdutoPesquisaController)formPesquisa.getUserData();
            formPesquisa.showAndWait();
            fiscalProduto = controller.getItemSelecionado();
        }
        catch (IOException ex) {
            Logger.getLogger(ProdutoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Erro ao abrir janela com os dados fiscais.");
            return;
        }
        if (fiscalProduto != null) {
            this.tfCodigoNcm.setText(fiscalProduto.getNcm());
            this.tfCfopDentroEstado.setText(fiscalProduto.getCfop());
            this.tfCfopForaEstado.setText(fiscalProduto.getCfopInterEstad());
            this.cbOrigem.getSelectionModel().select((Object)fiscalProduto.getOrigem());
            this.cbCSOSN.getSelectionModel().select((Object)fiscalProduto.getIcmsSN());
            this.cbPis.getSelectionModel().select((Object)fiscalProduto.getPis());
            this.cbCofins.getSelectionModel().select((Object)fiscalProduto.getCofins());
        }
    }

    private void registraAcoes() {
        this.btnDadosFiscais.setOnAction(evt -> this.carregarDadosFiscais());
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnTamanhoAdd.setOnAction(event -> {
            this.produto = this.getProduto();
            if (this.produto.getCategoriaProduto() != null) {
                List tamanhos = this.categoriaProdutoService.listaCategoriaProdutoTamanhos(this.produto.getCategoriaProduto().getId());
                if (tamanhos != null && !tamanhos.isEmpty()) {
                    this.formTamanho(null, this.produto);
                } else {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"Categoria selecionada n\u00e3o possui Tamanhos vinculados");
                }
            } else {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione a categoria");
            }
        });
        this.btnVIncularProduto.setOnAction(evt -> this.vincularProdutoTamanho());
        this.tblProdutoTamanhos.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.produto = this.getProduto();
                this.editaProduto();
            }
        });
        this.btnCodigo.setOnAction(evt -> {
            String codigo = this.produtoService.geraCodigo();
            this.tfCodigoBarras.setText(codigo);
        });
        this.tblProdutoTamanhos.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                try {
                    this.deleteItem(null);
                }
                catch (MaximaException ex) {
                    Logger.getLogger(ProdutoPorTamanhoFormController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }
}

