/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.CategoriaProdutoTamanho;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ProdutoPorTamanhoItemFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    StageManager stageManager;
    Produto produto;
    Produto produtoPai;
    @Autowired
    ProdutoService produtoService;
    @Autowired
    CategoriaProdutoService categoriaProdutoService;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfIdProdutoPai;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnCodigo;
    @FXML
    private ComboBox<CategoriaProdutoTamanho> cbTamanho;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfCustoUnitario;
    @FXML
    private TextField tfVendaUnitario;
    @FXML
    private TextField tfCodigoBarras;

    public void initialize(URL url, ResourceBundle rb) {
        this.registraAcoes();
        this.setMascaras();
        this.carregaIcones();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnCodigo.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    public void setProduto(Produto produto1) {
        this.produto = produto1;
        if (this.produto != null) {
            if (this.produto.getId() != null) {
                this.tfId.setText(this.produto.getId().toString());
            }
            if (this.produto.getProdutoPaiTamanho() != null && this.produto.getProdutoPaiTamanho().getId() != null) {
                this.tfIdProdutoPai.setText(this.produto.getProdutoPaiTamanho().getId().toString());
            }
            this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getEstoqueAtual(), (int)2));
            this.tfCustoUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getUltimoCusto(), (int)2));
            this.tfVendaUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.cbTamanho.getSelectionModel().select((Object)this.produto.getCategoriaProdutoTamanho());
            this.tfCodigoBarras.setText(this.produto.getCodigo());
            this.cbTamanho.requestFocus();
        }
    }

    private void loadCombos(Produto produtoPai) {
        List tamanhos = this.categoriaProdutoService.listaCategoriaProdutoTamanhos(produtoPai.getCategoriaProduto().getId());
        this.cbTamanho.setItems(FXCollections.observableArrayList((Collection)this.categoriaProdutoService.listaCategoriaProdutoTamanhos(produtoPai.getCategoriaProduto().getId())));
    }

    public void inicializa(Produto produto1, Produto prodPai) {
        System.out.println("inicializa item");
        this.produto = produto1;
        this.produtoPai = prodPai;
        if (this.produto != null) {
            this.produto.setProdutoPaiTamanho(this.produtoPai);
            if (this.produto.getId() != null) {
                this.produto = this.produtoService.getById(this.produto.getId().longValue());
            }
            this.setProduto(this.produto);
            this.cbTamanho.setDisable(true);
        }
        this.loadCombos(this.produtoPai);
    }

    public Produto getProduto() {
        System.out.println("retorna produto para lista");
        return this.produto;
    }

    private Produto carregaProduto() {
        if (this.produto == null) {
            this.produto = new Produto();
        }
        this.produto.setNome(this.produtoPai.getNome());
        this.produto.setObservacao(MaximaUtils.getText((String)this.produtoPai.getObservacao()));
        this.produto.setAtivo(this.produtoPai.isAtivo());
        this.produto.setEstoqueNegativo(this.produtoPai.isEstoqueNegativo());
        this.produto.setCategoriaProduto(this.produtoPai.getCategoriaProduto());
        this.produto.setUnidade(this.produtoPai.getUnidade());
        this.produto.setCodigo(this.tfCodigoBarras.getText());
        this.produto.setReferencia(this.produtoPai.getReferencia());
        this.produto.setNcm(this.produtoPai.getNcm());
        this.produto.setCest(this.produtoPai.getCest());
        this.produto.setCfop(this.produtoPai.getCfop());
        this.produto.setCfopInterEstad(this.produtoPai.getCfopInterEstad());
        this.produto.setOrigem(this.produtoPai.getOrigem());
        this.produto.setIcmsSN(this.produtoPai.getIcmsSN());
        this.produto.setPis(this.produtoPai.getPis());
        this.produto.setCofins(this.produtoPai.getCofins());
        this.produto.setAliquotaCreditoICMS(this.produtoPai.getAliquotaCreditoICMS());
        this.produto.setAliquotaIVA(this.produtoPai.getAliquotaIVA());
        this.produto.setAliquotaPis(this.produtoPai.getAliquotaPis());
        this.produto.setAliquotaCofins(this.produtoPai.getAliquotaCofins());
        this.produto.setBalanca(this.produtoPai.getBalanca());
        this.produto.setAgrupar(this.produtoPai.getAgrupar());
        this.produto.setFotoPrincipal(this.produtoPai.getFotoPrincipal());
        this.produto.setComposicao(this.produtoPai.getComposicao());
        this.produto.setFatorConversaoEntrada(BigDecimal.ZERO);
        this.produto.setEstoqueAtual(MaximaNumber.moneyToBigDecimal((String)this.tfQuantidade.getText()));
        this.produto.setEstoqueInicial(MaximaNumber.moneyToBigDecimal((String)this.tfQuantidade.getText()));
        this.produto.setEstoqueMinimo(BigDecimal.ZERO);
        this.produto.setUltimoCusto(MaximaNumber.moneyToBigDecimal((String)this.tfCustoUnitario.getText()));
        this.produto.setPrecoVenda(MaximaNumber.moneyToBigDecimal((String)this.tfVendaUnitario.getText()));
        this.produto.setDescontoPermitido(BigDecimal.ZERO);
        this.produto.setComissao(BigDecimal.ZERO);
        this.produto.setProdutoPaiTamanho(this.produtoPai);
        this.produto.setCategoriaProdutoTamanho((CategoriaProdutoTamanho)this.cbTamanho.getSelectionModel().getSelectedItem());
        System.out.println("produto inicializado");
        return this.produto;
    }

    private void salva() {
        this.produto = this.carregaProduto();
        if (this.produto.getPrecoVenda().compareTo(BigDecimal.ZERO) == 0 && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cadastrar o produto com pre\u00e7o de venda zerado?")) {
            this.produto = null;
            return;
        }
        Stage stage = (Stage)this.tfId.getScene().getWindow();
        stage.close();
        System.out.println("produto salvo");
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfCustoUnitario);
        MaximaMask.monetaryField((TextField)this.tfVendaUnitario);
        MaximaMask.monetaryField((TextField)this.tfQuantidade);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnCodigo.setOnAction(evt -> {
            if (this.cbTamanho.getSelectionModel().getSelectedItem() != null) {
                this.tfCodigoBarras.setText(this.produtoPai.getCodigo() + "-" + ((CategoriaProdutoTamanho)this.cbTamanho.getSelectionModel().getSelectedItem()).getSigla());
            } else {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione o Tamanho para gerar o c\u00f3digo ");
            }
        });
    }
}

