/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.UnidadeFormController;
import br.com.maximasolutions.estoque.modelo.Unidade;
import br.com.maximasolutions.estoque.service.UnidadeService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class UnidadeController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<Unidade> tabela;
    @FXML
    private TableColumn<Unidade, String> colNome;
    @FXML
    private TableColumn<Unidade, String> colSigla;
    @Autowired
    private UnidadeService unidadeService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<Unidade> unidadeList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.unidadeList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaUnidade();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Unidade);
    }

    private void novoUnidade() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formUnidade(null);
        this.loadTabela();
    }

    private void editaUnidade() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        Unidade unidade = (Unidade)this.tabela.getSelectionModel().getSelectedItem();
        if (unidade == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma unidade para editar.");
            return;
        }
        this.formUnidade(unidade);
        this.loadTabela();
    }

    private void formUnidade(Unidade unidade) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/unidade/UnidadeForm.fxml", "Novo Tipo Unidade");
            UnidadeFormController controller = (UnidadeFormController)stage.getUserData();
            controller.inicializa(unidade);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(UnidadeController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form tipo de unidade.\n" + ex.getMessage()));
        }
    }

    private void deleteUnidade() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Unidade unidade = (Unidade)this.tabela.getSelectionModel().getSelectedItem();
        if (unidade == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma unidade para remover.");
            return;
        }
        if (MaximaAlert.confirmacao((String)("Deseja remover a unidade: '" + unidade.getNome() + "'?"))) {
            this.unidadeService.deleteById(unidade.getId());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Unidade deletado com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.unidadeList.clear();
        this.unidadeList.addAll((Collection)this.unidadeService.list());
        this.tabela.setItems(this.unidadeList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colSigla.setCellValueFactory((Callback)new PropertyValueFactory("sigla"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoUnidade());
        this.btnEdita.setOnAction(event -> this.editaUnidade());
        this.btnDelete.setOnAction(event -> this.deleteUnidade());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

