/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaFile;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.PDVFormController;
import br.com.maximasolutions.estoque.controller.VendaProdutoController;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.fiscal.controller.CPFFormController;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.nfce.controller.NFCeController;
import br.com.maximasolutions.nfce.controller.NFCeImportaVenda;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfce.modelo.NFCeDestinatario;
import br.com.maximasolutions.nfce.modelo.NFCeEmitente;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.sat.controller.SATController;
import br.com.maximasolutions.sat.controller.SatCancelaController;
import br.com.maximasolutions.sat.controller.SatEnviaController;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.modelo.SatCFeXml;
import br.com.maximasolutions.sat.print.SatImpressaoController;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.sat.xml.modelo.CFe;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Controller
public class VendaProdutoPDVController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnImprimeVenda;
    @FXML
    private Button btnCupomFiscal;
    @FXML
    private Button btnImprimeCupom;
    @FXML
    private Button btnCancelaCupom;
    @FXML
    private Button btnFechar;
    @FXML
    private TableView<VendaProduto> tabela;
    @FXML
    private TableColumn<VendaProduto, String> colCliente;
    @FXML
    private TableColumn<VendaProduto, String> colCodigo;
    @FXML
    private TableColumn<VendaProduto, String> colObservacao;
    @FXML
    private TableColumn<VendaProduto, String> colData;
    @FXML
    private TableColumn<VendaProduto, BigDecimal> colTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private NcmService ncmService;
    @Autowired
    private SatCFeService satCFeService;
    @Autowired
    private CaixaService caixaService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private NFCeService nFCeService;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    private ObservableList<VendaProduto> vendaProdutoList;
    private ControleSAT controleSAT;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.vendaProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa(ControleSAT controleSAT, Configuracao configuracao) {
        this.controleSAT = controleSAT;
        this.conf = configuracao;
    }

    private void imprimeVendaSelecionada() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o.");
            return;
        }
        try {
            this.vendaProdutoService.imprimeVenda(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void emiteCupomVendaSelecionada() {
        String cpf;
        String nome;
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para emiss\u00e3o de cupom fiscal.");
            return;
        }
        if (vendaProduto.getSatCFe() != null || vendaProduto.getNfce() != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal j\u00e1 emitido para a venda selecioanda. N\u00e3o \u00e9 permitido a opera\u00e7\u00e3o.");
            return;
        }
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/CPFForm.fxml", "CPF ou CNPJ");
            CPFFormController controller = (CPFFormController)stage.getUserData();
            controller.inicializa();
            if (vendaProduto.getCliente().getCpf() != null && !vendaProduto.getCliente().getCpf().isEmpty()) {
                controller.setCpf(vendaProduto.getCliente().getCpf());
            }
            controller.setCliente(vendaProduto.getCliente().getNome());
            stage.showAndWait();
            if (!controller.isFinalizado()) {
                return;
            }
            nome = controller.getNome();
            cpf = controller.getCpf();
        }
        catch (IOException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir janela de CPF ou CNPJ.");
            return;
        }
        if (MaximaConfig.getCupomTipo().equalsIgnoreCase("sat")) {
            if (this.controleSAT == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Falha na comunica\u00e7\u00e3o com o equipamento SAT.");
                return;
            }
            this.emiteCupomSAT(vendaProduto, cpf, nome);
        } else {
            this.emiteCupomNFCe(vendaProduto, cpf, nome);
        }
        this.loadTabela();
    }

    private void emiteCupomSAT(VendaProduto vendaProduto, String cpf, String nome) {
        try {
            String xmlEnvio = SatEnviaController.convertVendaProdutoToXmlCupom((NcmService)this.ncmService, (VendaProduto)vendaProduto, (List)this.vendaProdutoService.listItens(vendaProduto), (List)this.vendaProdutoService.listaFaturamentos(vendaProduto), (Configuracao)this.conf, (String)MaximaConfig.getInstance().getProperty("caixa_id", "1"), (String)cpf, (String)nome);
            String xmlCupomEmitido = new SATController(this.controleSAT, this.conf).emiteCupom(xmlEnvio);
            ControleArquivos.escreverBytesArquivo((String)"C:/Maxima/xml_sat.txt", (byte[])xmlCupomEmitido.getBytes());
            byte[] arquivoCupom = SatEnviaController.tratarResultadoVenda((String)xmlCupomEmitido, (Configuracao)this.conf);
            SatCFeXml satCFeXml = new SatCFeXml();
            if (arquivoCupom != null) {
                satCFeXml.setArquivo(arquivoCupom);
            }
            String xmlCupom = ControleArquivos.lerBytesArquivo((String)"C:/Maxima/ultimoCupom.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xmlCupom.getBytes());
            Document doc = db.parse(is);
            NodeList raizes = doc.getChildNodes();
            org.w3c.dom.Node raiz = raizes.item(0);
            CFe xmlCFe = new CFe(raiz);
            SatCFe satCFe = this.satCFeService.getSatCfeXmlCupom(xmlCFe);
            List itens = this.satCFeService.getSatCfeItemXmlCupom(xmlCFe);
            List parcelas = this.satCFeService.getSatCfePagamento(xmlCFe);
            satCFe = this.satCFeService.salvaCupom(satCFe, itens, parcelas, satCFeXml, vendaProduto);
            SatImpressaoController.imprimeCupom((byte[])arquivoCupom, (Configuracao)this.conf, (SatCFe)satCFe);
        }
        catch (Exception ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao emitir cupom fiscal.\n" + ex.getMessage()));
        }
    }

    private void emiteCupomNFCe(VendaProduto ultimaVenda, String cpf, String nome) {
        NFCeCabecalho nfce;
        block10: {
            nfce = null;
            try {
                List list = this.vendaProdutoService.listItens(ultimaVenda);
                List faturamentos = this.vendaProdutoService.listaFaturamentos(ultimaVenda);
                NFCeImportaVenda nFCeImportaVenda = new NFCeImportaVenda(this.conf, this.nFCeService);
                nfce = nFCeImportaVenda.getNFCe(ultimaVenda, list);
                NFCeEmitente emitente = nFCeImportaVenda.getEmitente();
                NFCeDestinatario destinatario = nFCeImportaVenda.getDestinatario(cpf, nome);
                List itens = nFCeImportaVenda.getItensNFe(ultimaVenda, list, this.ncmService);
                List pagamentos = nFCeImportaVenda.pagamentos(faturamentos);
                nfce = this.nFCeService.salva(nfce, emitente, destinatario, itens, pagamentos, ultimaVenda, this.conf);
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                if (nfce == null) break block10;
                try {
                    this.nFCeService.delete(nfce);
                }
                catch (MaximaException ex1) {
                    Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex1);
                }
                nfce = null;
            }
            catch (Exception ex) {
                Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Ocorreu um erro ao validar o xml do Cupom Fiscal Consumidor");
                if (nfce == null) break block10;
                try {
                    this.nFCeService.delete(nfce);
                }
                catch (MaximaException ex1) {
                    Logger.getLogger(PDVFormController.class.getName()).log(Level.SEVERE, null, ex1);
                }
                nfce = null;
            }
        }
        if (nfce != null && nfce.getStatusNota().equals((Object)NFeStatus.AUTORIZADA)) {
            try {
                this.nFCeService.imprime(nfce, this.conf);
            }
            catch (MaximaException ex) {
                Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Cupom Fiscal N\u00e3o Impresso.\n" + ex.getMessage()));
            }
        }
    }

    private void cancelaCupomFiscal() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum cupom fiscal selecionado para efetuar o cancelamento.");
            return;
        }
        if (vendaProduto.getSatCFe() == null && vendaProduto.getNfce() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal n\u00e3o emitido para venda selecionada.");
            return;
        }
        if (vendaProduto.getSatCFe() != null) {
            this.cancelaCupomSat(vendaProduto);
        } else {
            this.cancelaCupomNfce(vendaProduto);
        }
        this.loadTabela();
    }

    private void cancelaCupomNfce(VendaProduto vendaProduto) {
        try {
            this.nFCeService.cancela(vendaProduto.getNfce());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Cupom fiscal cancelado com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO ao cancelar cupom fiscal.\n" + ex.getMessage()));
        }
    }

    private void cancelaCupomSat(VendaProduto vendaProduto) {
        byte[] xmlCancCupom;
        String retorno;
        SatCFe cupom = vendaProduto.getSatCFe();
        if (cupom.getCancelado().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal j\u00e1 cancelado.");
            return;
        }
        String xmlCancelamento = SatCancelaController.getXmlCancelamento((SatCFe)cupom);
        try {
            MaximaFile.escreveTexto((String)"C:/Maxima/sat_cancela.xml", (String)xmlCancelamento);
        }
        catch (IOException ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            System.out.println("== CHAVE ACESSO: " + cupom.getChaveAcesso());
            retorno = new SATController(this.controleSAT, this.conf).cancelaCupom(xmlCancelamento, cupom.getChaveAcesso());
        }
        catch (Exception ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
            return;
        }
        try {
            xmlCancCupom = SatCancelaController.tratarResultado((String)retorno);
        }
        catch (MaximaException ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
            return;
        }
        if (xmlCancCupom == null) {
            return;
        }
        this.satCFeService.cancelaCupom(cupom, xmlCancCupom);
        MaximaAlert.informe((StageManager)this.stageManager, (String)"Cupom fiscal cancelado com sucesso.");
    }

    private void imprimeCupomFiscal() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o do cupom fiscal.");
            return;
        }
        if (vendaProduto.getSatCFe() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Cupom fiscal n\u00e3o emitido para venda selecionada.");
            return;
        }
        vendaProduto = this.vendaProdutoService.getById(vendaProduto.getId());
        SatCFe cupomSAT = this.satCFeService.load(vendaProduto.getSatCFe().getId());
        try {
            SatImpressaoController.imprimeCupom((byte[])this.satCFeService.loadXml(cupomSAT.getId().longValue()).getArquivo(), (Configuracao)this.conf, (SatCFe)cupomSAT);
        }
        catch (Exception ex) {
            Logger.getLogger(VendaProdutoPDVController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao imprimir cupom fiscal.\n" + ex.getMessage()));
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataHora"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("observacao"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.setRowFactory(tv -> new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadTabela() {
        this.vendaProdutoList.clear();
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")));
        if (movimentoCaixa != null) {
            List list = this.vendaProdutoService.listaPorMovimentoCaixa(movimentoCaixa);
            this.vendaProdutoList.addAll((Collection)list);
        }
        this.tabela.setItems(this.vendaProdutoList);
    }

    private void carregaIcones() {
        this.btnImprimeCupom.setGraphic((Node)new MaximaIcone().print());
        this.btnImprimeVenda.setGraphic((Node)new MaximaIcone().print());
        this.btnCupomFiscal.setGraphic((Node)new MaximaIcone().print());
        this.btnCancelaCupom.setGraphic((Node)new MaximaIcone().cancel_24());
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void registraAcoes() {
        this.btnImprimeVenda.setOnAction(event -> this.imprimeVendaSelecionada());
        this.btnCupomFiscal.setOnAction(event -> this.emiteCupomVendaSelecionada());
        this.btnImprimeCupom.setOnAction(event -> this.imprimeCupomFiscal());
        this.btnCancelaCupom.setOnAction(event -> this.cancelaCupomFiscal());
        this.btnFechar.setOnAction(evt -> this.fecharForm());
    }

    private void fecharForm() {
        Stage stage = (Stage)this.btnFechar.getScene().getWindow();
        stage.close();
    }
}

