/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendaProdutoPesquisaController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnConfirma;
    @FXML
    private TableView<VendaProduto> tabela;
    @FXML
    private TableColumn<VendaProduto, String> colCliente;
    @FXML
    private TableColumn<VendaProduto, String> colCodigo;
    @FXML
    private TableColumn<VendaProduto, String> colObservacao;
    @FXML
    private TableColumn<VendaProduto, String> colData;
    @FXML
    private TableColumn<VendaProduto, String> colDataFaturamento;
    @FXML
    private TableColumn<VendaProduto, BigDecimal> colTotal;
    @FXML
    private TableColumn<VendaProduto, BigDecimal> colLiquido;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private ObservableList<VendaProduto> vendaProdutoList;
    private Configuracao conf;
    private VendaProduto vendaProduto;
    private Boolean faturadas;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.vendaProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.registraAcoes();
    }

    public VendaProduto getVendaProduto() {
        return this.vendaProduto;
    }

    public void inicializa(Boolean faturadas) {
        this.vendaProduto = null;
        this.faturadas = faturadas;
        this.loadTabela();
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colDataFaturamento.setCellValueFactory((Callback)new PropertyValueFactory("dataFaturamento"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("observacao"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colLiquido.setCellValueFactory((Callback)new PropertyValueFactory("totalLiquido"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colDataFaturamento.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colLiquido.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void loadTabela() {
        this.vendaProdutoList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        if (this.faturadas.booleanValue()) {
            List list = this.vendaProdutoService.faturadas(inicio, fim, filtro);
            this.vendaProdutoList.addAll((Collection)list);
            this.tabela.setItems(this.vendaProdutoList);
        } else {
            List list = this.vendaProdutoService.emAberto(inicio, fim, filtro);
            this.vendaProdutoList.addAll((Collection)list);
            this.tabela.setItems(this.vendaProdutoList);
        }
    }

    private void carregaIcones() {
        this.btnConfirma.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void selecionaVenda() {
        this.vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (this.vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada.");
            return;
        }
        this.close();
    }

    private void close() {
        Stage stage = (Stage)this.btnConfirma.getScene().getWindow();
        stage.close();
    }

    private void registraAcoes() {
        this.btnConfirma.setOnAction(evt -> this.selecionaVenda());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.selecionaVenda();
            }
        });
    }
}

