/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.VendaProdutoItemView;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendasPorProdutoViewController
extends MaximaController
implements Initializable {
    @FXML
    private TableView<VendaProdutoItemView> tabela;
    @FXML
    private TableColumn<VendaProdutoItemView, String> colCliente;
    @FXML
    private TableColumn<VendaProdutoItemView, String> colCodigo;
    @FXML
    private TableColumn<VendaProdutoItemView, String> colData;
    @FXML
    private TableColumn<VendaProdutoItemView, BigDecimal> colTotal;
    @FXML
    private TableColumn<VendaProdutoItemView, BigDecimal> colUnitario;
    @FXML
    private TableColumn<VendaProdutoItemView, BigDecimal> colQuantidade;
    @FXML
    private Button btnFechar;
    @FXML
    private Label produtoLabel;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ProdutoService produtoService;
    private ObservableList<VendaProdutoItemView> vendaProdutoList;
    private Produto produto;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.setColumnProperties();
        this.registraAcoes();
    }

    public void inicializa(Produto produto) {
        this.produto = produto;
        this.vendaProdutoList = FXCollections.observableArrayList();
        this.produtoLabel.setText(produto.getNome().toUpperCase());
        this.loadTabela();
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidade"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("unitario"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colQuantidade.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colUnitario.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void loadTabela() {
        this.vendaProdutoList.clear();
        List list = this.produtoService.listarVendaItens(this.produto);
        ArrayList lista = new ArrayList();
        list.forEach(item -> {
            VendaProdutoItemView view = new VendaProdutoItemView();
            view.setCodigo(item.getProduto().getCodigo());
            view.setDataEmissao(item.getVendaProduto().getDataEmissao());
            view.setCliente(item.getVendaProduto().getCliente().getNome().toUpperCase());
            view.setQuantidade(item.getQuantidade());
            view.setUnitario(item.getPrecoUnitario());
            view.setTotal(item.getPrecoTotal());
            lista.add(view);
        });
        this.vendaProdutoList.addAll(lista);
        this.tabela.setItems(this.vendaProdutoList);
    }

    private void carregaIcones() {
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void selecionaVenda() {
    }

    private void close() {
        Stage stage = (Stage)this.tabela.getScene().getWindow();
        stage.close();
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> this.close());
    }
}

