/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.dino.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.SincronizacaoPdvService;
import br.com.maximasolutions.administrativo.service.ValidacaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.GetNumeroFormController;
import br.com.maximasolutions.controller.GetValorFormController;
import br.com.maximasolutions.controller.PrincipalController;
import br.com.maximasolutions.controller.ValidacaoController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.delivery.modelo.Entregador;
import br.com.maximasolutions.estoque.controller.PDVFechamentoFormController;
import br.com.maximasolutions.estoque.controller.PDVGetItemFormController;
import br.com.maximasolutions.estoque.controller.PedidoItemEditaFormController;
import br.com.maximasolutions.estoque.controller.PedidoVendaConstrucaoFormController;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.controller.VendaProdutoPDVController;
import br.com.maximasolutions.estoque.dino.controller.PDVDinoEntregadorController;
import br.com.maximasolutions.estoque.dino.controller.PDVDinoEntregasController;
import br.com.maximasolutions.estoque.dino.controller.PDVDinoTipoFechamentoController;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoFechamentoTipo;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.Promocao;
import br.com.maximasolutions.estoque.modelo.TipoMovimentacao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.DevolucaoService;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaIniciaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaSangriaFormController;
import br.com.maximasolutions.financeiro.controller.MovimentoCaixaSuprimentoFormController;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.service.CaixaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnQuantidadeFormatter;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVDinoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private CaixaService caixaService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ValidacaoService validacaoService;
    @Autowired
    private NcmService ncmService;
    @Autowired
    private SatCFeService satCFeService;
    @Autowired
    private DevolucaoService devolucaoService;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private SincronizacaoPdvService sincronizacaoPdvService;
    @Autowired
    private NFCeService nFCeService;
    private Configuracao conf;
    private Produto produto;
    private Promocao promocao;
    private ObservableList<PedidoItem> pedidoItemList;
    private Pedido pedido;
    private Cliente cliente;
    @FXML
    private VBox vBox;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoDescricao;
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfValorUnitario;
    @FXML
    private TextField tfTotalItem;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfValorReceber;
    @FXML
    private TextField tfCliente;
    @FXML
    private TextField tfObservacao;
    @FXML
    private TableView<PedidoItem> tabela;
    @FXML
    private TableColumn<PedidoItem, String> colProduto;
    @FXML
    private TableColumn<PedidoItem, String> colItem;
    @FXML
    private TableColumn<PedidoItem, String> colCodigo;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colUnitario;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colQuantidade;
    @FXML
    private TableColumn<PedidoItem, BigDecimal> colTotalItem;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private Button btnProdutoAdd;
    @FXML
    private Button btnFinaliza;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnProdutoLimpar;
    @FXML
    private Button btnCliente;
    @FXML
    private Button btnPedidosFinalizados;
    @FXML
    private Button btnEntregas;
    @FXML
    private Button btnTroca;
    @FXML
    private ComboBox<Vendedor> comboVendedor;
    @FXML
    private Pane paneBotoes;
    @FXML
    private Pane paneCliente;
    @FXML
    private Pane paneProduto;
    private Boolean atalho;
    private ControleSAT controleSAT;
    private Scene scene;

    public void initialize(URL location, ResourceBundle resources) {
        new ValidacaoController().validaAtivacao(this.stageManager, this.configuracaoService, this.validacaoService);
        this.stageManager.getStage().setUserData((Object)this);
        this.vBox.setStyle("-fx-background-color: linear-gradient(to bottom right, #483D8B, #4169E1)");
        this.paneBotoes.setStyle("-fx-background-color: rgba(0, 0, 0, 0.4);");
        this.paneCliente.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);");
        this.paneProduto.setStyle("-fx-background-color: rgba(0, 0, 0, 0.4);");
    }

    public void inicializaPDV(Scene scene) {
        this.scene = scene;
        this.inicializaForm(scene);
    }

    public void inicializaForm(Scene scene) {
        this.conf = this.configuracaoService.load();
        if (this.conf != null && this.conf.getBloqueaPrecoVenda().booleanValue()) {
            this.tfValorUnitario.setDisable(true);
        } else {
            this.tfValorUnitario.setDisable(false);
        }
        this.carregaCombos();
        this.carregaIcones();
        this.registraAcoes();
        this.setColumnProperties();
        this.carregaMascaras();
        this.carregaAtalhos(scene);
        this.validaMovimentoCaixa();
        this.formataCampos();
        this.inicializaPedido();
    }

    private void validaMovimentoCaixa() {
        String caixaIdTxt = MaximaConfig.getInstance().getProperty("caixa_id");
        if (caixaIdTxt == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Caixa n\u00e3o configurado no arquivo properties.");
            return;
        }
        Long caixaId = Long.parseLong(caixaIdTxt);
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixaId.longValue());
        if (movimentoCaixa == null) {
            try {
                Stage abreMovimentoCaixaForm = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentoCaixa/AbrirCaixaForm.fxml", "Abertura de Movimento de Caixa");
                MovimentoCaixaIniciaFormController controller = (MovimentoCaixaIniciaFormController)abreMovimentoCaixaForm.getUserData();
                controller.inicializa(null);
                abreMovimentoCaixaForm.showAndWait();
            }
            catch (IOException ex) {
                Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo: ABERTURA DE MOVIMENTO DE CAIXA.");
                System.exit(0);
            }
            movimentoCaixa = this.movimentoCaixaService.getCaixaAberto(caixaId.longValue());
            if (movimentoCaixa == null) {
                this.vBox.setDisable(true);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhum movimento de caixa aberto.");
            }
        } else if (movimentoCaixa.getDataAbertura().toLocalDate().isBefore(LocalDate.now())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Movimento de caixa n\u00e3o fechado do dia anterior.");
        }
    }

    public void inicializaPedido() {
        this.atalho = false;
        this.pedido = null;
        this.cliente = null;
        this.pedidoItemList = null;
        this.comboVendedor.getSelectionModel().select(null);
        this.inicializaItem();
        this.carregaCliente();
    }

    private void carregaCliente() {
        if (this.cliente == null) {
            this.tfCliente.setText("");
        } else {
            String texto = this.cliente.getNome().toUpperCase();
            texto = this.cliente.getTelefone() == null || this.cliente.getTelefone().isEmpty() ? texto + "  |  FONE N\u00c3O CADASTRADO" : texto + "  |  " + this.cliente.getTelefone();
            this.tfCliente.setText(texto);
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        }
    }

    private void inicializaItem() {
        this.produto = null;
        this.promocao = null;
        this.loadDadosProduto();
        this.loadItens();
    }

    private void setColumnProperties() {
        this.colItem.setCellValueFactory((Callback)new PropertyValueFactory("numItem"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigo"));
        this.colProduto.setCellValueFactory((Callback)new PropertyValueFactory("descricaoCompleta"));
        this.colQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidadeFormatada"));
        this.colUnitario.setCellValueFactory((Callback)new PropertyValueFactory("precoUnitario"));
        this.colTotalItem.setCellValueFactory((Callback)new PropertyValueFactory("precoTotal"));
        ColumnNumberFormatter valorFormatter = new ColumnNumberFormatter();
        ColumnQuantidadeFormatter quantidadeFormatter = new ColumnQuantidadeFormatter();
        this.colQuantidade.setCellFactory((Callback)quantidadeFormatter);
        this.colUnitario.setCellFactory((Callback)valorFormatter);
        this.colTotalItem.setCellFactory((Callback)valorFormatter);
    }

    private void imprimeUltimaVenda() {
        try {
            this.vendaProdutoService.imprimeUltimaVenda();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEdita = new MenuItem("Editar Item");
        menuEdita.setOnAction(event -> this.editaItem());
        cm.getItems().add((Object)menuEdita);
        MenuItem menuRemove = new MenuItem("Remover Item");
        menuRemove.setOnAction(event -> this.deleteItem(null));
        cm.getItems().add((Object)menuRemove);
        return cm;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnProdutoAdd.setGraphic((Node)maximaIcone.adiciona_28());
        this.btnProdutoLimpar.setGraphic((Node)maximaIcone.cancela_28());
        this.btnFinaliza.setGraphic((Node)maximaIcone.icone_confirma_40());
        this.btnCancela.setGraphic((Node)maximaIcone.icone_cancela_40());
        this.btnProdutoPesquisa.setGraphic((Node)maximaIcone.pesquisa_28());
        this.btnCliente.setGraphic((Node)maximaIcone.cliente_pesquisa_28());
    }

    private void carregaCombos() {
        ArrayList vendedores = new ArrayList();
        vendedores.add(null);
        vendedores.addAll(this.vendedorService.list());
        this.comboVendedor.setItems(FXCollections.observableArrayList(vendedores));
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            this.produto = null;
            this.promocao = null;
            this.loadDadosProduto();
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto == null && produtoCodigo.length() == 13 && produtoCodigo.substring(0, 1).equals("2")) {
            String codigoProduto = produtoCodigo.substring(1, 5);
            String precoTotal1 = produtoCodigo.substring(5, 10);
            String precoTotal2 = produtoCodigo.substring(10, 12);
            BigDecimal precoTotal = new BigDecimal(precoTotal1 + "." + precoTotal2);
            this.produto = this.produtoService.getByCodigoBarras(codigoProduto);
            if (this.produto != null) {
                BigDecimal quantidade = precoTotal.divide(this.produto.getPrecoVenda(), 3, RoundingMode.HALF_UP).setScale(3, RoundingMode.HALF_UP);
                this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
            } else {
                codigoProduto = produtoCodigo.substring(3, 7);
                precoTotal1 = produtoCodigo.substring(7, 10);
                precoTotal2 = produtoCodigo.substring(10, 12);
                precoTotal = new BigDecimal(precoTotal1 + "." + precoTotal2);
                List produtos2 = this.produtoService.getByCodigoInterno(codigoProduto);
                if (produtos2 != null && produtos2.size() == 1) {
                    this.produto = (Produto)produtos2.get(0);
                }
                if (this.produto != null) {
                    BigDecimal quantidade = precoTotal.divide(this.produto.getPrecoVenda(), 3, RoundingMode.HALF_UP).setScale(3, RoundingMode.HALF_UP);
                    this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                } else {
                    codigoProduto = produtoCodigo.substring(4, 7);
                    produtos2 = this.produtoService.getByCodigoInterno(codigoProduto);
                    if (produtos2 != null && produtos2.size() == 1) {
                        this.produto = (Produto)produtos2.get(0);
                    }
                    if (this.produto != null) {
                        BigDecimal quantidade = precoTotal.divide(this.produto.getPrecoVenda(), 3, RoundingMode.HALF_UP).setScale(3, RoundingMode.HALF_UP);
                        this.tfQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)quantidade, (int)3));
                    }
                }
            }
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoDescricao.setText(MaximaNumber.quantidadeToString((BigDecimal)MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText())) + "  X  " + this.produto.getNome().toUpperCase());
            this.tfValorUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            this.calculaTotalItem();
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
        } else {
            if (this.pedido == null || this.pedido.getId() == null) {
                this.tfProdutoDescricao.setText("");
                this.tfValorUnitario.setText("");
            }
            this.calculaTotalItem();
            this.tfQuantidade.setText("1");
            this.tfProdutoPesquisa.setText("");
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
        }
    }

    private void loadItens() {
        this.pedidoItemList = FXCollections.observableArrayList();
        this.pedidoItemList.clear();
        if (this.pedido != null && this.pedido.getId() != null) {
            this.pedidoItemList.addAll((Collection)this.pedidoService.itens(this.pedido));
            this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getTotal(), (int)2));
            this.tfValorReceber.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.pedido.getValorReceber(), (int)2));
        } else {
            this.tfValorTotal.setText("0,00");
            this.tfValorReceber.setText("0,00");
        }
        this.tabela.setItems(this.pedidoItemList);
        this.tabela.scrollTo(this.pedidoItemList.size() - 1);
        this.tabela.getSelectionModel().select(this.pedidoItemList.size() - 1);
        this.tabela.getFocusModel().focus(this.pedidoItemList.size() - 1);
    }

    private void calculaTotalItem() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfTotalItem.setText("");
            return;
        }
        BigDecimal valorUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfValorUnitario.getText());
        if (valorUnitario == null) {
            this.tfTotalItem.setText("");
            return;
        }
        BigDecimal totalItem = valorUnitario.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN);
        this.tfTotalItem.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalItem, (int)2));
    }

    private void carregaMascaras() {
    }

    private void closeWindowEvent(WindowEvent event) {
        if (this.pedido == null || this.pedido.getId() == null) {
            if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja finalizar o sistema?")) {
                event.consume();
            }
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Existe um pedido em andamento. Cancele o pedido para encerrar o sistema.");
            event.consume();
        }
    }

    private void selecionaProduto() {
        String codigoPesquisa = this.tfProdutoPesquisa.getText();
        if (codigoPesquisa == null || codigoPesquisa.isEmpty()) {
            this.produto = null;
        } else if (this.produto == null || !this.produto.getCodigo().equals(codigoPesquisa.trim())) {
            this.pesquisaProduto();
        }
        if (this.produto != null) {
            if (this.conf.getBloqueaPrecoVenda().booleanValue()) {
                this.addItem();
            } else {
                this.tfQuantidade.selectAll();
                this.tfQuantidade.requestFocus();
            }
        }
    }

    private void selecionaCliente() {
        Cliente clientePesquisa = new ClientePesquisaForm().getCliente(this.stageManager, this.btnCliente.getScene(), "");
        if (clientePesquisa != null) {
            this.cliente = clientePesquisa;
            if (this.pedido != null && this.pedido.getId() != null) {
                this.pedido.setCliente(this.cliente);
                this.pedido = this.pedidoService.salva(this.pedido);
            }
            this.carregaCliente();
        }
    }

    private void registraAcoes() {
        this.tabela.setContextMenu(this.getTableMenu());
        this.btnCliente.setOnAction(evt -> this.selecionaCliente());
        this.btnProdutoPesquisa.setOnAction(evt -> this.pesquisaProdutoForm());
        this.btnProdutoAdd.setOnAction(evt -> this.addItem());
        this.btnProdutoLimpar.setOnAction(evt -> this.inicializaItem());
        this.btnFinaliza.setOnAction(evt -> this.finalizaPedido());
        this.btnCancela.setOnAction(evt -> this.cancelaPedido());
        this.tfProdutoPesquisa.focusedProperty().addListener((obs, oldVal, newVal) -> {
            if (oldVal.booleanValue()) {
                // empty if block
            }
        });
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.selecionaProduto();
            }
        });
        this.tfQuantidade.setOnKeyReleased(event -> {
            if (!this.conf.getBloqueaPrecoVenda().booleanValue()) {
                this.calculaTotalItem();
            }
        });
        this.tfQuantidade.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.conf.getBloqueaPrecoVenda().booleanValue()) {
                    this.addItem();
                } else {
                    this.tfValorUnitario.requestFocus();
                    this.tfValorUnitario.selectAll();
                }
            }
        });
        this.tfValorUnitario.setOnKeyReleased(event -> this.calculaTotalItem());
        this.tfValorUnitario.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addItem();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteItem(null);
            }
        });
        this.comboVendedor.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
            if (this.pedido != null && this.pedido.getId() != null) {
                this.pedido.setVendedor(newValue);
                this.pedido = this.pedidoService.salva(this.pedido);
            }
        });
        this.btnPedidosFinalizados.setOnAction(evt -> this.listaVendas());
        this.btnEntregas.setOnAction(evt -> this.listaVendasEmEntrega());
        this.btnTroca.setOnAction(evt -> this.adicionaTroca());
    }

    private void adicionaTroca() {
        System.out.println("== adcionar produto troca ==");
        Produto produtoTroca = this.getProdutoTroca();
        System.out.println("=== produto troca: " + produtoTroca);
        if (produtoTroca == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhum produto selecionado para adicionar como troca.");
            return;
        }
        if (this.pedido == null || this.pedido.getId() == null) {
            if (this.cliente == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: O campo cliente \u00e9 obrigat\u00f3rio.");
                return;
            }
            try {
                this.salvaPedido();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                return;
            }
        }
        try {
            this.pedido = this.pedidoService.addItem(this.pedido, null, produtoTroca, new BigDecimal("-1"), produtoTroca.getUltimoCusto(), BigDecimal.ZERO, "", Boolean.valueOf(false), Boolean.valueOf(true));
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
    }

    private Produto getProdutoTroca() {
        Produto produtoTroca = null;
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            controller.setEnableCadastrarProduto();
            stage.showAndWait();
            produtoTroca = controller.getProdutoSelecionado();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
        return produtoTroca;
    }

    private void setQuantidade() {
        this.tfQuantidade.requestFocus();
        this.tfQuantidade.selectAll();
    }

    private void carregaAtalhos(Scene scene) {
        Stage stage = (Stage)scene.getWindow();
        stage.setOnCloseRequest(event -> this.closeWindowEvent(event));
        stage.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!this.atalho.booleanValue()) {
                if (event.getCode() == KeyCode.F1) {
                    this.atalho = true;
                    this.selecionaCliente();
                    this.atalho = false;
                }
                if (event.getCode() == KeyCode.F2) {
                    this.atalho = true;
                    this.tfProdutoPesquisa.requestFocus();
                    this.tfProdutoPesquisa.selectAll();
                    this.atalho = false;
                }
                if (event.getCode() == KeyCode.F3) {
                    this.atalho = true;
                    this.setQuantidade();
                    this.atalho = false;
                }
                if (event.getCode() == KeyCode.F4) {
                    this.atalho = true;
                    this.editaItem();
                    this.atalho = false;
                }
                if (event.getCode() == KeyCode.F5) {
                    this.atalho = true;
                    this.finalizaPedido();
                    this.atalho = false;
                }
                if (event.getCode() == KeyCode.F6) {
                    this.atalho = true;
                    this.imprimeUltimaVenda();
                    this.atalho = false;
                }
                if (event.getCode() == KeyCode.F9) {
                    this.atalho = true;
                    this.cancelaItem();
                    this.atalho = false;
                }
                if (event.getCode() == KeyCode.F10) {
                    this.atalho = true;
                    System.out.println("=== F10 ===");
                    this.cancelaPedido();
                    this.atalho = false;
                }
                if (event.getCode() == KeyCode.F11) {
                    this.atalho = true;
                    this.listaVendas();
                    this.atalho = false;
                }
            }
        });
    }

    private void salvaPedido() throws MaximaException {
        if (this.pedido != null && this.pedido.getId() != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Existe um pedido em andamento.\nN\u00e3o \u00e9 poss\u00edvel iniciar outro pedido.");
            return;
        }
        this.pedido = this.pedidoService.inicia((Vendedor)this.comboVendedor.getSelectionModel().getSelectedItem(), this.cliente == null ? this.conf.getCliente() : this.cliente, LocalDate.now(), null, null, Boolean.valueOf(true));
        this.cliente = this.pedido.getCliente();
        this.carregaCliente();
    }

    private void addItem() {
        if (this.produto == null && this.promocao == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Informe um produto para adicionar o item.");
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
            return;
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Informe uma quantidade v\u00e1lida (Deve ser um n\u00famero maior que zero).");
            this.tfQuantidade.requestFocus();
            this.tfQuantidade.selectAll();
            return;
        }
        if (this.pedido == null || this.pedido.getId() == null) {
            if (this.cliente == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: O campo cliente \u00e9 obrigat\u00f3rio.");
                return;
            }
            try {
                this.salvaPedido();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                return;
            }
        }
        BigDecimal valorUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfValorUnitario.getText());
        if (this.conf.getBloqueaPrecoVenda().booleanValue() && (valorUnitario == null || valorUnitario.compareTo(BigDecimal.ZERO) <= 0)) {
            valorUnitario = this.getValorUnitario();
        }
        BigDecimal desconto = BigDecimal.ZERO;
        String observacao = "";
        try {
            boolean isTroca = quantidade.compareTo(BigDecimal.ZERO) < 0;
            this.pedido = this.pedidoService.addItem(this.pedido, null, this.produto, quantidade, valorUnitario, desconto, observacao, Boolean.valueOf(false), Boolean.valueOf(isTroca));
            this.inicializaItem();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
    }

    private void editaItem() {
        PedidoItem item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem();
        if (item == null) {
            Long numeroItem;
            try {
                Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/GetNumeroForm.fxml", "Informe o n\u00famero do Item");
                GetNumeroFormController controller = (GetNumeroFormController)form.getUserData();
                form.showAndWait();
                numeroItem = controller.getNumero();
            }
            catch (IOException ex) {
                Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel excluir item.");
                return;
            }
            item = this.pedidoService.getPorNumeroItem(Integer.valueOf(numeroItem.intValue()), this.pedido);
            if (item == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Item n\u00e3o encontrado.");
                return;
            }
        }
        if (item.getTroca().booleanValue() || item.getTrocaDino().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Este item n\u00e3o pode ser editado.");
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PedidoItemEditaForm.fxml", "Edi\u00e7\u00e3o de produto");
            PedidoItemEditaFormController controller = (PedidoItemEditaFormController)form.getUserData();
            controller.inicializa(item);
            form.showAndWait();
            this.pedido = this.pedidoService.getById(this.pedido.getId());
            this.inicializaItem();
        }
        catch (IOException ex) {
            Logger.getLogger(PedidoVendaConstrucaoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo: 'PedidoItemEditaForm.fxml'.");
        }
    }

    private void deleteItem(PedidoItem item) {
        if (item == null && (item = (PedidoItem)this.tabela.getSelectionModel().getSelectedItem()) == null) {
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o item: " + item.getNumItem() + " ?"))) {
            return;
        }
        try {
            this.pedido = this.pedidoService.deleteItem(item);
            this.inicializaItem();
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Item removido com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void finalizaPedido() {
        if (this.pedido == null || this.pedido.getId() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum pedido inicializado.");
            this.tfProdutoPesquisa.requestFocus();
            this.tfProdutoPesquisa.selectAll();
            return;
        }
        this.finalizaVenda();
    }

    private void finalizaVenda() {
        if (this.comboVendedor.getSelectionModel().getSelectedItem() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe o vendedor.");
            return;
        }
        if (this.pedidoItemList == null || this.pedidoItemList.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum produto adicionado no pedido.");
            return;
        }
        this.pedido.setObservacao(MaximaUtils.getText((String)this.tfObservacao.getText()));
        this.pedidoService.salva(this.pedido);
        try {
            Stage tipoFechamentoForm = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/dino/PDVDinoTipoFechamento.fxml", "");
            PDVDinoTipoFechamentoController controller = (PDVDinoTipoFechamentoController)tipoFechamentoForm.getUserData();
            controller.inicializa();
            tipoFechamentoForm.showAndWait();
            if (controller.getPedidoFechamentoTipo() == null) {
                return;
            }
            if (controller.getPedidoFechamentoTipo().equals((Object)PedidoFechamentoTipo.FINALIZAR)) {
                System.out.println("== Colocar pedido em entrega");
                this.entrega();
            }
            if (controller.getPedidoFechamentoTipo().equals((Object)PedidoFechamentoTipo.FATURAR)) {
                this.faturamento();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void entrega() {
        Entregador entregador = null;
        try {
            Stage entregadorForm = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/dino/PDVDinoEntregador.fxml", "");
            PDVDinoEntregadorController controller = (PDVDinoEntregadorController)entregadorForm.getUserData();
            controller.inicializa();
            entregadorForm.showAndWait();
            entregador = controller.getEntregador();
        }
        catch (IOException iOException) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: Falha ao carregar os entregadores.");
            return;
        }
        if (entregador == null) {
            return;
        }
        try {
            this.vendaProdutoService.salva(this.pedido, this.cliente, TipoMovimentacao.PEDIDO_VENDA, entregador);
            this.inicializaPedido();
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void faturamento() {
        if (this.pedido.getTotal().compareTo(BigDecimal.ZERO) == 0) {
            try {
                VendaProduto venda = this.vendaProdutoService.fechamentoSemFaturamento(this.pedido, this.cliente);
                if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Troca efetuada com sucesso. Deseja imprimir o comprovante?")) {
                    this.vendaProdutoService.imprimeVenda(venda);
                }
                this.inicializaPedido();
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: Falha ao finalizar troca.");
            }
            return;
        }
        try {
            Stage formFechamento = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVFechamentoForm.fxml", "FINALIZAR PEDIDO");
            PDVFechamentoFormController controller = (PDVFechamentoFormController)formFechamento.getUserData();
            controller.inicializaFechamento(this.pedido);
            formFechamento.showAndWait();
            if (controller.getSucesso()) {
                VendaProduto vendaProduto = controller.getVendaProduto();
                Boolean emitirSat = MaximaConfig.getInstance().getProperty("sat_emitir", "n").equalsIgnoreCase("s");
                if (!emitirSat.booleanValue()) {
                    if (!MaximaConfig.pdvImprimeDireto().booleanValue()) {
                        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Venda emitida com sucesso. Deseja imprimir o comprovante de venda?")) {
                            this.imprimeVenda(vendaProduto);
                        }
                    } else {
                        this.imprimeVenda(vendaProduto);
                    }
                }
                this.inicializaPedido();
            } else {
                this.pedido = this.pedidoService.getById(this.pedido.getId());
                this.inicializaItem();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o form de fechamento de pedido.\n" + ex.getMessage()));
        }
    }

    private void imprimeVenda(VendaProduto vendaProduto) {
        try {
            this.vendaProdutoService.imprimeVenda(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido n\u00e3o impressora. \nFalha na comunica\u00e7\u00e3o com a impress\u00e3o.");
        }
    }

    private void cancelaPedido() {
        VendaProduto condicional;
        if (this.pedido == null || this.pedido.getId() == null) {
            return;
        }
        if (this.pedido.getTipoMovimentacao() != null && this.pedido.getTipoMovimentacao().equals((Object)TipoMovimentacao.CONDICIONAL) ? (condicional = this.vendaProdutoService.getByPedido(this.pedido.getId())) != null && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja EXCLUIR a condicional?") : !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja cancelar o pedido em andamento?")) {
            return;
        }
        try {
            this.pedidoService.cancela(this.pedido);
            this.inicializaPedido();
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Pedido cancelado com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void listaVendas() {
        try {
            Stage stage = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/VendaProdutoPDV.fxml", "Pedidos Recentes");
            VendaProdutoPDVController controller = (VendaProdutoPDVController)stage.getUserData();
            controller.inicializa(this.controleSAT, this.conf);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir janela de vendas.\n" + ex.getMessage()));
        }
    }

    private void listaVendasEmEntrega() {
        VendaProduto venda = null;
        try {
            Stage stage = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/dino/PDVDinoEntregas.fxml", "Pedidos Recentes");
            PDVDinoEntregasController controller = (PDVDinoEntregasController)stage.getUserData();
            controller.inicializa(this.conf);
            stage.showAndWait();
            venda = controller.getVendaSelecionada();
        }
        catch (IOException ex) {
            Logger.getLogger(PrincipalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir janela de vendas.\n" + ex.getMessage()));
        }
        if (venda != null) {
            this.pedido = this.pedidoService.getById(venda.getPedido().getId());
            this.pedido.setPedidoStatus(null);
            this.pedido = this.pedidoService.salva(this.pedido);
            this.cliente = this.pedido.getCliente();
            this.comboVendedor.getSelectionModel().select((Object)this.pedido.getVendedor());
            this.carregaCliente();
            this.inicializaItem();
        }
    }

    private void cancelaItem() {
        String valor;
        if (this.pedido == null || this.pedido.getId() == null) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVGetItemForm.fxml", "Pesquisar item");
            PDVGetItemFormController controller = (PDVGetItemFormController)form.getUserData();
            form.showAndWait();
            valor = controller.getRetorno();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel excluir item.");
            return;
        }
        PedidoItem item = this.pedidoService.getPorCodigoOuNumeroItem(valor, this.pedido);
        if (item == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Item n\u00e3o encontrado.");
            return;
        }
        this.deleteItem(item);
    }

    private BigDecimal getValorUnitario() {
        BigDecimal valorUnitario = BigDecimal.ZERO;
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/GetValorForm.fxml", "Informe o valor unit\u00e1rio");
            GetValorFormController controller = (GetValorFormController)form.getUserData();
            form.showAndWait();
            valorUnitario = controller.getValor();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return valorUnitario;
    }

    private void sangriaCaixa() {
        try {
            Stage sangriaForm = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/financeiro/movimentoCaixa/SangriaForm.fxml", "SANGRIA");
            MovimentoCaixaSangriaFormController controller = (MovimentoCaixaSangriaFormController)sangriaForm.getUserData();
            controller.inicializa();
            sangriaForm.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel eftuar sangria.");
        }
    }

    private void suprimentoCaixa() {
        try {
            Stage sangriaForm = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.vBox.getScene().getWindow(), "/fxml/financeiro/movimentoCaixa/SuprimentoForm.fxml", "SUPRIMENTO");
            MovimentoCaixaSuprimentoFormController controller = (MovimentoCaixaSuprimentoFormController)sangriaForm.getUserData();
            controller.inicializa();
            sangriaForm.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o \u00e9 poss\u00edvel eftuar suprimento.");
        }
    }

    private void formataCampos() {
    }
}

