/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.dino.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.controller.PDVFechamentoFormController;
import br.com.maximasolutions.estoque.dino.controller.PDVDinoController;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.PedidoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PDVDinoEntregasController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnImprimeVenda;
    @FXML
    private Button btnFechar;
    @FXML
    private Button btnEdita;
    @FXML
    private TableView<VendaProduto> tabela;
    @FXML
    private TableColumn<VendaProduto, String> colCliente;
    @FXML
    private TableColumn<VendaProduto, String> colCodigo;
    @FXML
    private TableColumn<VendaProduto, String> colObservacao;
    @FXML
    private TableColumn<VendaProduto, String> colData;
    @FXML
    private TableColumn<VendaProduto, BigDecimal> colTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private PedidoService pedidoService;
    private Configuracao conf;
    private VendaProduto vendaSelecionada;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.selecionaVenda();
            }
        });
        this.setColumnProperties();
        this.registraAcoes();
    }

    public void inicializa() {
        this.vendaSelecionada = null;
    }

    public VendaProduto getVendaSelecionada() {
        return this.vendaSelecionada;
    }

    private void finaliza(VendaProduto vendaProduto) {
        System.out.println("");
        try {
            this.pedidoService.finalizaEntrega(vendaProduto.getPedido());
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVDinoEntregasController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Falha ao marcar pedido como entregue.");
        }
        this.fecharForm();
    }

    private void selecionaVenda() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            return;
        }
        if (vendaProduto.getTotal().compareTo(BigDecimal.ZERO) == 0) {
            try {
                vendaProduto = this.vendaProdutoService.fechamentoSemFaturamento(vendaProduto.getPedido(), vendaProduto.getCliente());
                if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Troca efetuada com sucesso. Deseja imprimir o comprovante?")) {
                    this.vendaProdutoService.imprimeVenda(vendaProduto);
                }
                this.finaliza(vendaProduto);
            }
            catch (MaximaException ex) {
                Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: Falha ao finalizar troca.");
            }
            return;
        }
        try {
            Stage formFechamento = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.btnFechar.getScene().getWindow(), "/fxml/estoque/vendaProduto/PDVFechamentoForm.fxml", "FINALIZAR PEDIDO");
            PDVFechamentoFormController controller = (PDVFechamentoFormController)formFechamento.getUserData();
            controller.inicializaFechamento(vendaProduto.getPedido());
            formFechamento.showAndWait();
            if (controller.getSucesso()) {
                vendaProduto = controller.getVendaProduto();
                if (!MaximaConfig.pdvImprimeDireto().booleanValue()) {
                    if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Venda emitida com sucesso. Deseja imprimir o comprovante de venda?")) {
                        this.imprimeVenda(vendaProduto);
                    }
                } else {
                    this.imprimeVenda(vendaProduto);
                }
                this.finaliza(vendaProduto);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PDVDinoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o form de fechamento de pedido.\n" + ex.getMessage()));
        }
    }

    private void imprimeVenda(VendaProduto vendaProduto) {
        try {
            this.vendaProdutoService.imprimeVenda(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Pedido n\u00e3o impressora. \nFalha na comunica\u00e7\u00e3o com a impress\u00e3o.");
        }
    }

    public void inicializa(Configuracao configuracao) {
        this.conf = configuracao;
        this.loadTabela();
    }

    private void imprimeVendaSelecionada() {
        VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (vendaProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o.");
            return;
        }
        try {
            this.vendaProdutoService.imprimeVenda(vendaProduto);
        }
        catch (MaximaException ex) {
            Logger.getLogger(PDVDinoEntregasController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("entregador"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.tabela.setRowFactory(tv -> new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadTabela() {
        this.tabela.setItems(FXCollections.observableArrayList((Collection)this.vendaProdutoService.listaEmEntrega("")));
    }

    private void carregaIcones() {
        this.btnImprimeVenda.setGraphic((Node)new MaximaIcone().print());
        this.btnFechar.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void registraAcoes() {
        this.btnImprimeVenda.setOnAction(event -> this.imprimeVendaSelecionada());
        this.btnFechar.setOnAction(evt -> this.fecharForm());
        this.btnEdita.setOnAction(event -> {
            VendaProduto vendaProduto = (VendaProduto)this.tabela.getSelectionModel().getSelectedItem();
            if (vendaProduto == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o.");
                return;
            }
            this.vendaSelecionada = vendaProduto;
            this.fecharForm();
        });
    }

    private void fecharForm() {
        Stage stage = (Stage)this.btnFechar.getScene().getWindow();
        stage.close();
    }
}

