/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.bean;

import br.com.maximasolutions.estoque.modelo.Produto;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class RelatorioEstoqueBaixoBean {
    private String codigo;
    private String produto;
    private BigDecimal estoqueAtual;
    private BigDecimal estoqueMinimo;
    private BigDecimal diferenca;
    private BigDecimal ultimoCusto;
    private BigDecimal total;

    public RelatorioEstoqueBaixoBean(Produto produto) {
        this.codigo = produto.getCodigo();
        this.produto = produto.getNome().toUpperCase();
        this.estoqueAtual = produto.getEstoqueAtual();
        this.estoqueMinimo = produto.getEstoqueMinimo();
        this.ultimoCusto = produto.getUltimoCusto();
        this.diferenca = this.estoqueMinimo.subtract(this.estoqueAtual);
        this.total = this.diferenca.multiply(this.ultimoCusto).setScale(2, RoundingMode.HALF_EVEN);
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getProduto() {
        return this.produto;
    }

    public BigDecimal getEstoqueAtual() {
        return this.estoqueAtual;
    }

    public BigDecimal getEstoqueMinimo() {
        return this.estoqueMinimo;
    }

    public BigDecimal getDiferenca() {
        return this.diferenca;
    }

    public BigDecimal getUltimoCusto() {
        return this.ultimoCusto;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setProduto(String produto) {
        this.produto = produto;
    }

    public void setEstoqueAtual(BigDecimal estoqueAtual) {
        this.estoqueAtual = estoqueAtual;
    }

    public void setEstoqueMinimo(BigDecimal estoqueMinimo) {
        this.estoqueMinimo = estoqueMinimo;
    }

    public void setDiferenca(BigDecimal diferenca) {
        this.diferenca = diferenca;
    }

    public void setUltimoCusto(BigDecimal ultimoCusto) {
        this.ultimoCusto = ultimoCusto;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }
}

