/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.ImpressoraModelo;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaImpressao;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.core.print.MaximaPrinter;
import br.com.maximasolutions.estoque.bean.RelatorioProdutoListaBean;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoFoto;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioProdutosController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private ComboBox<CategoriaProduto> cbbCategoria;
    @FXML
    private TextField tfNome;
    @FXML
    private CheckBox ccbEstoqueMinimo;
    @FXML
    private CheckBox ccbEstoquePositivo;
    @FXML
    private CheckBox cbbImpressoraTermica;
    @FXML
    private CheckBox ccbComFoto;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.tfNome.setText("");
        this.ccbEstoqueMinimo.setSelected(false);
    }

    private void geraRelatorio() {
        List produtos = this.produtoService.relatorioLista((CategoriaProduto)this.cbbCategoria.getSelectionModel().getSelectedItem(), Boolean.valueOf(this.ccbEstoqueMinimo.isSelected()), Boolean.valueOf(this.ccbEstoquePositivo.isSelected()), MaximaUtils.getText((String)this.tfNome.getText()));
        if (produtos == null || produtos.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Nenhum registro encontrado para o filtro informado.");
            return;
        }
        ArrayList<RelatorioProdutoListaBean> lista = new ArrayList<RelatorioProdutoListaBean>();
        BigDecimal totalEstoque = BigDecimal.ZERO;
        BigDecimal totalCusto = BigDecimal.ZERO;
        BigDecimal totalVenda = BigDecimal.ZERO;
        BigDecimal somaCustoUnitario = BigDecimal.ZERO;
        BigDecimal somaVendaUnitario = BigDecimal.ZERO;
        BigDecimal somaLucroMedia = BigDecimal.ZERO;
        for (Produto produto : produtos) {
            ProdutoFoto foto;
            BigDecimal estoque = produto.getEstoqueAtual();
            if (estoque.compareTo(BigDecimal.ZERO) < 0) {
                estoque = BigDecimal.ZERO;
            }
            BigDecimal valorLucro = produto.getPrecoVenda().subtract(produto.getUltimoCusto());
            BigDecimal lucro = new BigDecimal("100");
            if (produto.getPrecoVenda().compareTo(BigDecimal.ZERO) > 0) {
                lucro = valorLucro.multiply(new BigDecimal("100")).divide(produto.getPrecoVenda(), 2, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
            }
            RelatorioProdutoListaBean bean = new RelatorioProdutoListaBean();
            bean.setReferencia(produto.getReferencia());
            bean.setCodigo(produto.getCodigo());
            bean.setProduto(produto.getNome().toUpperCase());
            bean.setUnidade(produto.getUnidade().getSigla());
            bean.setEstoque(produto.getEstoqueAtual());
            bean.setCusto(produto.getUltimoCusto());
            bean.setCustoTotal(estoque.multiply(produto.getUltimoCusto()).setScale(2, RoundingMode.HALF_EVEN));
            bean.setVenda(produto.getPrecoVenda());
            bean.setVendaTotal(estoque.multiply(produto.getPrecoVenda()).setScale(2, RoundingMode.CEILING));
            bean.setLucro(lucro);
            bean.setOrdem(Integer.valueOf(produto.getOrdem()));
            if (this.ccbComFoto.isSelected() && (foto = this.produtoService.getFotoPrincipal(produto.getId())) != null) {
                bean.setFoto((InputStream)new ByteArrayInputStream(foto.getBytes()));
            }
            lista.add(bean);
            totalEstoque = totalEstoque.add(estoque);
            totalCusto = totalCusto.add(bean.getCustoTotal());
            totalVenda = totalVenda.add(bean.getVendaTotal());
            somaCustoUnitario = somaCustoUnitario.add(produto.getUltimoCusto());
            somaVendaUnitario = somaVendaUnitario.add(produto.getPrecoVenda());
            somaLucroMedia = somaLucroMedia.add(lucro);
        }
        Configuracao conf = this.configuracaoService.load();
        if (!this.cbbImpressoraTermica.isSelected() || conf.getImpressoraModelo().equals((Object)ImpressoraModelo.A4)) {
            this.relatorioJasper(lista, totalEstoque, totalVenda, totalCusto, somaCustoUnitario, somaVendaUnitario, somaLucroMedia, conf);
        } else {
            Collections.sort(lista);
            this.miniRelatorio(conf, lista, totalEstoque);
        }
    }

    private void miniRelatorio(Configuracao conf, List<RelatorioProdutoListaBean> lista, BigDecimal totalEstoque) {
        MaximaPrinter maximaPrinter = new MaximaPrinter(conf.getImpressoraModelo());
        String texto = maximaPrinter.iniciaImpressao();
        texto = texto + maximaPrinter.getLinhaSimples48Colunas();
        texto = texto + maximaPrinter.negrita("RELAT\u00d3RIO ESTOQUE PRODUTO") + "\n";
        texto = texto + "DATA EMISS\u00c3O: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")) + "\n";
        texto = texto + maximaPrinter.getLinhaSimples48Colunas();
        texto = texto + MaximaUtils.completaDireita((String)"PRODUTO", (String)" ", (int)40) + MaximaUtils.completaEsquerda((String)"QTDE", (String)" ", (int)6) + "\n";
        texto = texto + maximaPrinter.getLinhaSimples48Colunas();
        for (RelatorioProdutoListaBean bean : lista) {
            texto = texto + MaximaUtils.completaDireita((String)bean.getProduto(), (String)" ", (int)40) + MaximaUtils.completaEsquerda((String)MaximaNumber.quantidadeToString((BigDecimal)bean.getEstoque()), (String)" ", (int)6) + "\n";
        }
        texto = texto + maximaPrinter.finalizaImpressao();
        try {
            new MaximaImpressao(conf).printText(texto);
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(RelatorioProdutosController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: Falha ao imprimir relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void relatorioJasper(List<RelatorioProdutoListaBean> lista, BigDecimal totalEstoque, BigDecimal totalVenda, BigDecimal totalCusto, BigDecimal somaCustoUnitario, BigDecimal somaVendaUnitario, BigDecimal somaLucroMedia, Configuracao conf) {
        try {
            Integer quantidadeProdutos = lista.size();
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            params.put("QTDE_PRODUTOS", quantidadeProdutos);
            params.put("QTDE_ESTOQUE", totalEstoque);
            params.put("TOTAL_CUSTO", totalCusto);
            params.put("TOTAL_VENDA", totalVenda);
            params.put("CUSTO_MEDIA", somaCustoUnitario.divide(new BigDecimal(quantidadeProdutos), 2, RoundingMode.HALF_EVEN));
            params.put("VENDA_MEDIA", somaVendaUnitario.divide(new BigDecimal(quantidadeProdutos), 2, RoundingMode.HALF_EVEN));
            params.put("LUCRO_MEDIA", somaLucroMedia.divide(new BigDecimal(quantidadeProdutos), 2, RoundingMode.HALF_EVEN));
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(lista);
            String jasper = "lista-produtos.jasper";
            if (this.ccbComFoto.isSelected()) {
                jasper = "produtos_foto.jasper";
            }
            new PrintReport().showReport("/jasper/estoque/produto/" + jasper, (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioProdutosController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void carregaIcones() {
        this.btnGeraRelatorio.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
    }

    private void loadCombos() {
        this.cbbCategoria.setItems(FXCollections.observableArrayList((Collection)this.categoriaProdutoService.combo()));
    }
}

